/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.util;

import com.cinchapi.concourse.util.QuoteAwareStringSplitter;
import com.cinchapi.concourse.util.SplitOption;
import com.cinchapi.concourse.util.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public class StringSplitter {
    protected final int options;
    protected int pos = 0;
    private char[] chars;
    private final char delimiter;
    private boolean ignoreLF = false;
    private boolean lastEOL = false;
    private String next = null;
    private boolean nextEOL = false;
    private boolean overrideEmptyNext = false;
    private int start = 0;

    public StringSplitter(String string) {
        this(string, ' ');
    }

    public StringSplitter(String string, char delimiter) {
        this(string, delimiter, SplitOption.NONE);
    }

    public StringSplitter(String string, char delimiter, SplitOption ... options) {
        this.chars = string.toCharArray();
        this.delimiter = delimiter;
        int opts = 0;
        for (SplitOption option : options) {
            opts |= 1 << option.mask();
        }
        this.options = opts;
        this.findNext();
    }

    public StringSplitter(String string, SplitOption ... options) {
        this(string, ' ', options);
    }

    public boolean atEndOfLine() {
        return this.lastEOL;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public String next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        String result = this.next;
        if (this.lastEOL) {
            this.lastEOL = false;
        }
        if (this.nextEOL) {
            this.lastEOL = true;
            this.nextEOL = false;
        }
        this.findNext();
        return result;
    }

    public void reset() {
        this.pos = 0;
        this.start = 0;
    }

    public String[] toArray() {
        ArrayList toks = Lists.newArrayList();
        while (this.hasNext()) {
            toks.add(this.next());
        }
        return toks.toArray(new String[0]);
    }

    protected boolean confirmSetNext() {
        return true;
    }

    protected boolean isReadyToSplit() {
        return true;
    }

    protected void updateIsReadyToSplit(char c) {
    }

    private void findNext() {
        this.nextEOL = false;
        this.next = null;
        boolean resetOverrideEmptyNext = true;
        boolean processOverrideEmptyNext = true;
        while (this.pos < this.chars.length && this.next == null) {
            boolean resetIgnoreLF = true;
            char c = this.chars[this.pos];
            ++this.pos;
            if (c == this.delimiter && this.isReadyToSplit()) {
                this.setNext();
            } else if (SplitOption.SPLIT_ON_NEWLINE.isEnabled(this) && c == '\n' && this.isReadyToSplit()) {
                if (this.ignoreLF) {
                    this.start = this.pos;
                } else {
                    this.setNext();
                    this.nextEOL = true;
                }
            } else if (SplitOption.SPLIT_ON_NEWLINE.isEnabled(this) && c == '\r' && this.isReadyToSplit()) {
                this.ignoreLF = true;
                resetIgnoreLF = false;
                this.setNext();
                this.nextEOL = true;
            } else if (SplitOption.TOKENIZE_PARENTHESIS.isEnabled(this) && (c == '(' || c == ')') && this.isReadyToSplit()) {
                this.setNext();
                if (this.next.isEmpty()) {
                    this.next = Strings.valueOfCached(c);
                    this.overrideEmptyNext = true;
                    processOverrideEmptyNext = false;
                    resetOverrideEmptyNext = false;
                } else {
                    this.start = --this.pos;
                }
            }
            this.ignoreLF = resetIgnoreLF ? false : this.ignoreLF;
            this.updateIsReadyToSplit(c);
        }
        if (this.pos == this.chars.length && this.next == null) {
            if (this.confirmSetNext()) {
                int length = this.pos - this.start;
                if (length == 0) {
                    this.next = "";
                } else {
                    length = this.trim(length);
                    this.next = String.valueOf(this.chars, this.start, length);
                }
                ++this.pos;
            } else {
                this.findNext();
            }
        }
        if (this.next != null && this.next.isEmpty()) {
            boolean atEnd = true;
            for (int i = this.pos; i < this.chars.length; ++i) {
                if (this.chars[i] == this.delimiter) continue;
                atEnd = false;
                break;
            }
            String string = this.next = atEnd ? null : this.next;
        }
        if (this.overrideEmptyNext && processOverrideEmptyNext) {
            if (this.next != null && this.next.isEmpty()) {
                this.findNext();
            }
            resetOverrideEmptyNext = true;
        }
        boolean bl = this.overrideEmptyNext = resetOverrideEmptyNext ? false : this.overrideEmptyNext;
        if (this.next != null && SplitOption.DROP_QUOTES.isEnabled(this) && Strings.isWithinQuotes(this.next) && this instanceof QuoteAwareStringSplitter) {
            this.next = this.next.substring(1, this.next.length() - 1);
        }
    }

    private void setNext() {
        if (this.confirmSetNext()) {
            int length = this.pos - this.start - 1;
            if (length == 0) {
                this.next = "";
            } else {
                length = this.trim(length);
                this.next = String.valueOf(this.chars, this.start, length);
            }
            this.start = this.pos;
        } else {
            this.findNext();
        }
    }

    private int trim(int length) {
        if (SplitOption.TRIM_WHITESPACE.isEnabled(this)) {
            while (Character.isWhitespace(this.chars[this.start]) && length > 1) {
                ++this.start;
                --length;
            }
            while (Character.isWhitespace(this.chars[this.start + length - 1]) && length > 1) {
                --length;
            }
        }
        return length;
    }
}

