/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.util;

import com.cinchapi.common.base.Characters;
import com.cinchapi.concourse.util.DataServices;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.helpers.MessageFormatter;

public final class Strings {
    public static String ensureEndsWith(String string, String suffix) {
        if (string.endsWith(suffix)) {
            return string;
        }
        return Strings.joinSimple(string, suffix);
    }

    public static String ensureStartsWith(String string, String prefix) {
        if (string.startsWith(prefix)) {
            return string;
        }
        return Strings.joinSimple(prefix, string);
    }

    public static String ensureWithinQuotes(String string) {
        return Strings.isWithinQuotes(string) ? string : Strings.joinSimple("\"", string, "\"");
    }

    public static String ensureWithinQuotesIfNeeded(String string, char delimiter) {
        boolean foundDouble = false;
        boolean foundSingle = false;
        boolean foundDelimiter = false;
        StringBuilder escaped = new StringBuilder();
        escaped.append('\"');
        if (!Strings.isWithinQuotes(string)) {
            char[] chars = string.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (c == delimiter) {
                    foundDelimiter = true;
                } else if (c == '\"') {
                    foundDouble = true;
                    escaped.append('\\');
                } else if (c == '\'') {
                    foundSingle = true;
                }
                escaped.append(c);
            }
            escaped.append('\"');
            if (foundDelimiter) {
                if (foundDouble && foundSingle) {
                    return escaped.toString();
                }
                if (foundDouble) {
                    return Strings.format("'{}'", string);
                }
                return Strings.format("\"{}\"", string);
            }
        }
        return string;
    }

    public static String escapeInner(String string, char ... characters) {
        int i;
        char c = '\u0000';
        char pchar = '\u0000';
        StringBuilder sb = null;
        HashSet chars = null;
        if (characters.length == 1) {
            c = characters[0];
        } else {
            chars = Sets.newHashSetWithExpectedSize((int)characters.length);
            for (char ch : characters) {
                chars.add(Character.valueOf(ch));
            }
        }
        char[] schars = string.toCharArray();
        int offset = 0;
        for (i = 0; i < schars.length; ++i) {
            if (i <= 0 || i >= schars.length - 1) continue;
            char schar = schars[i];
            if (pchar != '\\' && (c != '\u0000' && c == schar || chars != null && chars.contains(Character.valueOf(schar)))) {
                sb = (StringBuilder)MoreObjects.firstNonNull((Object)sb, (Object)new StringBuilder());
                sb.append(schars, offset, i - offset);
                sb.append('\\');
                char escaped = Characters.getEscapedCharOrNullLiteral((char)schar);
                if (escaped != '0') {
                    sb.append(escaped);
                } else {
                    sb.append(schar);
                }
                offset = i + 1;
            }
            pchar = schar;
        }
        if (sb != null) {
            sb.append(schars, offset, i - offset);
            return sb.toString();
        }
        return string;
    }

    public static String replaceUnicodeConfusables(String string) {
        char[] chars = string.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            int c = chars[i];
            switch (c) {
                default: {
                    break;
                }
                case 698: 
                case 733: 
                case 750: 
                case 758: 
                case 1522: 
                case 1524: 
                case 8220: 
                case 8221: 
                case 8223: 
                case 8243: 
                case 8246: 
                case 12291: 
                case 65282: {
                    c = 34;
                }
            }
            chars[i] = c;
        }
        return String.valueOf(chars);
    }

    public static String format(String pattern, Object ... params) {
        return MessageFormatter.arrayFormat((String)pattern, (Object[])params).getMessage();
    }

    public static Set<String> getAllSubStrings(String string) {
        HashSet result = Sets.newHashSet();
        for (int i = 0; i < string.length(); ++i) {
            for (int j = i + 1; j <= string.length(); ++j) {
                String substring = string.substring(i, j).trim();
                if (com.google.common.base.Strings.isNullOrEmpty((String)substring)) continue;
                result.add(substring);
            }
        }
        return result;
    }

    public static boolean isSubString(String needle, String haystack) {
        if (needle.length() > haystack.length()) {
            return false;
        }
        if (needle.length() == haystack.length()) {
            return needle.equals(haystack);
        }
        char[] n = needle.toCharArray();
        char[] h = haystack.toCharArray();
        int npos = 0;
        int hpos = 0;
        int stop = h.length - n.length;
        int hstart = -1;
        while (hpos < h.length && npos < n.length) {
            char hi = h[hpos];
            char ni = n[npos];
            if (hi == ni) {
                if (hstart == -1) {
                    hstart = hpos;
                }
                ++npos;
                ++hpos;
                continue;
            }
            if (npos > 0) {
                npos = 0;
                hpos = hstart + 1;
                hstart = -1;
            } else {
                ++hpos;
            }
            if (hpos <= stop) continue;
            return false;
        }
        return npos == n.length;
    }

    public static boolean isValidJson(String json) {
        char first = json.charAt(0);
        char last = json.charAt(json.length() - 1);
        if (!(first != '[' && first != '{' || last != ']' && last != '}')) {
            try {
                DataServices.jsonParser().parse(json);
                return true;
            }
            catch (JsonParseException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isWithinQuotes(String string) {
        char first;
        if (string.length() > 2 && ((first = string.charAt(0)) == '\"' || first == '\'')) {
            char last = string.charAt(string.length() - 1);
            return first == last;
        }
        return false;
    }

    public static String join(char separator, Object ... args) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            builder.append(args[i]);
            builder.append(separator);
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    public static String join(String separator, Object ... args) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            builder.append(args[i]);
            builder.append(separator);
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    public static String joinSimple(Object ... args) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            builder.append(args[i]);
        }
        return builder.toString();
    }

    public static String joinWithSpace(Object ... args) {
        return Strings.join(' ', args);
    }

    @Deprecated
    public static String[] splitButRespectQuotes(String string) {
        return Strings.splitStringByDelimiterButRespectQuotes(string, " ");
    }

    public static List<String> splitCamelCase(String string) {
        ArrayList words = Lists.newArrayList();
        char[] chars = string.toCharArray();
        StringBuilder word = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (Character.isUpperCase(c) || c == '$') {
                if (word.length() > 0) {
                    words.add(word.toString());
                }
                word.setLength(0);
            }
            word.append(c);
        }
        words.add(word.toString());
        return words;
    }

    public static String[] splitStringByDelimiterButRespectQuotes(String string, String delimiter) {
        string = string.replaceAll(" '", " \"");
        string = string.replaceAll("' ", "\" ");
        string = string.replaceAll("'$", "\"");
        return string.split(delimiter + "(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
    }

    public static Boolean tryParseBoolean(String value) {
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        return null;
    }

    @Nullable
    public static Number tryParseNumber(String value) {
        int size = value.length();
        if (value == null || size == 0) {
            return null;
        }
        if (value.charAt(0) == '0' && size > 1 && value.charAt(1) != '.') {
            return null;
        }
        boolean decimal = false;
        for (int i = 0; i < size; ++i) {
            char c = value.charAt(i);
            if (Character.isDigit(c) || i == 0 && c == '-') continue;
            if (c == '.') {
                if (!decimal && size > 1) {
                    decimal = true;
                    continue;
                }
                return null;
            }
            if (i == size - 1 && c == 'D' && size > 1) {
                return Double.valueOf(value.substring(0, i));
            }
            return null;
        }
        try {
            if (decimal) {
                double d = Doubles.tryParse((String)value);
                float f = Floats.tryParse((String)value).floatValue();
                if (String.valueOf(d).equals(String.valueOf(f))) {
                    return Float.valueOf(f);
                }
                return d;
            }
            if (value.equals("-")) {
                return null;
            }
            return (Number)MoreObjects.firstNonNull((Object)Ints.tryParse((String)value), (Object)Longs.tryParse((String)value));
        }
        catch (NullPointerException e) {
            throw new NumberFormatException(Strings.format("{} appears to be a number but cannot be parsed as such", value));
        }
    }

    @Nullable
    public static Number tryParseNumberStrict(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        char last = value.charAt(value.length() - 1);
        if (Character.isDigit(last)) {
            return Strings.tryParseNumber(value);
        }
        return null;
    }

    public static String valueOfCached(char c) {
        if (c == '(') {
            return "(";
        }
        if (c == ')') {
            return ")";
        }
        return String.valueOf(c);
    }

    private Strings() {
    }
}

