/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.SortedSet;

public class TSets {
    public static <T> Set<T> intersection(Set<T> a, Set<T> b) {
        if (a instanceof SortedSet && b instanceof SortedSet) {
            return TSets.sortedIntersection((SortedSet)a, (SortedSet)b);
        }
        LinkedHashSet intersection = Sets.newLinkedHashSet();
        Set<T> smaller = a.size() <= b.size() ? a : b;
        HashSet larger = Sets.newHashSet(a.size() > b.size() ? a : b);
        for (T element : smaller) {
            if (!larger.contains(element)) continue;
            intersection.add(element);
        }
        return intersection;
    }

    public static Set<Long> sequence(long from, long to) {
        Preconditions.checkArgument((from <= to ? 1 : 0) != 0);
        int size = (int)(to - from);
        LinkedHashSet sequence = Sets.newLinkedHashSetWithExpectedSize((int)size);
        for (long i = from; i <= to; ++i) {
            sequence.add(i);
        }
        return sequence;
    }

    public static <T> Set<T> union(Set<T> a, Set<T> b) {
        LinkedHashSet union = Sets.newLinkedHashSet(a);
        union.addAll(b);
        return union;
    }

    private static <T> Set<T> sortedIntersection(SortedSet<T> a, SortedSet<T> b) {
        LinkedHashSet intersection = Sets.newLinkedHashSet();
        if (a.isEmpty() || b.isEmpty()) {
            return intersection;
        }
        Iterator ait = a.iterator();
        Iterator bit = b.iterator();
        Comparator comp = a.comparator();
        boolean ago = true;
        boolean bgo = true;
        Object aelt = null;
        Object belt = null;
        while ((ago && ait.hasNext() || !ago) && (bgo && bit.hasNext() || !bgo)) {
            int order;
            aelt = ago ? (Object)ait.next() : aelt;
            belt = bgo ? (Object)bit.next() : belt;
            int n = order = comp == null ? ((Comparable)aelt).compareTo(belt) : comp.compare(aelt, belt);
            if (order == 0) {
                intersection.add(aelt);
                ago = true;
                bgo = true;
                continue;
            }
            if (order > 0) {
                bgo = true;
                ago = false;
                continue;
            }
            ago = true;
            bgo = false;
        }
        return intersection;
    }
}

