/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.util;

import com.cinchapi.concourse.annotate.UtilityClass;
import com.cinchapi.concourse.util.PrettyLinkedHashMap;
import com.cinchapi.concourse.util.ReadOnlyIterator;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

@UtilityClass
public final class Transformers {
    public static <F, V> V[] transformArray(F[] original, Function<? super F, ? extends V> function, Class<V> vClass) {
        Object[] transformed = (Object[])Array.newInstance(vClass, original.length);
        for (int i = 0; i < original.length; ++i) {
            F item = original[i];
            transformed[i] = function.apply(item);
        }
        return transformed;
    }

    public static <K, K2, V> Map<K2, V> transformMap(Map<K, V> original, Function<? super K, ? extends K2> function) {
        PrettyLinkedHashMap<Object, V> transformed = PrettyLinkedHashMap.newPrettyLinkedHashMap();
        for (Map.Entry<K, V> entry : original.entrySet()) {
            transformed.put(function.apply(entry.getKey()), entry.getValue());
        }
        return transformed;
    }

    public static <K, K2, V, V2> Map<K2, Set<V2>> transformMapSet(Map<K, Set<V>> original, Function<? super K, ? extends K2> keys, Function<? super V, ? extends V2> values) {
        LinkedHashMap transformed = Maps.newLinkedHashMap();
        for (Map.Entry<K, Set<V>> entry : original.entrySet()) {
            transformed.put(keys.apply(entry.getKey()), Transformers.transformSet(entry.getValue(), values));
        }
        return transformed;
    }

    public static <K, V, V2> Map<K, V2> transformMapValues(Map<K, V> original, Function<V, V2> function) {
        LinkedHashMap transformed = Maps.newLinkedHashMap();
        for (Map.Entry<K, V> entry : original.entrySet()) {
            transformed.put(entry.getKey(), function.apply(entry.getValue()));
        }
        return transformed;
    }

    public static <K1, V1, K2, V2> Map<K2, V2> transformMapEntries(Map<K1, V1> original, Function<K1, K2> keyFunction, Function<V1, V2> valueFunction) {
        LinkedHashMap transformed = Maps.newLinkedHashMap();
        for (Map.Entry<K1, V1> entry : original.entrySet()) {
            transformed.put(keyFunction.apply(entry.getKey()), valueFunction.apply(entry.getValue()));
        }
        return transformed;
    }

    public static <F, V> Set<V> transformSet(Set<F> original, Function<? super F, ? extends V> function) {
        LinkedHashSet transformed = Sets.newLinkedHashSetWithExpectedSize((int)original.size());
        for (F item : original) {
            transformed.add(function.apply(item));
        }
        return transformed;
    }

    public static <V1, V2> Set<V2> transformSetLazily(Set<V1> original, Function<V1, V2> function) {
        return new LazyTransformSet<V1, V2>(original, function);
    }

    public static <K, K2, V, V2> Map<K2, Set<V2>> transformTreeMapSet(Map<K, Set<V>> original, Function<? super K, ? extends K2> keys, Function<? super V, ? extends V2> values, Comparator<K2> sorter) {
        TreeMap transformed = Maps.newTreeMap(sorter);
        for (Map.Entry<K, Set<V>> entry : original.entrySet()) {
            transformed.put(keys.apply(entry.getKey()), Transformers.transformSet(entry.getValue(), values));
        }
        return transformed;
    }

    public static class LazyTransformSet<V1, V2>
    extends AbstractSet<V2> {
        private final Function<V1, V2> function;
        private final Set<V1> original;

        public LazyTransformSet(Set<V1> original, Function<V1, V2> function) {
            this.original = original;
            this.function = function;
        }

        @Override
        public Iterator<V2> iterator() {
            return new ReadOnlyIterator<V2>(){
                Iterator<V1> backing;
                {
                    this.backing = original.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.backing.hasNext();
                }

                @Override
                public V2 next() {
                    return function.apply(this.backing.next());
                }
            };
        }

        @Override
        public int size() {
            return this.original.size();
        }
    }
}

