/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.util;

import com.cinchapi.concourse.Link;
import com.cinchapi.concourse.Tag;
import com.cinchapi.concourse.Timestamp;
import com.cinchapi.concourse.thrift.TObject;
import com.cinchapi.concourse.util.Convert;
import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public class TypeAdapters {
    private static TypeAdapter<Object> JAVA_TYPE_ADAPTER = new TypeAdapter<Object>(){
        private final TypeAdapter<Object> generic = new Gson().getAdapter(Object.class);

        public Object read(JsonReader reader) throws IOException {
            return null;
        }

        public void write(JsonWriter writer, Object value) throws IOException {
            if (value instanceof Double) {
                value = (Double)value;
                writer.value(value.toString() + "D");
            } else if (value instanceof Link) {
                writer.value(value.toString());
            } else if (value instanceof Tag) {
                writer.value("'" + value.toString() + "'");
            } else if (value instanceof Number) {
                writer.value((Number)value);
            } else if (value instanceof Boolean) {
                writer.value(((Boolean)value).booleanValue());
            } else if (value instanceof String) {
                writer.value((String)value);
            } else if (value instanceof Timestamp) {
                writer.jsonValue("|" + ((Timestamp)value).getMicros() + "|");
            } else {
                this.generic.write(writer, value);
            }
        }
    };
    private static TypeAdapter<TObject> TOBJECT_TYPE_ADAPTER = new TypeAdapter<TObject>(){

        public TObject read(JsonReader in) throws IOException {
            return null;
        }

        public void write(JsonWriter out, TObject value) throws IOException {
            JAVA_TYPE_ADAPTER.write(out, Convert.thriftToJava(value));
        }
    };
    private static TypeAdapter<Map<?, ?>> MAP_TYPE_ADAPTER = new TypeAdapter<Map<?, ?>>(){

        public void write(JsonWriter out, Map<?, ?> value) throws IOException {
            out.beginObject();
            for (Map.Entry<?, ?> entry : value.entrySet()) {
                out.name(entry.getKey().toString());
                TypeAdapters.sendJsonValue(out, entry.getValue());
            }
            out.endObject();
        }

        public Map<String, ?> read(JsonReader in) throws IOException {
            return null;
        }
    };
    private static TypeAdapter<Collection<?>> COLLECTION_TYPE_ADAPTER = new TypeAdapter<Collection<?>>(){

        public Collection<?> read(JsonReader in) throws IOException {
            return null;
        }

        public void write(JsonWriter out, Collection<?> value) throws IOException {
            if (value.size() == 1) {
                TypeAdapters.sendJsonValue(out, Iterables.get(value, (int)0));
            } else {
                out.beginArray();
                for (Object element : value) {
                    TypeAdapters.sendJsonValue(out, element);
                }
                out.endArray();
            }
        }
    };

    public static TypeAdapter<Collection<?>> forCollection() {
        return COLLECTION_TYPE_ADAPTER;
    }

    public static TypeAdapter<Object> forGenericObject() {
        return JAVA_TYPE_ADAPTER;
    }

    public static TypeAdapter<TObject> forTObject() {
        return TOBJECT_TYPE_ADAPTER;
    }

    public static TypeAdapter<Map<?, ?>> forMap() {
        return MAP_TYPE_ADAPTER;
    }

    private static void sendJsonValue(JsonWriter out, Object value) throws IOException {
        if (value instanceof TObject) {
            TOBJECT_TYPE_ADAPTER.write(out, (Object)((TObject)value));
        } else if (value instanceof Collection) {
            COLLECTION_TYPE_ADAPTER.write(out, (Object)((Collection)value));
        } else if (value instanceof Map) {
            MAP_TYPE_ADAPTER.write(out, (Object)((Map)value));
        } else {
            JAVA_TYPE_ADAPTER.write(out, value);
        }
    }
}

