/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.util;

import com.google.common.primitives.Longs;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Version
implements Comparable<Version> {
    private final long major;
    private final long minor;
    private final long patch;
    private final String build;

    public static Version getVersion(Class<?> clazz) {
        return new Version(clazz);
    }

    private Version(Class<?> clazz) {
        String version = clazz.getPackage().getImplementationVersion();
        version = version == null ? "UNKNOWN" : version;
        String[] parts = version.split("\\.");
        if (parts.length == 4) {
            this.major = Long.parseLong(parts[0]);
            this.minor = Long.parseLong(parts[1]);
            this.patch = Long.parseLong(parts[2]);
            this.build = parts[3];
        } else {
            this.major = 0L;
            this.minor = 0L;
            this.patch = 0L;
            this.build = "0-SNAPSHOT";
        }
    }

    @Override
    public int compareTo(Version o) {
        int comp = Longs.compare((long)this.major, (long)o.major);
        return comp == 0 ? ((comp = Longs.compare((long)this.minor, (long)o.minor)) == 0 ? ((comp = Longs.compare((long)this.patch, (long)o.patch)) == 0 ? this.build.compareTo(o.build) : comp) : comp) : comp;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Version) {
            return this.compareTo((Version)obj) == 0;
        }
        return false;
    }

    public String getBuild() {
        return this.build;
    }

    public long getMajor() {
        return this.major;
    }

    public long getMinor() {
        return this.minor;
    }

    public long getPatch() {
        return this.patch;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch, this.build);
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch + "." + this.build;
    }
}

