/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.util;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;

public final class Versions {
    public static long toLongRepresentation(String version) {
        return Versions.toLongRepresentation(version, 3);
    }

    public static long toLongRepresentation(String version, int maxComponentLength) {
        String[] toks = version.split("\\.");
        int n = maxComponentLength;
        ArrayList parts = Lists.newArrayList();
        for (String tok : toks) {
            n = Math.max(n, tok.length());
        }
        for (String tok : toks) {
            parts.add(Integer.parseInt(Strings.padStart((String)tok, (int)n, (char)Character.forDigit(0, 10))));
        }
        long sum = 0L;
        for (int i = 0; i < parts.size(); ++i) {
            sum = (long)((double)sum + (double)((Integer)parts.get(i)).intValue() * Math.pow(10.0, n * parts.size() - (i + 1)));
        }
        return sum;
    }

    private Versions() {
    }
}

