/*
 * Decompiled with CFR 0.152.
 */
package org.imca_cat.pollingwatchservice;

import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;

class PollingWatchEvent<T>
implements WatchEvent<T> {
    private final WatchEvent.Kind<T> kind;
    private final T context;
    private int count;

    public PollingWatchEvent(WatchEvent.Kind<T> kind, T context) {
        this.kind = kind;
        this.context = context;
        this.count = 1;
    }

    @Override
    public WatchEvent.Kind<T> kind() {
        return this.kind;
    }

    public boolean isCreate() {
        return this.kind.equals(StandardWatchEventKinds.ENTRY_CREATE);
    }

    public boolean isModify() {
        return this.kind.equals(StandardWatchEventKinds.ENTRY_MODIFY);
    }

    public boolean isDelete() {
        return this.kind.equals(StandardWatchEventKinds.ENTRY_DELETE);
    }

    public boolean isOverflow() {
        return this.kind.equals(StandardWatchEventKinds.OVERFLOW);
    }

    @Override
    public int count() {
        return this.count;
    }

    public void incrementCount() {
        ++this.count;
    }

    @Override
    public T context() {
        return this.context;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PollingWatchEvent)) {
            return false;
        }
        PollingWatchEvent e = (PollingWatchEvent)o;
        if (!this.kind.equals(e.kind)) {
            return false;
        }
        return this.context.equals(e.context);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.kind.hashCode();
        result = 31 * result + this.context.hashCode();
        return result;
    }

    public String toString() {
        return String.format("%s: %s", this.kind, this.context);
    }

    public static PollingWatchEvent<Path> create(Path p) {
        return new PollingWatchEvent<Path>(StandardWatchEventKinds.ENTRY_CREATE, p);
    }

    public static PollingWatchEvent<Path> modify(Path p) {
        return new PollingWatchEvent<Path>(StandardWatchEventKinds.ENTRY_MODIFY, p);
    }

    public static PollingWatchEvent<Path> delete(Path p) {
        return new PollingWatchEvent<Path>(StandardWatchEventKinds.ENTRY_DELETE, p);
    }

    public static PollingWatchEvent<?> overflow(Object o) {
        return new PollingWatchEvent<Object>(StandardWatchEventKinds.OVERFLOW, o);
    }
}

