/*
 * Decompiled with CFR 0.152.
 */
package org.imca_cat.pollingwatchservice;

import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.Watchable;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.imca_cat.pollingwatchservice.PollingWatchEvent;
import org.imca_cat.pollingwatchservice.PollingWatchKeyState;
import org.imca_cat.pollingwatchservice.PollingWatchService;

class PollingWatchKey
implements WatchKey {
    private final PollingWatchService service;
    private final Path path;
    private final List<WatchEvent.Kind<?>> kinds;
    private final List<WatchEvent.Modifier> modifiers;
    private Map<Path, BasicFileAttributes> entries;
    private final List<PollingWatchEvent<?>> events;
    private final List<PollingWatchEvent<?>> eventsPending;
    private PollingWatchKeyState state;

    public PollingWatchKey(PollingWatchService service, Path path) {
        this(service, path, new WatchEvent.Kind[0], new WatchEvent.Modifier[0]);
    }

    public PollingWatchKey(PollingWatchService service, Path path, WatchEvent.Kind<?>[] kinds, WatchEvent.Modifier[] modifiers) {
        this(service, path, kinds, modifiers, null);
    }

    public PollingWatchKey(PollingWatchService service, Path path, WatchEvent.Kind<?>[] kinds, WatchEvent.Modifier[] modifiers, Map<Path, BasicFileAttributes> entries) {
        this.service = service;
        this.path = path;
        this.kinds = new ArrayList(Arrays.asList(kinds));
        this.modifiers = new ArrayList<WatchEvent.Modifier>(Arrays.asList(modifiers));
        this.entries = entries;
        this.events = new ArrayList();
        this.eventsPending = new ArrayList();
        this.state = PollingWatchKeyState.READY;
    }

    public synchronized boolean hasKindAndModifier(WatchEvent.Kind<?> k, WatchEvent.Modifier m) {
        return this.hasKind(k) && this.hasModifier(m);
    }

    public synchronized void kindsAndModifiers(WatchEvent.Kind<?>[] kinds, WatchEvent.Modifier[] modifiers) {
        this.kinds.clear();
        this.kinds.addAll(Arrays.asList(kinds));
        this.modifiers.clear();
        this.modifiers.addAll(Arrays.asList(modifiers));
    }

    public synchronized boolean hasKind(WatchEvent.Kind<?> k) {
        return this.kinds.contains(k);
    }

    public synchronized boolean hasModifier(WatchEvent.Modifier m) {
        return this.modifiers.contains(m);
    }

    public synchronized Map<Path, BasicFileAttributes> entries() {
        return Collections.unmodifiableMap(this.entries);
    }

    public synchronized void entries(Map<Path, BasicFileAttributes> entries) {
        this.entries = entries;
    }

    public synchronized boolean isReady() {
        return this.state.equals((Object)PollingWatchKeyState.READY);
    }

    public synchronized boolean isSignaled() {
        return this.state.equals((Object)PollingWatchKeyState.SIGNALED);
    }

    public synchronized boolean isInvalid() {
        return this.state.equals((Object)PollingWatchKeyState.INVALID);
    }

    @Override
    public synchronized boolean isValid() {
        return !this.isInvalid();
    }

    @Override
    public synchronized List<WatchEvent<?>> pollEvents() {
        ArrayList result = new ArrayList(this.events);
        this.events.clear();
        return result;
    }

    public synchronized void signal() {
        if (this.isInvalid()) {
            return;
        }
        if (this.isSignaled()) {
            return;
        }
        this.state = PollingWatchKeyState.SIGNALED;
    }

    public synchronized void enqueue() {
        if (this.isSignaled()) {
            return;
        }
        if (this.isReady()) {
            this.signal();
        }
        this.service.enqueue(this);
    }

    public synchronized void enqueueIfReadyAndHasEvents() {
        if (!this.isReady()) {
            return;
        }
        if (this.events.isEmpty()) {
            return;
        }
        this.signal();
        this.service.enqueue(this);
    }

    @Override
    public synchronized boolean reset() {
        if (this.isInvalid()) {
            return false;
        }
        if (this.isReady()) {
            return true;
        }
        this.events.addAll(this.eventsPending);
        this.eventsPending.clear();
        this.state = PollingWatchKeyState.READY;
        if (!this.events.isEmpty()) {
            this.enqueue();
        }
        return true;
    }

    @Override
    public synchronized void cancel() {
        if (this.isInvalid()) {
            return;
        }
        this.state = PollingWatchKeyState.INVALID;
    }

    @Override
    public Watchable watchable() {
        return this.path;
    }

    public Path watchablePath() {
        return this.path;
    }

    public synchronized void addEvent(PollingWatchEvent<?> e) {
        List<PollingWatchEvent<?>> l;
        List<PollingWatchEvent<?>> list = l = this.isReady() ? this.events : this.eventsPending;
        if (!l.isEmpty() && (e.isModify() || e.isOverflow())) {
            PollingWatchEvent<?> last = l.get(l.size() - 1);
            if (last.kind().equals(e.kind())) {
                last.incrementCount();
            } else {
                l.add(e);
            }
        } else {
            l.add(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PollingWatchKey)) {
            return false;
        }
        return this.path.equals(((PollingWatchKey)o).path);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.path.hashCode();
        return result;
    }

    public synchronized String toString() {
        return String.format("%s (state=%s, kinds=%s, modifiers=%s, entries)", new Object[]{this.path, this.state, this.kinds, this.modifiers, this.entries});
    }
}

