/*
 * Decompiled with CFR 0.152.
 */
package org.imca_cat.pollingwatchservice;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.imca_cat.pollingwatchservice.JavaUtilities;
import org.imca_cat.pollingwatchservice.PathWatchService;
import org.imca_cat.pollingwatchservice.PollingWatchEvent;
import org.imca_cat.pollingwatchservice.PollingWatchKey;
import org.imca_cat.pollingwatchservice.PollingWatchServiceExceptionHandler;
import org.imca_cat.pollingwatchservice.PollingWatchServiceInfoHandler;

public class PollingWatchService
implements PathWatchService {
    private final long period;
    private final TimeUnit periodUnit;
    private boolean useFileMetadata;
    private boolean started;
    private final BlockingQueue<PollingWatchKey> queue;
    private final ConcurrentHashMap<Path, PollingWatchKey> keys;
    private final ExecutorService executor;
    private final ScheduledExecutorService timer;
    private final PollingWatchServiceExceptionHandler exceptionHandler;
    private final PollingWatchServiceInfoHandler infoHandler;
    private final Object registerLock;
    private final PollingWatchKey closedSentinel;
    private final Object closeLock;
    private volatile boolean closed;
    private volatile boolean registerMethodEverInvoked;

    public PollingWatchService(int threadPoolSize, long period, TimeUnit unit) {
        this(threadPoolSize, period, unit, null, null);
    }

    public PollingWatchService(int threadPoolSize, long period, TimeUnit unit, PollingWatchServiceExceptionHandler handler, PollingWatchServiceInfoHandler infoHandler) {
        this.period = period;
        this.periodUnit = unit;
        this.useFileMetadata = true;
        this.started = false;
        this.queue = new LinkedBlockingQueue<PollingWatchKey>();
        this.keys = new ConcurrentHashMap(16, 0.75f, threadPoolSize);
        this.executor = Executors.newFixedThreadPool(threadPoolSize, new ThreadFactoryBuilder().setNameFormat("polling-watch-service-executor").setDaemon(true).build());
        this.timer = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("polling-watch-service-timer").setDaemon(true).build());
        this.exceptionHandler = handler != null ? handler : PollingWatchService.newDefaultExceptionHandler();
        this.infoHandler = infoHandler != null ? infoHandler : PollingWatchService.newDefaultInfoHandler();
        this.registerLock = new Object();
        this.closedSentinel = new PollingWatchKey(this, Paths.get("", new String[0]));
        this.closeLock = new Object();
        this.closed = false;
        this.registerMethodEverInvoked = false;
    }

    public boolean useFileMetadata() {
        return this.useFileMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useFileMetadata(boolean useFileMetadata) {
        if (this.registerMethodEverInvoked) {
            throw new IllegalStateException("Register method already invoked");
        }
        Object object = this.closeLock;
        synchronized (object) {
            if (this.started) {
                throw new IllegalStateException("Service already started");
            }
        }
        this.useFileMetadata = useFileMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                throw new ClosedWatchServiceException();
            }
            if (this.started) {
                throw new IllegalStateException("Already started");
            }
            this.started = true;
            this.timer.scheduleAtFixedRate(PollingWatchService.newPollForChangesRunnable(this), 0L, this.period, this.periodUnit);
        }
    }

    private void pollForChanges() throws InterruptedException {
        try {
            long startTime = System.nanoTime();
            ArrayList f = new ArrayList(this.keys.size());
            for (PollingWatchKey pollingWatchKey : this.keys.values()) {
                f.add(this.executor.submit(PollingWatchService.newPollForChangesOnKeyCallable(this, pollingWatchKey)));
            }
            for (Future future : f) {
                try {
                    future.get();
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException e) {
                    this.exceptionHandler.exception(e);
                }
            }
            long endTime = System.nanoTime();
            this.infoHandler.pollTime(endTime - startTime);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            this.exceptionHandler.exception(t);
        }
    }

    private void pollForChanges(PollingWatchKey key) throws IOException {
        Path dir = key.watchablePath();
        if (key.isInvalid()) {
            this.keys.remove(dir);
            return;
        }
        if (!Files.isDirectory(dir, LinkOption.NOFOLLOW_LINKS)) {
            key.cancel();
            this.keys.remove(dir);
            key.enqueue();
            return;
        }
        HashMap<Path, BasicFileAttributes> oldEntries = new HashMap<Path, BasicFileAttributes>(key.entries());
        Map<Path, BasicFileAttributes> newEntries = this.useFileMetadata ? PollingWatchService.readDirectoryEntries(dir) : PollingWatchService.readDirectoryEntriesWithoutMetadata(dir, oldEntries);
        for (Path each : newEntries.keySet()) {
            BasicFileAttributes newEntryAttributes;
            BasicFileAttributes oldEntryAttributes = (BasicFileAttributes)oldEntries.remove(each);
            if (oldEntryAttributes == null) {
                if (!key.hasKind(StandardWatchEventKinds.ENTRY_CREATE)) continue;
                key.addEvent(PollingWatchEvent.create(each));
                continue;
            }
            if (!key.hasKind(StandardWatchEventKinds.ENTRY_MODIFY) || PollingWatchService.equals(oldEntryAttributes, newEntryAttributes = newEntries.get(each))) continue;
            key.addEvent(PollingWatchEvent.modify(each));
        }
        if (key.hasKind(StandardWatchEventKinds.ENTRY_DELETE)) {
            for (Path each : oldEntries.keySet()) {
                key.addEvent(PollingWatchEvent.delete(each));
            }
        }
        key.entries(newEntries);
        key.enqueueIfReadyAndHasEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            Throwable t = null;
            boolean interrupted = Thread.interrupted();
            block17: for (ExecutorService executorService : Arrays.asList(this.timer, this.executor)) {
                try {
                    executorService.shutdownNow();
                    while (true) {
                        try {
                            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
                            continue block17;
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                            continue;
                        }
                        break;
                    }
                }
                catch (ThreadDeath td) {
                    t = td;
                }
                catch (Throwable th) {
                    if (t == null) {
                        t = th;
                        continue;
                    }
                    t.addSuppressed(th);
                }
            }
            for (PollingWatchKey pollingWatchKey : this.keys.values()) {
                try {
                    pollingWatchKey.cancel();
                }
                catch (ThreadDeath td) {
                    t = td;
                }
                catch (Throwable th) {
                    if (t == null) {
                        t = th;
                        continue;
                    }
                    t.addSuppressed(th);
                }
            }
            try {
                this.keys.clear();
            }
            catch (ThreadDeath td) {
                t = td;
            }
            catch (Throwable th) {
                if (t == null) {
                    t = th;
                }
                t.addSuppressed(th);
            }
            try {
                this.queue.clear();
                this.queue.add(this.closedSentinel);
            }
            catch (ThreadDeath td) {
                t = td;
            }
            catch (Throwable th) {
                if (t == null) {
                    t = th;
                }
                t.addSuppressed(th);
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            if (t != null) {
                PollingWatchService.throwUncheckedException(t);
            }
        }
    }

    @Override
    public WatchKey poll() {
        if (this.closed) {
            throw new ClosedWatchServiceException();
        }
        PollingWatchKey result = (PollingWatchKey)this.queue.poll();
        if (result == this.closedSentinel) {
            throw new ClosedWatchServiceException();
        }
        return result;
    }

    @Override
    public WatchKey poll(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.closed) {
            throw new ClosedWatchServiceException();
        }
        PollingWatchKey result = this.queue.poll(timeout, unit);
        if (result == this.closedSentinel) {
            throw new ClosedWatchServiceException();
        }
        return result;
    }

    @Override
    public WatchKey take() throws InterruptedException {
        if (this.closed) {
            throw new ClosedWatchServiceException();
        }
        PollingWatchKey result = this.queue.take();
        if (result == this.closedSentinel) {
            throw new ClosedWatchServiceException();
        }
        return result;
    }

    @Override
    public WatchKey register(Path dir, WatchEvent.Kind<?> ... kinds) throws IOException {
        return this.register(dir, kinds, new WatchEvent.Modifier[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WatchKey register(Path dir, WatchEvent.Kind<?>[] kinds, WatchEvent.Modifier ... modifiers) throws IOException {
        this.registerMethodEverInvoked = true;
        if (this.closed) {
            throw new ClosedWatchServiceException();
        }
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new NotDirectoryException(dir.toString());
        }
        Map<Path, BasicFileAttributes> dirEntries = this.useFileMetadata ? PollingWatchService.readDirectoryEntries(dir) : PollingWatchService.readDirectoryEntriesWithoutMetadata(dir);
        Object object = this.registerLock;
        synchronized (object) {
            if (this.closed) {
                throw new ClosedWatchServiceException();
            }
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                throw new NotDirectoryException(dir.toString());
            }
            PollingWatchKey k = this.keys.get(dir);
            if (k != null && k.isInvalid()) {
                this.keys.remove(dir);
                k = null;
            }
            if (k == null) {
                k = new PollingWatchKey(this, dir, kinds, modifiers, dirEntries);
                Object object2 = this.closeLock;
                synchronized (object2) {
                    if (this.closed) {
                        throw new ClosedWatchServiceException();
                    }
                    this.keys.put(dir, k);
                }
                return k;
            }
            k.kindsAndModifiers(kinds, modifiers);
            return k;
        }
    }

    void enqueue(PollingWatchKey k) {
        this.queue.add(k);
    }

    private static PollingWatchServiceExceptionHandler newDefaultExceptionHandler() {
        return new PollingWatchServiceExceptionHandler(){

            @Override
            public void exception(Throwable t) {
                t.printStackTrace();
            }
        };
    }

    private static PollingWatchServiceInfoHandler newDefaultInfoHandler() {
        return new PollingWatchServiceInfoHandler(){

            @Override
            public void pollTime(long t) {
            }
        };
    }

    private static Runnable newPollForChangesRunnable(final PollingWatchService s) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    s.pollForChanges();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        };
    }

    private static Callable<?> newPollForChangesOnKeyCallable(final PollingWatchService s, final PollingWatchKey k) {
        return new Callable<Void>(){

            @Override
            public Void call() throws IOException {
                s.pollForChanges(k);
                return null;
            }
        };
    }

    private static void throwUncheckedException(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new RuntimeException(t);
    }

    private static boolean equals(BasicFileAttributes a, BasicFileAttributes b) {
        return JavaUtilities.equalsIgnoreLastAccessTime(a, b);
    }

    private static Map<Path, BasicFileAttributes> readDirectoryEntries(Path dir) {
        HashMap<Path, BasicFileAttributes> result = new HashMap<Path, BasicFileAttributes>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path each : stream) {
                try {
                    result.put(each.getFileName(), PollingWatchService.readAttributes(each));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException | DirectoryIteratorException e) {
            e.printStackTrace();
            return result;
        }
        return result;
    }

    private static BasicFileAttributes readAttributes(Path p) throws IOException {
        return Files.readAttributes(p, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
    }

    private static Map<Path, BasicFileAttributes> readDirectoryEntriesWithoutMetadata(Path dir) {
        return PollingWatchService.readDirectoryEntriesWithoutMetadata(dir, Collections.emptyMap());
    }

    private static Map<Path, BasicFileAttributes> readDirectoryEntriesWithoutMetadata(Path dir, Map<Path, BasicFileAttributes> preexistingMetadata) {
        HashMap<Path, BasicFileAttributes> result = new HashMap<Path, BasicFileAttributes>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            NoMetadataFileAttributes noMetadataAttributes = NoMetadataFileAttributes.instance();
            for (Path each : stream) {
                Path eachFileName;
                BasicFileAttributes eachAttributes = preexistingMetadata.get(eachFileName = each.getFileName());
                result.put(eachFileName, eachAttributes != null ? eachAttributes : noMetadataAttributes);
            }
        }
        catch (IOException | DirectoryIteratorException e) {
            return result;
        }
        return result;
    }

    private static final class NoMetadataFileAttributes
    implements BasicFileAttributes {
        private static final NoMetadataFileAttributes INSTANCE = new NoMetadataFileAttributes();
        private static final FileTime EPOCH = FileTime.fromMillis(0L);

        private NoMetadataFileAttributes() {
        }

        @Override
        public FileTime lastModifiedTime() {
            return EPOCH;
        }

        @Override
        public FileTime lastAccessTime() {
            return EPOCH;
        }

        @Override
        public FileTime creationTime() {
            return EPOCH;
        }

        @Override
        public boolean isRegularFile() {
            return false;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public boolean isSymbolicLink() {
            return false;
        }

        @Override
        public boolean isOther() {
            return false;
        }

        @Override
        public long size() {
            return 0L;
        }

        @Override
        public Object fileKey() {
            return null;
        }

        public static NoMetadataFileAttributes instance() {
            return INSTANCE;
        }
    }
}

