/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.etl;

import com.cinchapi.common.base.CheckedExceptions;
import com.cinchapi.common.collect.AnyMaps;
import com.cinchapi.common.collect.MergeStrategies;
import com.cinchapi.common.reflect.Reflection;
import com.cinchapi.concourse.util.ByteBuffers;
import com.cinchapi.etl.Transformer;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

class CompositeTransformer
implements Transformer,
Serializable {
    private static final long serialVersionUID = 1759080269596158582L;
    private final List<Transformer> transformers;

    private static Map<String, Object> transformAndMerge(Transformer transformer, Map<String, Object> object, @Nullable Map<String, Object> next) {
        for (Map.Entry<String, Object> entry : object.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            ImmutableMap transformed = transformer.transform(key, value);
            if (next == null && transformed != null) {
                next = CompositeTransformer.transformAndMerge(transformer, object, Maps.newLinkedHashMap());
                continue;
            }
            if (next == null) continue;
            AnyMaps.mergeInPlace(next, (Map)(transformed == null ? ImmutableMap.of((Object)key, (Object)value) : transformed), MergeStrategies::theirs);
        }
        return next;
    }

    public CompositeTransformer(List<Transformer> transformers) {
        Preconditions.checkArgument((!transformers.isEmpty() ? 1 : 0) != 0);
        this.transformers = ImmutableList.copyOf(transformers);
    }

    @Override
    @Nullable
    public Map<String, Object> transform(Map<String, Object> object) {
        for (Transformer transformer : this.transformers) {
            object = (Map)MoreObjects.firstNonNull(transformer.transform(object), object);
        }
        return object;
    }

    @Override
    @Nullable
    public Map<String, Object> transform(String key, Object value) {
        Map<String, Object> transformed = null;
        for (Transformer transformer : this.transformers) {
            Map<String, Object> next = null;
            next = transformed == null ? transformer.transform(key, value) : CompositeTransformer.transformAndMerge(transformer, transformed, null);
            if (next == null) continue;
            transformed = next;
        }
        return transformed;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Reflection.set((String)"transformers", (Object)Lists.newArrayList(), (Object)this);
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            int size = in.readInt();
            byte[] bytes = new byte[size];
            in.readFully(bytes);
            Transformer transformer = Transformer.deserialize(ByteBuffer.wrap(bytes));
            this.transformers.add(transformer);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.transformers.size());
        this.transformers.forEach(transformer -> {
            try {
                ByteBuffer bytes = Transformer.serialize(transformer);
                out.writeInt(bytes.remaining());
                out.write(ByteBuffers.toByteArray((ByteBuffer)bytes));
            }
            catch (IOException e) {
                throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
            }
        });
    }
}

