/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.etl;

import com.cinchapi.common.base.AnyStrings;
import com.cinchapi.common.base.CheckedExceptions;
import com.cinchapi.common.base.Verify;
import com.cinchapi.common.collect.AnyMaps;
import com.cinchapi.common.collect.Association;
import com.cinchapi.common.reflect.Reflection;
import com.cinchapi.etl.Transformer;
import com.cinchapi.etl.Transformers;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public class ScriptedTransformer
implements Transformer,
Serializable {
    private static final long serialVersionUID = 1596575180656202243L;
    private static final ScriptEngineManager sem = new ScriptEngineManager();
    private final transient ScriptEngine engine;
    private final String engineName;
    private final String script;

    public static Builder usingJavascript() {
        return new JavascriptTransformerBuilder();
    }

    private ScriptedTransformer(String engine, String script) {
        this.engineName = engine;
        this.script = script;
        this.engine = sem.getEngineByName(engine);
        Verify.that((engine != null ? 1 : 0) != 0, (String)"Invalid script engine {}", (Object[])new Object[]{engine});
    }

    @Override
    public Map<String, Object> transform(String key, Object value) {
        SimpleBindings bindings = new SimpleBindings((Map<String, Object>)Association.of((Map)ImmutableMap.of((Object)"key", (Object)key, (Object)"value", (Object)value)));
        try {
            Object result = this.engine.eval(this.script, (Bindings)bindings);
            if (result instanceof Map) {
                boolean isArray;
                try {
                    isArray = (Boolean)Reflection.call((Object)result, (String)"isArray", (Object[])new Object[0]);
                }
                catch (Exception e) {
                    isArray = false;
                }
                Object object = result = isArray ? ((Map)result).values() : ImmutableMap.copyOf((Map)((Map)result));
            }
            if (result instanceof Map) {
                return (Map)result;
            }
            return AnyMaps.create((Object)key, (Object)result);
        }
        catch (ScriptException e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        short scriptBytesLength = in.readShort();
        byte[] scriptBytes = new byte[scriptBytesLength];
        in.read(scriptBytes);
        String script = new String(scriptBytes, StandardCharsets.UTF_8);
        Reflection.set((String)"script", (Object)script, (Object)this);
        short engineNameBytesLength = in.readShort();
        byte[] engineNameBytes = new byte[engineNameBytesLength];
        in.read(engineNameBytes);
        String engineName = new String(engineNameBytes, StandardCharsets.UTF_8);
        ScriptEngine engine = sem.getEngineByName(engineName);
        Reflection.set((String)"engine", (Object)engine, (Object)this);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        byte[] scriptBytes = this.script.getBytes(StandardCharsets.UTF_8);
        byte[] engineNameBytes = this.engineName.toString().getBytes(StandardCharsets.UTF_8);
        out.writeShort(scriptBytes.length);
        out.write(scriptBytes);
        out.writeShort(engineNameBytes.length);
        out.write(engineNameBytes);
    }

    public static class JavascriptTransformerBuilder
    extends Builder {
        public JavascriptTransformerBuilder() {
            super("javascript");
            this.define("transformers", AnyStrings.format((String)"Java.type('{}')", (Object[])new Object[]{Transformers.class.getName()}));
        }

        @Override
        protected String doDefine(String var, String value) {
            return AnyStrings.format((String)"{} = {};", (Object[])new Object[]{var, value});
        }
    }

    public static abstract class Builder {
        private final String engine;
        private final StringBuilder script = new StringBuilder();

        protected Builder(String engine) {
            this.engine = engine;
        }

        public final ScriptedTransformer build() {
            return new ScriptedTransformer(this.engine, this.script.toString());
        }

        public Builder define(String var, String value) {
            String line = this.doDefine(var, value);
            this.interpret(line);
            return this;
        }

        public Builder interpret(String line) {
            this.script.append(line).append(System.lineSeparator());
            return this;
        }

        protected abstract String doDefine(String var1, String var2);
    }
}

