/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.etl;

import com.cinchapi.common.collect.AnyMaps;
import com.cinchapi.common.collect.MergeStrategies;
import com.cinchapi.etl.TransformerSerializationFactory;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;

@FunctionalInterface
public interface Transformer {
    public static Transformer deserialize(ByteBuffer bytes) {
        return TransformerSerializationFactory.instance().deserialize(bytes);
    }

    public static ByteBuffer serialize(Transformer transformer) {
        return TransformerSerializationFactory.instance().serialize(transformer);
    }

    @Nullable
    @Deprecated
    default public Map.Entry<String, Object> transform(String key, String value) {
        Map.Entry entry;
        Map<String, Object> transformed = this.transform(key, (Object)value);
        if (transformed != null && (entry = (Map.Entry)Iterables.getFirst(transformed.entrySet(), null)) != null) {
            return new AbstractMap.SimpleImmutableEntry<String, Object>((String)entry.getKey(), entry.getValue());
        }
        return null;
    }

    default public Map<String, Object> transform(Map<String, Object> object) {
        LinkedHashMap transformed = Maps.newLinkedHashMap();
        object.forEach((key, value) -> {
            Map data = this.transform((String)key, value);
            data = data == null ? AnyMaps.create((Object)key, (Object)value) : data;
            AnyMaps.mergeInPlace((Map)transformed, (Map)data, MergeStrategies::upsert);
        });
        return transformed;
    }

    @Nullable
    public Map<String, Object> transform(String var1, Object var2);
}

