/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.etl;

import com.cinchapi.common.base.CheckedExceptions;
import com.cinchapi.common.base.Verify;
import com.cinchapi.common.io.ByteBuffers;
import com.cinchapi.common.reflect.Reflection;
import com.cinchapi.etl.Transformer;
import com.cinchapi.etl.Transformers;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class TransformerSerializationFactory {
    private static TransformerSerializationFactory INSTANCE = new TransformerSerializationFactory();
    private final Map<String, Class<? extends Transformer>> lambdas = Maps.newHashMap();

    public static TransformerSerializationFactory instance() {
        return INSTANCE;
    }

    private static ByteBuffer getSerializedBytes(Object object) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream output = new ObjectOutputStream(new BufferedOutputStream(baos));
            output.writeObject(object);
            output.flush();
            output.close();
            return ByteBuffer.wrap(baos.toByteArray());
        }
        catch (IOException e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }

    private static <T> T getSerializedObject(ByteBuffer bytes) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(ByteBuffers.getByteArray((ByteBuffer)bytes));
            BufferedInputStream bis = new BufferedInputStream(bais);
            ObjectInputStream input = new ObjectInputStream(bis);
            Object object = input.readObject();
            return (T)object;
        }
        catch (IOException | ReflectiveOperationException e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }

    private TransformerSerializationFactory() {
    }

    public Transformer deserialize(ByteBuffer bytes) {
        Technique technique = Technique.values()[bytes.get()];
        switch (technique) {
            case JAVA_SERIALIZATION: {
                return (Transformer)TransformerSerializationFactory.getSerializedObject(ByteBuffers.slice((ByteBuffer)bytes, (int)bytes.remaining()));
            }
            case AUTO_DETECT_BUILTIN_LAMBDA: {
                int nameSize = bytes.getInt();
                byte[] nameBytes = new byte[nameSize];
                bytes.get(nameBytes);
                String name = new String(nameBytes, StandardCharsets.UTF_8);
                int paramCount = bytes.getInt();
                ArrayList params = Lists.newArrayListWithExpectedSize((int)paramCount);
                while (bytes.hasRemaining()) {
                    Object param;
                    int paramSize = bytes.getInt();
                    byte[] paramBytes = new byte[paramSize];
                    bytes.get(paramBytes);
                    try {
                        param = TransformerSerializationFactory.getSerializedObject(ByteBuffer.wrap(paramBytes));
                    }
                    catch (Exception e) {
                        param = this.deserialize(ByteBuffer.wrap(paramBytes));
                    }
                    params.add(param);
                }
                return (Transformer)Reflection.callStatic(Transformers.class, (String)name, (Object[])params.toArray());
            }
        }
        throw new UnsupportedOperationException("Cannot handle serialization technique " + (Object)((Object)technique));
    }

    public ByteBuffer serialize(Transformer transformer) {
        ByteBuffer bytes;
        Technique technique;
        if (transformer instanceof Serializable) {
            technique = Technique.JAVA_SERIALIZATION;
            bytes = TransformerSerializationFactory.getSerializedBytes(transformer);
        } else {
            technique = Technique.AUTO_DETECT_BUILTIN_LAMBDA;
            try {
                Field[] fields = Reflection.getAllDeclaredFields(transformer.getClass());
                Class[] types = new Class[fields.length];
                Object[] params = new Object[fields.length];
                for (int i = 0; i < types.length; ++i) {
                    Field field = fields[i];
                    field.setAccessible(true);
                    types[i] = field.getType();
                    params[i] = field.get(transformer);
                }
                List candidates = Arrays.stream(Transformers.class.getDeclaredMethods()).filter(method -> Reflection.isCallableWith((Method)method, (Object[])params)).collect(Collectors.toList());
                Method method2 = null;
                for (Method candidate : candidates) {
                    candidate.setAccessible(true);
                    Class<Transformer> clazz = this.lambdas.get(candidate.getName());
                    if (clazz == null) {
                        Transformer t = (Transformer)candidate.invoke(null, params);
                        clazz = t.getClass();
                        this.lambdas.put(candidate.getName(), clazz);
                    }
                    if (!clazz.equals(transformer.getClass())) continue;
                    method2 = candidate;
                    break;
                }
                Verify.that((method2 != null ? 1 : 0) != 0, (String)("Cannot serialize transformer using technique " + (Object)((Object)technique)), (Object[])new Object[0]);
                String name = method2.getName();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                baos.write(Ints.toByteArray((int)name.length()));
                baos.write(name.getBytes(StandardCharsets.UTF_8));
                baos.write(Ints.toByteArray((int)params.length));
                for (Object param : params) {
                    ByteBuffer buf = param instanceof Transformer ? this.serialize((Transformer)param) : TransformerSerializationFactory.getSerializedBytes(param);
                    baos.write(Ints.toByteArray((int)buf.remaining()));
                    baos.write(ByteBuffers.getByteArray((ByteBuffer)buf));
                }
                bytes = ByteBuffer.wrap(baos.toByteArray());
            }
            catch (IOException | ReflectiveOperationException e) {
                throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
            }
        }
        ByteBuffer serialized = ByteBuffer.allocate(bytes.remaining() + 1);
        serialized.put(technique.code());
        serialized.put(bytes);
        serialized.flip();
        return serialized;
    }

    private static enum Technique {
        AUTO_DETECT_BUILTIN_LAMBDA,
        JAVA_SERIALIZATION;


        public byte code() {
            return (byte)this.ordinal();
        }
    }
}

