/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.etl;

import com.cinchapi.common.base.CaseFormats;
import com.cinchapi.common.base.validate.Check;
import com.cinchapi.common.collect.AnyMaps;
import com.cinchapi.common.collect.Association;
import com.cinchapi.common.collect.MergeStrategies;
import com.cinchapi.common.collect.Sequences;
import com.cinchapi.common.describe.Adjective;
import com.cinchapi.common.describe.Empty;
import com.cinchapi.concourse.Tag;
import com.cinchapi.concourse.Timestamp;
import com.cinchapi.concourse.util.Convert;
import com.cinchapi.concourse.util.SplitOption;
import com.cinchapi.concourse.util.StringSplitter;
import com.cinchapi.concourse.util.Strings;
import com.cinchapi.etl.CompositeTransformer;
import com.cinchapi.etl.Transformation;
import com.cinchapi.etl.Transformer;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class Transformers {
    public static Transformer compose(Transformer ... transformers) {
        return new CompositeTransformer(Arrays.asList(transformers));
    }

    public static Transformer composeForEach(Transformer ... transformers) {
        return new CompositeTransformer(Arrays.asList(transformers).stream().map(transformer -> Transformers.forEach(transformer)).collect(Collectors.toList()));
    }

    public static Transformer explode() {
        return (key, value) -> Association.of((Map)ImmutableMap.of((Object)key, (Object)value));
    }

    public static Transformer forEach(Transformer transformer) {
        return (key, value) -> {
            if (Sequences.isSequence((Object)value)) {
                LinkedHashMap transformed = Maps.newLinkedHashMap();
                Sequences.forEach((Object)value, val -> {
                    ImmutableMap theirs = transformer.transform(key, val);
                    AnyMaps.mergeInPlace((Map)transformed, (Map)(theirs != null ? theirs : ImmutableMap.of((Object)key, (Object)val)), MergeStrategies::concat);
                });
                return transformed.isEmpty() ? null : transformed;
            }
            return transformer.transform(key, value);
        };
    }

    @Deprecated
    public static Transformer keyCaseFormat(CaseFormat from, CaseFormat to) {
        return (key, value) -> {
            key = from.to(to, key);
            return Transformation.to(key, value);
        };
    }

    public static Transformer keyConditionalConvertCaseFormat(CaseFormat undesired, CaseFormat desired) {
        return (key, value) -> {
            CaseFormat format = CaseFormats.detect((String)key);
            return format == undesired ? Transformation.to(undesired.to(desired, key), value) : null;
        };
    }

    public static Transformer keyEnsureCaseFormat(CaseFormat format) {
        return (key, value) -> {
            CaseFormat current = CaseFormats.detect((String)key);
            if (current != format) {
                key = current.to(format, key);
                return Transformation.to(key, value);
            }
            return null;
        };
    }

    public static Transformer keyMap(Map<String, String> map) {
        return (key, value) -> {
            if ((key = (String)map.get(key)) != null) {
                return Transformation.to(key, value);
            }
            return null;
        };
    }

    public static Transformer keyWhitespaceToUnderscore() {
        return Transformers.keyReplaceChars((Map<Character, Character>)ImmutableMap.of((Object)Character.valueOf(' '), (Object)Character.valueOf('_')));
    }

    public static Transformer keyRemoveWhitespace() {
        return Transformers.keyRemoveInvalidChars(Character::isWhitespace);
    }

    public static Transformer keyRemoveInvalidChars(Collection<Character> invalid) {
        return Transformers.keyRemoveInvalidChars((Character c) -> invalid.contains(c));
    }

    public static Transformer keyRemoveInvalidChars(Predicate<Character> invalid) {
        return (key, value) -> {
            boolean modified = false;
            for (char c : key.toCharArray()) {
                if (!invalid.test(Character.valueOf(c))) continue;
                modified = true;
                break;
            }
            if (modified) {
                StringBuilder sb = new StringBuilder();
                for (char c : key.toCharArray()) {
                    if (!invalid.negate().test(Character.valueOf(c))) continue;
                    sb.append(c);
                }
                return Transformation.to(sb.toString(), value);
            }
            return null;
        };
    }

    public static Transformer keyReplaceChars(Map<Character, Character> replacements) {
        return (key, value) -> {
            char[] chars = key.toCharArray();
            boolean modified = false;
            for (int i = 0; i < chars.length; ++i) {
                Character replacement = (Character)replacements.get(Character.valueOf(chars[i]));
                if (replacement == null) continue;
                chars[i] = replacement.charValue();
                modified = true;
            }
            return modified ? Transformation.to(new String(chars), value) : null;
        };
    }

    @Deprecated
    public static Transformer keyStripInvalidChars(Check<Character> validator) {
        return (key, value) -> {
            StringBuilder sb = new StringBuilder();
            boolean modified = false;
            for (char c : key.toCharArray()) {
                if (validator.passes((Object)Character.valueOf(c))) {
                    sb.append(c);
                    continue;
                }
                modified = true;
            }
            return modified ? Transformation.to(sb.toString(), value) : null;
        };
    }

    public static Transformer keyToLowerCase() {
        return (key, value) -> Transformation.to(key.toLowerCase(), value);
    }

    public static Transformer keyValueRemoveQuotes() {
        return (key, value) -> {
            boolean modified = false;
            if (Strings.isWithinQuotes((String)key)) {
                key = key.substring(1, key.length() - 1);
                modified = true;
            }
            if (value instanceof String && Strings.isWithinQuotes((String)((String)value))) {
                String str = (String)value;
                value = str.substring(1, str.length() - 1);
                modified = true;
            }
            return modified ? Transformation.to(key, value) : null;
        };
    }

    @Deprecated
    public static Transformer keyValueStripQuotes() {
        return Transformers.keyValueRemoveQuotes();
    }

    public static Transformer noOp() {
        return (key, value) -> null;
    }

    public static Transformer nullSafe(Transformer transformer) {
        return (key, value) -> value != null ? transformer.transform(key, value) : null;
    }

    public static Transformer valueRemoveIfEmpty() {
        return Transformers.valueRemoveIf((Adjective)Empty.ness());
    }

    @Deprecated
    public static Transformer removeValuesThatAre(Adjective adjective) {
        return Transformers.valueRemoveIf(adjective);
    }

    public static Transformer valueRemoveIf(Adjective adjective) {
        return (key, value) -> adjective.describes(value) ? ImmutableMap.of() : null;
    }

    public static Transformer valueAsBoolean() {
        return (key, value) -> {
            if (value instanceof Boolean) {
                return null;
            }
            return Transformation.to(key, Boolean.parseBoolean(value.toString()));
        };
    }

    public static Transformer valueAsBoolean(String ... keys) {
        if (keys.length == 0) {
            return Transformers.valueAsBoolean();
        }
        Set _keys = Arrays.stream(keys).collect(Collectors.toSet());
        return (key, value) -> {
            if (_keys.contains(key)) {
                return Transformers.valueAsBoolean().transform(key, value);
            }
            return null;
        };
    }

    public static Transformer valueAsNumber() {
        return (key, value) -> {
            if (value instanceof Number) {
                return null;
            }
            Number number = Strings.tryParseNumber((String)value.toString());
            if (number != null) {
                return Transformation.to(key, number);
            }
            throw new IllegalArgumentException(value + " cannot be transformed to a Number");
        };
    }

    public static Transformer valueAsNumber(String ... keys) {
        if (keys.length == 0) {
            return Transformers.valueAsNumber();
        }
        Set _keys = Arrays.stream(keys).collect(Collectors.toSet());
        return (key, value) -> {
            if (_keys.contains(key)) {
                return Transformers.valueAsNumber().transform(key, value);
            }
            return null;
        };
    }

    public static Transformer valueAsResolvableLinkInstruction() {
        return (key, value) -> Transformation.to(key, Convert.stringToResolvableLinkInstruction((String)value.toString()));
    }

    public static Transformer valueAsResolvableLinkInstruction(String ... keys) {
        if (keys.length == 0) {
            return Transformers.valueAsResolvableLinkInstruction();
        }
        Set _keys = Arrays.stream(keys).collect(Collectors.toSet());
        return (key, value) -> {
            if (_keys.contains(key)) {
                return Transformers.valueAsResolvableLinkInstruction().transform(key, value);
            }
            return null;
        };
    }

    public static Transformer valueAsTag() {
        return (key, value) -> {
            if (value instanceof Tag) {
                return null;
            }
            return Transformation.to(key, Tag.create((String)value.toString()));
        };
    }

    public static Transformer valueAsTag(String ... keys) {
        if (keys.length == 0) {
            return Transformers.valueAsTag();
        }
        Set _keys = Arrays.stream(keys).collect(Collectors.toSet());
        return (key, value) -> {
            if (_keys.contains(key)) {
                return Transformers.valueAsTag().transform(key, value);
            }
            return null;
        };
    }

    public static Transformer valueAsTimestamp() {
        return (key, value) -> {
            if (value instanceof Timestamp) {
                return null;
            }
            if (value instanceof Number) {
                return Transformation.to(key, Timestamp.fromMicros((long)((Number)value).longValue()));
            }
            return Transformation.to(key, Timestamp.fromString((String)value.toString()));
        };
    }

    public static Transformer valueAsTimestamp(String ... keys) {
        if (keys.length == 0) {
            return Transformers.valueAsTimestamp();
        }
        Set _keys = Arrays.stream(keys).collect(Collectors.toSet());
        return (key, value) -> {
            if (_keys.contains(key)) {
                return Transformers.valueAsTimestamp().transform(key, value);
            }
            return null;
        };
    }

    public static Transformer valueNullifyIfEmpty() {
        return Transformers.valueNullifyIfEmpty(Empty.ness());
    }

    public static Transformer valueNullifyIfEmpty(Empty empty) {
        return (key, value) -> {
            if (value != null && empty.describes(value)) {
                return Transformation.to(key, null);
            }
            return null;
        };
    }

    @Deprecated
    public static Transformer valueSplitOnDelimiter(char delimiter, SplitOption ... options) {
        return Transformers.valueStringSplitOnDelimiter(delimiter, options);
    }

    public static Transformer valueStringSplitOnDelimiter(char delimiter, SplitOption ... options) {
        return (key, value) -> {
            if (value instanceof String) {
                StringSplitter splitter = new StringSplitter((String)value, delimiter, options);
                Object[] values = splitter.toArray();
                return values.length > 1 ? Transformation.to(key, values) : null;
            }
            return null;
        };
    }

    public static Transformer valueStringToJava() {
        return (key, value) -> {
            if (value instanceof String) {
                Object converted = Convert.stringToJava((String)((String)value));
                return !converted.equals(value) ? Transformation.to(key, converted) : null;
            }
            return null;
        };
    }

    private Transformers() {
    }
}

