/*
 * Decompiled with CFR 0.152.
 */
package com.cinnober.msgcodec.test.messages;

import com.cinnober.msgcodec.MsgObject;
import com.cinnober.msgcodec.anot.Dynamic;
import com.cinnober.msgcodec.anot.Id;
import com.cinnober.msgcodec.anot.Required;
import com.cinnober.msgcodec.anot.Sequence;
import com.cinnober.msgcodec.anot.Time;
import com.cinnober.msgcodec.anot.Unsigned;
import com.cinnober.msgcodec.test.messages.Color;
import com.cinnober.msgcodec.test.messages.Employee;
import com.cinnober.msgcodec.test.messages.Person;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Id(value=108)
public class SequencesMessage
extends MsgObject {
    @Sequence(value=byte.class)
    public byte[] arrayBytes;
    public short[] arrayShorts;
    public int[] arrayInts;
    public long[] arrayLongs;
    @Unsigned
    public int[] arrayUInts;
    @Required
    @Sequence(value=byte.class)
    public byte[] arrayBytesReq;
    @Required
    public short[] arrayShortsReq;
    @Required
    public int[] arrayIntsReq;
    @Required
    public long[] arrayLongsReq;
    @Required
    @Time
    public long[] arrayTime;
    @Sequence(value=Long.class)
    @Time
    public List<Long> listTime;
    @Sequence(value=Integer.class)
    public List<Integer> listInts;
    @Unsigned
    @Sequence(value=Integer.class)
    public List<Integer> listUInts;
    @Sequence(value=Person.class)
    @Dynamic
    public List<Person> listPeople;
    @Sequence(value=Employee.class)
    public List<Employee> listEmployees;
    public Employee[] arrayEmployees;
    @Sequence(value=Color.class)
    public List<Color> listColors;
    public Color[] arrayColors;

    public static Map<String, SequencesMessage> createMessages() {
        LinkedHashMap<String, SequencesMessage> messages = new LinkedHashMap<String, SequencesMessage>();
        SequencesMessage msg = new SequencesMessage();
        messages.put("clean", msg);
        msg.arrayBytesReq = new byte[0];
        msg.arrayShortsReq = new short[0];
        msg.arrayIntsReq = new int[0];
        msg.arrayLongsReq = new long[0];
        msg.arrayTime = new long[0];
        msg = new SequencesMessage();
        messages.put("arrayObjs", msg);
        msg.arrayBytesReq = new byte[0];
        msg.arrayShortsReq = new short[0];
        msg.arrayIntsReq = new int[0];
        msg.arrayLongsReq = new long[0];
        msg.arrayTime = new long[0];
        msg.arrayEmployees = new Employee[]{SequencesMessage.createEmployee("Bob", 123L), SequencesMessage.createEmployee("Alice", 456L)};
        msg = new SequencesMessage();
        messages.put("enums0", msg);
        msg.arrayBytesReq = new byte[0];
        msg.arrayShortsReq = new short[0];
        msg.arrayIntsReq = new int[0];
        msg.arrayLongsReq = new long[0];
        msg.arrayTime = new long[0];
        msg.arrayColors = new Color[0];
        msg.listColors = Arrays.asList(new Object[0]);
        msg = new SequencesMessage();
        messages.put("enums1", msg);
        msg.arrayBytesReq = new byte[0];
        msg.arrayShortsReq = new short[0];
        msg.arrayIntsReq = new int[0];
        msg.arrayLongsReq = new long[0];
        msg.arrayTime = new long[0];
        msg.arrayColors = new Color[]{Color.RED};
        msg.listColors = Arrays.asList(Color.RED);
        msg = new SequencesMessage();
        messages.put("enums2", msg);
        msg.arrayBytesReq = new byte[0];
        msg.arrayShortsReq = new short[0];
        msg.arrayIntsReq = new int[0];
        msg.arrayLongsReq = new long[0];
        msg.arrayTime = new long[0];
        msg.arrayColors = new Color[]{Color.GREEN, Color.BLUE};
        msg.listColors = Arrays.asList(Color.GREEN, Color.BLUE);
        return messages;
    }

    private static Employee createEmployee(String name, long employeeNumber) {
        Employee employee = new Employee();
        employee.name = name;
        employee.employeeNumber = employeeNumber;
        return employee;
    }
}

