/*
 * Decompiled with CFR 0.152.
 */
package com.cinnober.msgcodec.test.messages;

import com.cinnober.msgcodec.StreamCodec;
import com.cinnober.msgcodec.test.messages.TestProtocol;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;

public abstract class TestMessagesSuite
extends Suite {
    protected TestMessagesSuite(Class<?> rootClass, StreamCodec codec) throws InitializationError {
        super(rootClass, TestMessagesSuite.createRunners(codec));
    }

    private static List<Runner> createRunners(StreamCodec codec) {
        ArrayList<Runner> runners = new ArrayList<Runner>();
        for (Map.Entry<String, Object> messageEntry : TestProtocol.createMessages().entrySet()) {
            runners.add(new EncodeDecodeTest(codec, messageEntry.getKey(), messageEntry.getValue()));
        }
        return runners;
    }

    public static class EncodeDecodeTest
    extends Runner {
        private final StreamCodec codec;
        private final String label;
        private final Object message;
        private final Description description;

        private EncodeDecodeTest(StreamCodec codec, String label, Object message) {
            this.codec = codec;
            this.label = label;
            this.message = message;
            this.description = Description.createTestDescription(EncodeDecodeTest.class, (String)label);
        }

        public String toString() {
            return this.label;
        }

        public Description getDescription() {
            return this.description;
        }

        public void run(RunNotifier notifier) {
            notifier.fireTestStarted(this.description);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                this.codec.encode(this.message, (OutputStream)out);
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                Object object = this.codec.decode((InputStream)in);
                if (object == null) {
                    Assert.fail((String)"Decoded message is null");
                } else if (!object.getClass().equals(this.message.getClass())) {
                    Assert.fail((String)"Decoded message is not same type as encoded message");
                }
                Assert.assertEquals((Object)this.message, (Object)object);
            }
            catch (Throwable e) {
                notifier.fireTestFailure(new Failure(this.description, e));
            }
            notifier.fireTestFinished(this.description);
        }
    }
}

