/*
 * Decompiled with CFR 0.152.
 */
package com.cinnober.msgcodec.test.messages;

import com.cinnober.msgcodec.Epoch;
import com.cinnober.msgcodec.MsgObject;
import com.cinnober.msgcodec.anot.Id;
import com.cinnober.msgcodec.anot.Time;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Id(value=101)
public class DatesMessage
extends MsgObject {
    @Id(value=31)
    public Date dateTimestamp;
    @Id(value=32)
    @Time
    public long utcMillis;
    @Id(value=33)
    @Time(unit=TimeUnit.NANOSECONDS)
    public long utcNanos;
    @Id(value=34)
    @Time(unit=TimeUnit.DAYS, timeZone="")
    public long businessDate;
    @Id(value=35)
    @Time(epoch=Epoch.MIDNIGHT, timeZone="")
    public long localTimeMillis;
    @Id(value=36)
    @Time(unit=TimeUnit.DAYS, timeZone="")
    public Date dateDate;

    public static Map<String, DatesMessage> createMessages() {
        LinkedHashMap<String, DatesMessage> messages = new LinkedHashMap<String, DatesMessage>();
        DatesMessage msg = new DatesMessage();
        messages.put("clean", msg);
        msg = new DatesMessage();
        messages.put("zero", msg);
        msg.dateTimestamp = new Date(0L);
        msg.dateDate = new Date(0L);
        msg = new DatesMessage();
        messages.put("border1", msg);
        msg.localTimeMillis = 1L;
        msg = new DatesMessage();
        messages.put("border2", msg);
        msg.localTimeMillis = 86399999L;
        msg = new DatesMessage();
        messages.put("2013-10-15 12:00:00.123456789", msg);
        msg.dateTimestamp = new Date(1381856400123L);
        msg.utcMillis = 1381856400123L;
        msg.utcNanos = 1381856400123456789L;
        msg.businessDate = 15993L;
        msg.localTimeMillis = 43200123L;
        msg.dateDate = new Date(1381795200000L);
        return messages;
    }
}

