/*
 * Decompiled with CFR 0.152.
 */
package com.cinnober.msgcodec.test.messages;

import com.cinnober.msgcodec.MsgObject;
import com.cinnober.msgcodec.anot.Id;
import com.cinnober.msgcodec.anot.Required;
import com.cinnober.msgcodec.anot.SmallDecimal;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;

@Id(value=102)
public class DecimalsMessage
extends MsgObject {
    @Id(value=1)
    public BigDecimal myDecimal;
    @Required
    @Id(value=2)
    public BigDecimal myDecimalReq;
    @Id(value=3)
    @SmallDecimal
    public BigDecimal mySmallDecimal;
    @Required
    @Id(value=4)
    @SmallDecimal
    public BigDecimal mySmallDecimalReq;

    public static Map<String, DecimalsMessage> createMessages() {
        LinkedHashMap<String, DecimalsMessage> messages = new LinkedHashMap<String, DecimalsMessage>();
        DecimalsMessage msg = new DecimalsMessage();
        messages.put("clean", msg);
        msg.myDecimalReq = BigDecimal.ZERO;
        msg.mySmallDecimalReq = BigDecimal.ZERO;
        msg = new DecimalsMessage();
        messages.put("zero", msg);
        msg.myDecimalReq = BigDecimal.ZERO;
        msg.mySmallDecimalReq = BigDecimal.ZERO;
        msg.myDecimal = BigDecimal.ZERO;
        msg.mySmallDecimal = BigDecimal.ZERO;
        msg = new DecimalsMessage();
        messages.put("zero 0.0", msg);
        msg.myDecimalReq = BigDecimal.valueOf(0L, 1);
        msg.mySmallDecimalReq = BigDecimal.valueOf(0L, 1);
        msg.myDecimal = BigDecimal.valueOf(0L, 1);
        msg.mySmallDecimal = BigDecimal.valueOf(0L, 1);
        msg = new DecimalsMessage();
        messages.put("zero 0.00", msg);
        msg.myDecimalReq = BigDecimal.valueOf(0L, 2);
        msg.mySmallDecimalReq = BigDecimal.valueOf(0L, 2);
        msg.myDecimal = BigDecimal.valueOf(0L, 2);
        msg.mySmallDecimal = BigDecimal.valueOf(0L, 2);
        msg = new DecimalsMessage();
        messages.put("one", msg);
        msg.myDecimalReq = BigDecimal.ONE;
        msg.mySmallDecimalReq = BigDecimal.ONE;
        msg.myDecimal = BigDecimal.ONE;
        msg.mySmallDecimal = BigDecimal.ONE;
        msg = new DecimalsMessage();
        messages.put("one 1.0", msg);
        msg.myDecimalReq = BigDecimal.valueOf(10L, 1);
        msg.mySmallDecimalReq = BigDecimal.valueOf(10L, 1);
        msg.myDecimal = BigDecimal.valueOf(10L, 1);
        msg.mySmallDecimal = BigDecimal.valueOf(10L, 1);
        msg = new DecimalsMessage();
        messages.put("one 1.00", msg);
        msg.myDecimalReq = BigDecimal.valueOf(100L, 2);
        msg.mySmallDecimalReq = BigDecimal.valueOf(100L, 2);
        msg.myDecimal = BigDecimal.valueOf(100L, 2);
        msg.mySmallDecimal = BigDecimal.valueOf(100L, 2);
        msg = new DecimalsMessage();
        messages.put("0.01", msg);
        msg.myDecimalReq = BigDecimal.valueOf(1L, 2);
        msg.mySmallDecimalReq = BigDecimal.valueOf(1L, 2);
        msg.myDecimal = BigDecimal.valueOf(1L, 2);
        msg.mySmallDecimal = BigDecimal.valueOf(1L, 2);
        return messages;
    }
}

