/*
 * Decompiled with CFR 0.152.
 */
package com.cinnober.msgcodec.test.messages;

import com.cinnober.msgcodec.MsgCodec;
import com.cinnober.msgcodec.io.ByteArrayBuf;
import com.cinnober.msgcodec.io.ByteBuf;
import com.cinnober.msgcodec.io.ByteBufferBuf;
import com.cinnober.msgcodec.io.ByteSink;
import com.cinnober.msgcodec.io.ByteSource;
import com.cinnober.msgcodec.io.ReallocatingArray;
import com.cinnober.msgcodec.io.ReallocatingByteBuf;
import com.cinnober.msgcodec.test.messages.TestProtocol;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;

public abstract class TestMessagesSuite
extends Suite {
    protected TestMessagesSuite(Class<?> rootClass, MsgCodec codec) throws InitializationError {
        super(rootClass, TestMessagesSuite.createRunners(rootClass, codec));
    }

    private static List<Runner> createRunners(Class<?> rootClass, MsgCodec codec) {
        ArrayList<Runner> runners = new ArrayList<Runner>();
        for (Map.Entry<String, Object> messageEntry : TestProtocol.createMessages().entrySet()) {
            runners.add(new EncodeDecodeTest(rootClass, codec, messageEntry.getKey(), messageEntry.getValue()));
        }
        return runners;
    }

    public static class EncodeDecodeTest
    extends Runner {
        private final MsgCodec codec;
        private final String label;
        private final Object message;
        private final Description description;
        private final Class<?> rootClass;

        private EncodeDecodeTest(Class<?> rootClass, MsgCodec codec, String label, Object message) {
            this.codec = codec;
            this.label = label;
            this.message = message;
            this.description = Description.createTestDescription(EncodeDecodeTest.class, (String)label);
            this.rootClass = rootClass;
        }

        public String toString() {
            return this.label;
        }

        public Description getDescription() {
            return this.description;
        }

        public void runByteBuf(RunNotifier notifier, Object message, ByteBuf buffer) {
            try {
                this.codec.encode(message, (ByteSink)buffer);
                buffer.clear();
                Object object = this.codec.decode((ByteSource)buffer);
                if (object == null) {
                    Assert.fail((String)"Decoded message is null");
                } else if (!object.getClass().equals(message.getClass())) {
                    Assert.fail((String)"Decoded message is not same type as encoded message");
                }
                Assert.assertEquals((Object)message, (Object)object);
            }
            catch (Throwable e) {
                notifier.fireTestFailure(new Failure(this.description, e));
            }
        }

        public void run(RunNotifier notifier) {
            notifier.fireTestStarted(this.description);
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.codec.encode(this.message, (OutputStream)out);
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                Object object = this.codec.decode((InputStream)in);
                if (object == null) {
                    Assert.fail((String)"Decoded message is null");
                } else if (!object.getClass().equals(this.message.getClass())) {
                    Assert.fail((String)"Decoded message is not same type as encoded message");
                }
                Assert.assertEquals((Object)this.message, (Object)object);
            }
            catch (Throwable e) {
                notifier.fireTestFailure(new Failure(this.description, e));
            }
            if (!this.rootClass.getName().contains("XmlTestMessagesSuite")) {
                Object object;
                ByteArrayBuf arr;
                try {
                    arr = new ByteArrayBuf(4096);
                    this.codec.encode(this.message, (ByteSink)arr);
                    arr.clear();
                    object = this.codec.decode((ByteSource)arr);
                    if (object == null) {
                        Assert.fail((String)"Decoded message is null");
                    } else if (!object.getClass().equals(this.message.getClass())) {
                        Assert.fail((String)"Decoded message is not same type as encoded message");
                    }
                    Assert.assertEquals((Object)this.message, (Object)object);
                }
                catch (Throwable e) {
                    notifier.fireTestFailure(new Failure(this.description, e));
                }
                try {
                    arr = new ReallocatingArray(4096, 4096);
                    this.codec.encode(this.message, (ByteSink)arr);
                    arr.clear();
                    object = this.codec.decode((ByteSource)arr);
                    if (object == null) {
                        Assert.fail((String)"Decoded message is null");
                    } else if (!object.getClass().equals(this.message.getClass())) {
                        Assert.fail((String)"Decoded message is not same type as encoded message");
                    }
                    Assert.assertEquals((Object)this.message, (Object)object);
                }
                catch (Throwable e) {
                    notifier.fireTestFailure(new Failure(this.description, e));
                }
                this.runByteBuf(notifier, this.message, (ByteBuf)new ByteBufferBuf(ByteBuffer.wrap(new byte[4096])));
                this.runByteBuf(notifier, this.message, (ByteBuf)new ByteBufferBuf(ByteBuffer.allocateDirect(65536)));
                this.runByteBuf(notifier, this.message, (ByteBuf)new ReallocatingByteBuf(4096, 4096, ByteBuffer::allocate));
                this.runByteBuf(notifier, this.message, (ByteBuf)new ReallocatingByteBuf(4096, 4096, ByteBuffer::allocateDirect));
            }
            notifier.fireTestFinished(this.description);
        }
    }
}

