/*
 * Decompiled with CFR 0.152.
 */
package com.cinnober.msgcodec.test.upgrade;

import com.cinnober.msgcodec.Schema;
import com.cinnober.msgcodec.SchemaBuilder;
import com.cinnober.msgcodec.test.upgrade.UpgradeAddRemoveFieldMessages;
import com.cinnober.msgcodec.test.upgrade.UpgradeBasicMessages;
import com.cinnober.msgcodec.test.upgrade.UpgradeDynamicWithLostGroups;
import com.cinnober.msgcodec.test.upgrade.UpgradeEnumArrayMessages;
import com.cinnober.msgcodec.test.upgrade.UpgradeEnumSequenceMessages;
import com.cinnober.msgcodec.test.upgrade.UpgradeEnumsMessages;
import com.cinnober.msgcodec.test.upgrade.UpgradeIntegerEnumsMessages;
import com.cinnober.msgcodec.test.upgrade.UpgradeMissingGroupDefs;
import com.cinnober.msgcodec.test.upgrade.UpgradeWithInheritedGroups;
import com.cinnober.msgcodec.test.upgrade.UpgradeWithInheritedGroups2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class PairedTestProtocols {
    private static final Class<?>[] originalSchemaClasses = new Class[]{UpgradeAddRemoveFieldMessages.AddAndRemoveOptionalV1.class, UpgradeAddRemoveFieldMessages.ChangeRequiredToOptionalV1.class, UpgradeAddRemoveFieldMessages.RemoveRequiredV1.class, UpgradeEnumArrayMessages.Original.class, UpgradeEnumsMessages.Original.class, UpgradeEnumSequenceMessages.Original.class, UpgradeIntegerEnumsMessages.Original.class};
    private static final Class<?>[] upgradedSchemaClasses = new Class[]{UpgradeAddRemoveFieldMessages.AddAndRemoveOptionalV2.class, UpgradeAddRemoveFieldMessages.ChangeRequiredToOptionalV2.class, UpgradeAddRemoveFieldMessages.RemoveRequiredV2.class, UpgradeEnumArrayMessages.Upgraded.class, UpgradeEnumsMessages.Upgraded.class, UpgradeEnumSequenceMessages.Upgraded.class, UpgradeIntegerEnumsMessages.Upgraded.class};

    public static Schema getOriginalSchema() {
        ArrayList classes = new ArrayList(Arrays.asList(originalSchemaClasses));
        classes.addAll(UpgradeBasicMessages.getOriginalSchemaClasses());
        classes.addAll(UpgradeMissingGroupDefs.getOriginalSchemaClasses());
        classes.addAll(UpgradeWithInheritedGroups.getOriginalSchemaClasses());
        classes.addAll(UpgradeWithInheritedGroups2.getOriginalSchemaClasses());
        classes.addAll(UpgradeDynamicWithLostGroups.getOriginalSchemaClasses());
        return new SchemaBuilder().build(classes.toArray(new Class[classes.size()]));
    }

    public static Schema getUpgradedSchema() {
        ArrayList classes = new ArrayList(Arrays.asList(upgradedSchemaClasses));
        classes.addAll(UpgradeBasicMessages.getUpgradedSchemaClasses());
        classes.addAll(UpgradeMissingGroupDefs.getUpgradedSchemaClasses());
        classes.addAll(UpgradeWithInheritedGroups.getUpgradedSchemaClasses());
        classes.addAll(UpgradeWithInheritedGroups2.getUpgradedSchemaClasses());
        classes.addAll(UpgradeDynamicWithLostGroups.getUpgradedSchemaClasses());
        return new SchemaBuilder().build(classes.toArray(new Class[classes.size()]));
    }

    public static Map<String, PairedMessages> createMessages() {
        LinkedHashMap<String, PairedMessages> messages = new LinkedHashMap<String, PairedMessages>();
        PairedTestProtocols.putAll(messages, "EnumArray.", UpgradeEnumArrayMessages.createMessages());
        PairedTestProtocols.putAll(messages, "Enums.", UpgradeEnumsMessages.createMessages());
        PairedTestProtocols.putAll(messages, "AddRemoveFields", UpgradeAddRemoveFieldMessages.createMessages());
        PairedTestProtocols.putAll(messages, "EnumSequence.", UpgradeEnumSequenceMessages.createMessages());
        PairedTestProtocols.putAll(messages, "IntegerEnums.", UpgradeIntegerEnumsMessages.createMessages());
        PairedTestProtocols.putAll(messages, "BasicMessages.", UpgradeBasicMessages.createMessages());
        PairedTestProtocols.putAll(messages, "GroupDefsMissing.", UpgradeMissingGroupDefs.createMessages());
        PairedTestProtocols.putAll(messages, "InheritedGroups.", UpgradeWithInheritedGroups.createMessages());
        PairedTestProtocols.putAll(messages, "InheritedGroups2.", UpgradeWithInheritedGroups2.createMessages());
        PairedTestProtocols.putAll(messages, "DynamicGroups.", UpgradeDynamicWithLostGroups.createMessages());
        return messages;
    }

    private static void putAll(Map<String, PairedMessages> result, String prefix, Map<String, PairedMessages> messages) {
        for (Map.Entry<String, PairedMessages> entry : messages.entrySet()) {
            result.put(prefix + entry.getKey(), entry.getValue());
        }
    }

    public static class PairedMessages {
        public final Object originalMessage;
        public final Object upgradedMessage;

        public PairedMessages(Object originalMessage, Object upgradedMessage) {
            Objects.requireNonNull(originalMessage);
            Objects.requireNonNull(upgradedMessage);
            this.originalMessage = originalMessage;
            this.upgradedMessage = upgradedMessage;
        }
    }
}

