/*
 * Decompiled with CFR 0.152.
 */
package com.cinnober.msgcodec.test.upgrade;

import com.cinnober.msgcodec.Group;
import com.cinnober.msgcodec.IncompatibleSchemaException;
import com.cinnober.msgcodec.MsgCodec;
import com.cinnober.msgcodec.Schema;
import com.cinnober.msgcodec.SchemaBinder;
import com.cinnober.msgcodec.test.upgrade.PairedTestProtocols;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;

public abstract class TestUpgradesSuite
extends Suite {
    protected TestUpgradesSuite(Class<?> rootClass, Function<Schema, MsgCodec> codecFactory) throws InitializationError {
        super(rootClass, TestUpgradesSuite.createRunners(codecFactory));
    }

    private static List<Runner> createRunners(Function<Schema, MsgCodec> codecFactory) throws InitializationError {
        ArrayList<Runner> runners = new ArrayList<Runner>();
        Schema originalSchema = PairedTestProtocols.getOriginalSchema();
        Schema upgradedSchema = PairedTestProtocols.getUpgradedSchema();
        try {
            for (Map.Entry<String, PairedTestProtocols.PairedMessages> messageEntry : PairedTestProtocols.createMessages().entrySet()) {
                runners.add(new InboundTest(originalSchema, upgradedSchema, codecFactory, "InboundTest." + messageEntry.getKey(), messageEntry.getValue().originalMessage, messageEntry.getValue().upgradedMessage));
                runners.add(new OutboundTest(originalSchema, upgradedSchema, codecFactory, "OutboundTest." + messageEntry.getKey(), messageEntry.getValue().originalMessage, messageEntry.getValue().upgradedMessage));
                runners.add(new InboundGroupTest(originalSchema, upgradedSchema, codecFactory, "InboundGroupTest." + messageEntry.getKey(), messageEntry.getValue().originalMessage, messageEntry.getValue().upgradedMessage));
                runners.add(new OutboundGroupTest(originalSchema, upgradedSchema, codecFactory, "OutboundGroupTest." + messageEntry.getKey(), messageEntry.getValue().originalMessage, messageEntry.getValue().upgradedMessage));
            }
        }
        catch (IncompatibleSchemaException e) {
            throw new InitializationError((Throwable)e);
        }
        return runners;
    }

    private static Group toGroup(Schema javaSchema, Schema groupSchema, Object javaEntity, Function<Schema, MsgCodec> codecFactory) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            codecFactory.apply(javaSchema).encode(javaEntity, (OutputStream)outputStream);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            return (Group)codecFactory.apply(groupSchema).decode((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to convert to Group!", e);
        }
    }

    private static Object fromGroup(Schema javaSchema, Schema groupSchema, Object groupEntity, Function<Schema, MsgCodec> codecFactory) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            codecFactory.apply(groupSchema).encode(groupEntity, (OutputStream)outputStream);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            return codecFactory.apply(javaSchema).decode((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to convert to Group!", e);
        }
    }

    public static class OutboundTest
    extends Runner {
        private final MsgCodec upgradeCodec;
        private final MsgCodec upgradedCodec;
        private final String label;
        private final Object originalMessage;
        private final Object upgradedMessage;
        private final Description description;

        private OutboundTest(Schema originalSchema, Schema upgradedSchema, Function<Schema, MsgCodec> codecFactory, String label, Object originalMessage, Object upgradedMessage) throws IncompatibleSchemaException {
            Schema outboundSchema = new SchemaBinder(originalSchema).bind(upgradedSchema.unbind(), g -> SchemaBinder.Direction.OUTBOUND);
            this.upgradeCodec = codecFactory.apply(outboundSchema);
            this.upgradedCodec = codecFactory.apply(upgradedSchema);
            this.label = label;
            this.originalMessage = originalMessage;
            this.upgradedMessage = upgradedMessage;
            this.description = Description.createTestDescription(OutboundTest.class, (String)label);
        }

        public String toString() {
            return this.label;
        }

        public Description getDescription() {
            return this.description;
        }

        public void run(RunNotifier notifier) {
            notifier.fireTestStarted(this.description);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                this.upgradeCodec.encode(this.originalMessage, (OutputStream)out);
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                Object object = this.upgradedCodec.decode((InputStream)in);
                if (object == null) {
                    Assert.fail((String)"Decoded message is null");
                }
                Assert.assertEquals((Object)this.upgradedMessage, (Object)object);
            }
            catch (Throwable e) {
                notifier.fireTestFailure(new Failure(this.description, e));
            }
            notifier.fireTestFinished(this.description);
        }
    }

    public static class InboundTest
    extends Runner {
        private final MsgCodec originalCodec;
        private final MsgCodec upgradeCodec;
        private final String label;
        private final Object originalMessage;
        private final Object upgradedMessage;
        private final Description description;

        private InboundTest(Schema originalSchema, Schema upgradedSchema, Function<Schema, MsgCodec> codecFactory, String label, Object originalMessage, Object upgradedMessage) throws IncompatibleSchemaException {
            Schema inboundSchema = new SchemaBinder(upgradedSchema).bind(originalSchema.unbind(), g -> SchemaBinder.Direction.INBOUND);
            this.originalCodec = codecFactory.apply(originalSchema);
            this.upgradeCodec = codecFactory.apply(inboundSchema);
            this.label = label;
            this.originalMessage = originalMessage;
            this.upgradedMessage = upgradedMessage;
            this.description = Description.createTestDescription(OutboundTest.class, (String)label);
        }

        public String toString() {
            return this.label;
        }

        public Description getDescription() {
            return this.description;
        }

        public void run(RunNotifier notifier) {
            notifier.fireTestStarted(this.description);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                this.originalCodec.encode(this.originalMessage, (OutputStream)out);
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                Object object = this.upgradeCodec.decode((InputStream)in);
                if (object == null) {
                    Assert.fail((String)"Decoded message is null");
                }
                Assert.assertEquals((Object)this.upgradedMessage, (Object)object);
            }
            catch (Throwable e) {
                notifier.fireTestFailure(new Failure(this.description, e));
            }
            notifier.fireTestFinished(this.description);
        }
    }

    public static class OutboundGroupTest
    extends Runner {
        private final MsgCodec upgradeCodec;
        private final MsgCodec upgradedCodec;
        private final String label;
        private final Object originalMessage;
        private final Object upgradedMessage;
        private final Description description;
        private final Schema originalJavaSchema;
        private final Schema upgradedJavaSchema;
        private final Schema originalGroupBound;
        private final Schema upgradedGroupBound;
        private Function<Schema, MsgCodec> codecFactory;

        private OutboundGroupTest(Schema originalJavaSchema, Schema upgradedJavaSchema, Function<Schema, MsgCodec> codecFactory, String label, Object originalMessage, Object upgradedMessage) throws IncompatibleSchemaException {
            this.originalGroupBound = Group.bind((Schema)originalJavaSchema.unbind());
            this.upgradedGroupBound = Group.bind((Schema)upgradedJavaSchema.unbind());
            this.originalJavaSchema = originalJavaSchema;
            this.upgradedJavaSchema = upgradedJavaSchema;
            this.codecFactory = codecFactory;
            Schema outboundSchema = new SchemaBinder(this.originalGroupBound).bind(this.upgradedGroupBound.unbind(), g -> SchemaBinder.Direction.OUTBOUND);
            this.upgradeCodec = codecFactory.apply(outboundSchema);
            this.upgradedCodec = codecFactory.apply(this.upgradedGroupBound);
            this.label = label;
            this.originalMessage = TestUpgradesSuite.toGroup(originalJavaSchema, this.originalGroupBound, originalMessage, codecFactory);
            this.upgradedMessage = TestUpgradesSuite.toGroup(upgradedJavaSchema, this.upgradedGroupBound, upgradedMessage, codecFactory);
            this.description = Description.createTestDescription(OutboundTest.class, (String)label);
        }

        public String toString() {
            return this.label;
        }

        public Description getDescription() {
            return this.description;
        }

        public void run(RunNotifier notifier) {
            notifier.fireTestStarted(this.description);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                this.upgradeCodec.encode(this.originalMessage, (OutputStream)out);
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                Object object = this.upgradedCodec.decode((InputStream)in);
                if (object == null) {
                    Assert.fail((String)"Decoded message is null");
                }
                Assert.assertEquals((Object)TestUpgradesSuite.fromGroup(this.upgradedJavaSchema, this.upgradedGroupBound, this.upgradedMessage, this.codecFactory), (Object)TestUpgradesSuite.fromGroup(this.upgradedJavaSchema, this.upgradedGroupBound, object, this.codecFactory));
            }
            catch (Throwable e) {
                notifier.fireTestFailure(new Failure(this.description, e));
            }
            notifier.fireTestFinished(this.description);
        }
    }

    public static class InboundGroupTest
    extends Runner {
        private final MsgCodec originalCodec;
        private final MsgCodec upgradeCodec;
        private final String label;
        private final Object originalMessage;
        private final Object upgradedMessage;
        private final Description description;
        private final Schema originalJavaSchema;
        private final Schema upgradedJavaSchema;
        private final Schema originalGroupBound;
        private final Schema upgradedGroupBound;
        private Function<Schema, MsgCodec> codecFactory;

        private InboundGroupTest(Schema originalJavaSchema, Schema upgradedJavaSchema, Function<Schema, MsgCodec> codecFactory, String label, Object originalMessage, Object upgradedMessage) throws IncompatibleSchemaException {
            this.originalGroupBound = Group.bind((Schema)originalJavaSchema.unbind());
            this.upgradedGroupBound = Group.bind((Schema)upgradedJavaSchema.unbind());
            this.originalJavaSchema = originalJavaSchema;
            this.upgradedJavaSchema = upgradedJavaSchema;
            this.codecFactory = codecFactory;
            Schema inboundSchema = new SchemaBinder(this.upgradedGroupBound).bind(this.originalGroupBound.unbind(), g -> SchemaBinder.Direction.INBOUND);
            this.originalCodec = codecFactory.apply(this.originalGroupBound);
            this.upgradeCodec = codecFactory.apply(inboundSchema);
            this.label = label;
            this.originalMessage = TestUpgradesSuite.toGroup(originalJavaSchema, this.originalGroupBound, originalMessage, codecFactory);
            this.upgradedMessage = TestUpgradesSuite.toGroup(upgradedJavaSchema, this.upgradedGroupBound, upgradedMessage, codecFactory);
            this.description = Description.createTestDescription(OutboundTest.class, (String)label);
        }

        public String toString() {
            return this.label;
        }

        public Description getDescription() {
            return this.description;
        }

        public void run(RunNotifier notifier) {
            notifier.fireTestStarted(this.description);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                this.originalCodec.encode(this.originalMessage, (OutputStream)out);
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                Object object = this.upgradeCodec.decode((InputStream)in);
                if (object == null) {
                    Assert.fail((String)"Decoded message is null");
                }
                Assert.assertEquals((Object)TestUpgradesSuite.fromGroup(this.upgradedJavaSchema, this.upgradedGroupBound, this.upgradedMessage, this.codecFactory), (Object)TestUpgradesSuite.fromGroup(this.upgradedJavaSchema, this.upgradedGroupBound, object, this.codecFactory));
            }
            catch (Throwable e) {
                notifier.fireTestFailure(new Failure(this.description, e));
            }
            notifier.fireTestFinished(this.description);
        }
    }
}

