/*
 * Decompiled with CFR 0.152.
 */
package com.cinnober.msgcodec.test.upgrade;

import com.cinnober.msgcodec.MsgObject;
import com.cinnober.msgcodec.anot.Id;
import com.cinnober.msgcodec.anot.Name;
import com.cinnober.msgcodec.test.upgrade.PairedTestProtocols;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class UpgradeBasicMessages {
    public static Map<String, PairedTestProtocols.PairedMessages> createMessages() {
        TreeMap<String, PairedTestProtocols.PairedMessages> testMessages = new TreeMap<String, PairedTestProtocols.PairedMessages>();
        testMessages.put("FloatToDouble", new PairedTestProtocols.PairedMessages((Object)new DecimalNarrow(3.14f), (Object)new DecimalWide(3.14)));
        testMessages.put("BytePrimitiveToByteObject", new PairedTestProtocols.PairedMessages((Object)new ByteNum(90), (Object)new OptByteNum((byte)90)));
        testMessages.put("ByteToShort", new PairedTestProtocols.PairedMessages((Object)new ByteNum2(90), (Object)new ShortNum(90)));
        testMessages.put("ByteToInt", new PairedTestProtocols.PairedMessages((Object)new ByteNum3(90), (Object)new IntNum(90)));
        testMessages.put("ByteToLong", new PairedTestProtocols.PairedMessages((Object)new ByteNum4(90), (Object)new LongNum(90L)));
        testMessages.put("ShortToInt", new PairedTestProtocols.PairedMessages((Object)new ShortNum2(90), (Object)new IntNum2(90)));
        testMessages.put("ShortToLong", new PairedTestProtocols.PairedMessages((Object)new ShortNum3(90), (Object)new LongNum2(90)));
        testMessages.put("IntToLong", new PairedTestProtocols.PairedMessages((Object)new IntNum3(90), (Object)new LongNum3(90)));
        testMessages.put("CharPrimitiveToCharObject", new PairedTestProtocols.PairedMessages((Object)new CharNum('a'), (Object)new OptCharNum(Character.valueOf('a'))));
        testMessages.put("CharToInt", new PairedTestProtocols.PairedMessages((Object)new CharNum1('\u1234'), (Object)new IntNum4(4660)));
        return testMessages;
    }

    public static Collection<Class<?>> getOriginalSchemaClasses() {
        return Arrays.asList(DecimalNarrow.class, ByteNum.class, ByteNum2.class, ByteNum3.class, ByteNum4.class, ShortNum2.class, ShortNum3.class, IntNum3.class, CharNum.class, CharNum1.class);
    }

    public static Collection<Class<?>> getUpgradedSchemaClasses() {
        return Arrays.asList(DecimalWide.class, OptByteNum.class, ShortNum.class, IntNum.class, LongNum.class, IntNum2.class, LongNum2.class, LongNum3.class, OptCharNum.class, IntNum4.class);
    }

    @Name(value="EnumEnt")
    @Id(value=1001)
    public static class EnumEntWide
    extends MsgObject {
        public EnumWide enumeration;

        public EnumEntWide() {
        }

        public EnumEntWide(EnumWide eValue) {
            this.enumeration = eValue;
        }
    }

    @Name(value="EnumEnt")
    @Id(value=1001)
    public static class EnumEntNarrow
    extends MsgObject {
        public EnumNarrow enumeration;

        public EnumEntNarrow() {
        }

        public EnumEntNarrow(EnumNarrow eValue) {
            this.enumeration = eValue;
        }
    }

    public static enum EnumWide {
        DUMMY_1,
        VALUE1,
        VALUE2,
        VALUE3,
        ADDITIONAL_VALUE;

    }

    public static enum EnumNarrow {
        VALUE3,
        VALUE1,
        VALUE2;

    }

    @Name(value="Number9")
    @Id(value=1009)
    public static class IntNum4
    extends MsgObject {
        public int n;

        public IntNum4() {
        }

        public IntNum4(int n) {
            this.n = n;
        }
    }

    @Name(value="Number9")
    @Id(value=1009)
    public static class CharNum1
    extends MsgObject {
        public char n;

        public CharNum1() {
        }

        public CharNum1(char n) {
            this.n = n;
        }
    }

    @Name(value="Number8")
    @Id(value=1008)
    public static class OptCharNum
    extends MsgObject {
        public Character n;

        public OptCharNum() {
        }

        public OptCharNum(Character n) {
            this.n = n;
        }
    }

    @Name(value="Number8")
    @Id(value=1008)
    public static class CharNum
    extends MsgObject {
        public char n;

        public CharNum() {
        }

        public CharNum(char n) {
            this.n = n;
        }
    }

    @Name(value="Number7")
    @Id(value=1007)
    public static class LongNum3
    extends MsgObject {
        public long n;

        public LongNum3() {
        }

        public LongNum3(int n) {
            this.n = n;
        }
    }

    @Name(value="Number7")
    @Id(value=1007)
    public static class IntNum3
    extends MsgObject {
        public int n;

        public IntNum3() {
        }

        public IntNum3(int n) {
            this.n = n;
        }
    }

    @Name(value="Number6")
    @Id(value=1006)
    public static class LongNum2
    extends MsgObject {
        public long n;

        public LongNum2() {
        }

        public LongNum2(int n) {
            this.n = n;
        }
    }

    @Name(value="Number6")
    @Id(value=1006)
    public static class ShortNum3
    extends MsgObject {
        public short n;

        public ShortNum3() {
        }

        public ShortNum3(short n) {
            this.n = n;
        }
    }

    @Name(value="Number5")
    @Id(value=1005)
    public static class IntNum2
    extends MsgObject {
        public int n;

        public IntNum2() {
        }

        public IntNum2(int n) {
            this.n = n;
        }
    }

    @Name(value="Number5")
    @Id(value=1005)
    public static class ShortNum2
    extends MsgObject {
        public short n;

        public ShortNum2() {
        }

        public ShortNum2(short n) {
            this.n = n;
        }
    }

    @Name(value="Number4")
    @Id(value=1004)
    public static class LongNum
    extends MsgObject {
        public long n;

        public LongNum() {
        }

        public LongNum(long n) {
            this.n = n;
        }
    }

    @Name(value="Number4")
    @Id(value=1004)
    public static class ByteNum4
    extends MsgObject {
        public byte n;

        public ByteNum4() {
        }

        public ByteNum4(byte n) {
            this.n = n;
        }
    }

    @Name(value="Number3")
    @Id(value=1003)
    public static class IntNum
    extends MsgObject {
        public int n;

        public IntNum() {
        }

        public IntNum(int n) {
            this.n = n;
        }
    }

    @Name(value="Number3")
    @Id(value=1003)
    public static class ByteNum3
    extends MsgObject {
        public byte n;

        public ByteNum3() {
        }

        public ByteNum3(byte n) {
            this.n = n;
        }
    }

    @Name(value="Number2")
    @Id(value=1002)
    public static class ShortNum
    extends MsgObject {
        public short n;

        public ShortNum() {
        }

        public ShortNum(short n) {
            this.n = n;
        }
    }

    @Name(value="Number2")
    @Id(value=1002)
    public static class ByteNum2
    extends MsgObject {
        public byte n;

        public ByteNum2() {
        }

        public ByteNum2(byte n) {
            this.n = n;
        }
    }

    @Name(value="Number")
    @Id(value=1001)
    public static class ByteNum
    extends MsgObject {
        public byte n;

        public ByteNum() {
        }

        public ByteNum(byte n) {
            this.n = n;
        }
    }

    @Name(value="Number")
    @Id(value=1001)
    public static class OptByteNum
    extends MsgObject {
        public Byte n;

        public OptByteNum() {
        }

        public OptByteNum(Byte n) {
            this.n = n;
        }
    }

    @Name(value="Decimal")
    @Id(value=999)
    public static class DecimalWide
    extends MsgObject {
        public double decimal;

        public DecimalWide() {
        }

        public DecimalWide(double decimal) {
            this.decimal = decimal;
        }

        public boolean equals(Object o) {
            return o instanceof DecimalWide && Math.abs(((DecimalWide)((Object)o)).decimal - this.decimal) < 1.0E-4;
        }
    }

    @Name(value="Decimal")
    @Id(value=999)
    public static class DecimalNarrow
    extends MsgObject {
        public float decimal;

        public DecimalNarrow() {
        }

        public DecimalNarrow(float decimal) {
            this.decimal = decimal;
        }
    }
}

