/*
 * Decompiled with CFR 0.152.
 */
package com.cinnober.msgcodec.test.upgrade;

import com.cinnober.msgcodec.anot.Dynamic;
import com.cinnober.msgcodec.anot.Id;
import com.cinnober.msgcodec.anot.Name;
import com.cinnober.msgcodec.test.upgrade.PairedTestProtocols;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class UpgradeMissingGroupDefs {
    public static Map<String, PairedTestProtocols.PairedMessages> createMessages() {
        TreeMap<String, PairedTestProtocols.PairedMessages> testMessages = new TreeMap<String, PairedTestProtocols.PairedMessages>();
        testMessages.put("GroupDefAdded", new PairedTestProtocols.PairedMessages(new BaseGroupV1(89), new BaseGroupV2(89)));
        testMessages.put("DynamicGroupDefAdded", new PairedTestProtocols.PairedMessages(new Base2GroupV1(892), new Base2GroupV2(892)));
        testMessages.put("GroupDefAddedInArray", new PairedTestProtocols.PairedMessages(new Base3GroupV1(893), new Base3GroupV2(893)));
        testMessages.put("GroupDefRemoved", new PairedTestProtocols.PairedMessages(new Base4GroupV1(891), new Base4GroupV2(891)));
        return testMessages;
    }

    public static Collection<Class<?>> getOriginalSchemaClasses() {
        return Arrays.asList(BaseGroupV1.class, Base2GroupV1.class, Base3GroupV1.class, Base4GroupV1.class, AnotherSubGroup.class);
    }

    public static Collection<Class<?>> getUpgradedSchemaClasses() {
        return Arrays.asList(BaseGroupV2.class, SubGroup.class, Base2GroupV2.class, SubGroup2.class, SubGroup3.class, SubGroup4.class, Base4GroupV2.class, Base3GroupV2.class);
    }

    @Name(value="GroupDefTestSUB4")
    @Id(value=6006)
    public static class SubGroup4
    extends SubGroup2 {
        public float value;
    }

    @Name(value="GroupDefTestSUB3")
    @Id(value=6005)
    public static class SubGroup3
    extends SubGroup2 {
        public boolean flag;
    }

    @Name(value="GroupDefTestSUB2")
    @Id(value=6009)
    public static class SubGroup2 {
        public String text;
    }

    @Name(value="GroupDefTestASUB")
    @Id(value=6007)
    public static class AnotherSubGroup {
        public String text;
    }

    @Name(value="GroupDefTestSUB")
    @Id(value=6004)
    public static class SubGroup {
        public String text;
    }

    @Name(value="GroupDefTestBase4")
    @Id(value=6010)
    public static class Base4GroupV2
    extends IdComparisonMixin {
        public int id;

        public Base4GroupV2(int id) {
            this.id = id;
        }

        public Base4GroupV2() {
        }

        @Override
        public int getId() {
            return this.id;
        }
    }

    @Name(value="GroupDefTestBase4")
    @Id(value=6010)
    public static class Base4GroupV1
    extends IdComparisonMixin {
        public int id;
        public AnotherSubGroup[] manySubs;

        public Base4GroupV1(int id) {
            this.id = id;
            this.manySubs = new AnotherSubGroup[id % 10];
            for (int i = 0; i < this.manySubs.length; ++i) {
                this.manySubs[i] = new AnotherSubGroup();
                this.manySubs[i].text = "TEXT " + (i + id);
            }
        }

        public Base4GroupV1() {
        }

        @Override
        public int getId() {
            return this.id;
        }
    }

    @Name(value="GroupDefTestBase3")
    @Id(value=6003)
    public static class Base3GroupV2
    extends IdComparisonMixin {
        public int id;
        public SubGroup[] manySubs;

        public Base3GroupV2(int id) {
            this.id = id;
            this.manySubs = new SubGroup[id % 10];
            for (int i = 0; i < this.manySubs.length; ++i) {
                this.manySubs[i] = new SubGroup();
                this.manySubs[i].text = "TEXT " + (i + id);
            }
        }

        public Base3GroupV2() {
        }

        @Override
        public int getId() {
            return this.id;
        }
    }

    @Name(value="GroupDefTestBase3")
    @Id(value=6003)
    public static class Base3GroupV1
    extends IdComparisonMixin {
        public int id;

        public Base3GroupV1(int id) {
            this.id = id;
        }

        public Base3GroupV1() {
        }

        @Override
        public int getId() {
            return this.id;
        }
    }

    @Name(value="GroupDefTestBase2")
    @Id(value=6002)
    public static class Base2GroupV2
    extends IdComparisonMixin {
        public int id;
        @Dynamic
        public SubGroup2 sub;

        public Base2GroupV2(int id) {
            this.id = id;
            this.sub = new SubGroup3();
            this.sub.text = "FUNTEXT";
        }

        public Base2GroupV2() {
        }

        @Override
        public int getId() {
            return this.id;
        }
    }

    @Name(value="GroupDefTestBase2")
    @Id(value=6002)
    public static class Base2GroupV1
    extends IdComparisonMixin {
        public int id;

        public Base2GroupV1(int id) {
            this.id = id;
        }

        public Base2GroupV1() {
        }

        @Override
        public int getId() {
            return this.id;
        }
    }

    @Name(value="GroupDefTestBase")
    @Id(value=6001)
    public static class BaseGroupV2
    extends IdComparisonMixin {
        public int id;
        public SubGroup sub;

        public BaseGroupV2(int id) {
            this.id = id;
            this.sub = new SubGroup();
            this.sub.text = "TEXT" + id;
        }

        public BaseGroupV2() {
        }

        @Override
        public int getId() {
            return this.id;
        }
    }

    @Name(value="GroupDefTestBase")
    @Id(value=6001)
    public static class BaseGroupV1
    extends IdComparisonMixin {
        public int id;

        public BaseGroupV1(int id) {
            this.id = id;
        }

        public BaseGroupV1() {
        }

        @Override
        public int getId() {
            return this.id;
        }
    }

    public static abstract class IdComparisonMixin {
        public boolean equals(Object obj) {
            return obj instanceof IdComparisonMixin && ((IdComparisonMixin)obj).getId() == this.getId();
        }

        public int hashCode() {
            return Objects.hash(this.getId());
        }

        public abstract int getId();
    }
}

