/*
 * Decompiled with CFR 0.152.
 */
package com.cinnober.msgcodec.xml;

import com.cinnober.msgcodec.FieldDef;
import com.cinnober.msgcodec.GroupDef;
import com.cinnober.msgcodec.GroupTypeAccessor;
import com.cinnober.msgcodec.ProtocolDictionary;
import com.cinnober.msgcodec.StreamCodec;
import com.cinnober.msgcodec.TypeDef;
import com.cinnober.msgcodec.xml.NsName;
import com.cinnober.msgcodec.xml.XmlBooleanFormat;
import com.cinnober.msgcodec.xml.XmlDocumentHandler;
import com.cinnober.msgcodec.xml.XmlElementHandler;
import com.cinnober.msgcodec.xml.XmlEnumFormat;
import com.cinnober.msgcodec.xml.XmlFormat;
import com.cinnober.msgcodec.xml.XmlNumberFormat;
import com.cinnober.msgcodec.xml.XmlStringFormat;
import com.cinnober.msgcodec.xml.XmlTimeFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlCodec
implements StreamCodec {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final String ANOT_XML_NAMESPACE = "xml:ns";
    private static final String ANOT_FIELD = "xml:field";
    private static final String ANOTVALUE_FIELD_ATTRIBUTE = "attribute";
    private static final String ANOTVALUE_FIELD_ELEMENT = "element";
    private static final String ANOTVALUE_FIELD_INLINE_ELEMENT = "inline";
    private final GroupTypeAccessor groupTypeAccessor;
    private final Map<NsName, XmlElementHandler.StaticGroupValue> staticGroupsByNsName;
    private final Map<String, XmlElementHandler.StaticGroupValue> staticGroupsByName;
    private final Map<Object, XmlElementHandler.StaticGroupValue> staticGroupsByGroupType;
    private String namespace;
    private final XmlDocumentHandler saxHandler;
    private final SAXParser saxParser;

    XmlCodec(ProtocolDictionary dictionary) throws ParserConfigurationException, SAXException {
        XmlElementHandler.StaticGroupValue groupInstruction;
        if (!dictionary.isBound()) {
            throw new IllegalArgumentException("ProtocolDictionary not bound");
        }
        this.groupTypeAccessor = dictionary.getBinding().getGroupTypeAccessor();
        int mapSize = dictionary.getGroups().size() * 2;
        this.staticGroupsByNsName = new HashMap<NsName, XmlElementHandler.StaticGroupValue>(mapSize);
        this.staticGroupsByName = new HashMap<String, XmlElementHandler.StaticGroupValue>(mapSize);
        this.staticGroupsByGroupType = new HashMap<Object, XmlElementHandler.StaticGroupValue>(mapSize);
        for (GroupDef groupDef : dictionary.getGroups()) {
            groupInstruction = new XmlElementHandler.StaticGroupValue(this.getNsName(groupDef), groupDef);
            this.staticGroupsByGroupType.put(groupDef.getGroupType(), groupInstruction);
            this.staticGroupsByName.put(groupDef.getName(), groupInstruction);
            this.staticGroupsByNsName.put(groupInstruction.getNsName(), groupInstruction);
        }
        for (GroupDef groupDef : dictionary.getGroups()) {
            groupInstruction = this.staticGroupsByGroupType.get(groupDef.getGroupType());
            LinkedHashMap<NsName, XmlElementHandler.FieldHandler> elementFields = new LinkedHashMap<NsName, XmlElementHandler.FieldHandler>();
            LinkedHashMap<NsName, XmlElementHandler.SimpleField> attributeFields = new LinkedHashMap<NsName, XmlElementHandler.SimpleField>();
            ArrayList<XmlElementHandler.SimpleField> inlineField = new ArrayList<XmlElementHandler.SimpleField>(1);
            if (groupDef.getSuperGroup() != null) {
                XmlElementHandler.StaticGroupValue superGroupInstruction = this.staticGroupsByName.get(groupDef.getSuperGroup());
                attributeFields.putAll(superGroupInstruction.getAttributeFields());
                elementFields.putAll(superGroupInstruction.getElementFields());
                if (superGroupInstruction.getInlineField() != null) {
                    inlineField.add(superGroupInstruction.getInlineField());
                }
            }
            for (FieldDef fieldDef : groupDef.getFields()) {
                this.createFieldInstruction(dictionary, fieldDef, fieldDef.getType(), attributeFields, elementFields, inlineField);
            }
            groupInstruction.init(attributeFields, elementFields, inlineField.isEmpty() ? null : (XmlElementHandler.SimpleField)inlineField.get(0));
        }
        this.saxHandler = new XmlDocumentHandler(this);
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        saxFactory.setNamespaceAware(true);
        this.saxParser = saxFactory.newSAXParser();
    }

    protected NsName getNsName(GroupDef groupDef) {
        String nsAnot = groupDef.getAnnotation(ANOT_XML_NAMESPACE);
        return new NsName(nsAnot != null ? nsAnot : this.namespace, this.toElementName(groupDef.getName()));
    }

    protected NsName getNsName(FieldDef fieldDef) {
        String nsAnot = fieldDef.getAnnotation(ANOT_XML_NAMESPACE);
        return new NsName(nsAnot != null ? nsAnot : this.namespace, this.toElementName(fieldDef.getName()));
    }

    private String toElementName(String name) {
        if (name.length() == 0) {
            return "";
        }
        StringBuilder str = new StringBuilder(name);
        str.setCharAt(0, Character.toLowerCase(str.charAt(0)));
        return str.toString();
    }

    private void createFieldInstruction(ProtocolDictionary dictionary, FieldDef field, TypeDef type, Map<NsName, XmlElementHandler.SimpleField> attributeFields, Map<NsName, XmlElementHandler.FieldHandler> elementFields, List<XmlElementHandler.SimpleField> inlineField) {
        NsName nsName = this.getNsName(field);
        type = dictionary.resolveToType(type, true);
        GroupDef typeGroup = dictionary.resolveToGroup(type);
        if (type instanceof TypeDef.Sequence) {
            TypeDef.Sequence sequenceType = (TypeDef.Sequence)type;
            TypeDef componentType = sequenceType.getComponentType();
            componentType = dictionary.resolveToType(componentType, true);
            GroupDef componentGroup = dictionary.resolveToGroup(componentType);
            XmlElementHandler.ValueHandler valueInstr = null;
            if (componentType instanceof TypeDef.Reference) {
                valueInstr = this.staticGroupsByName.get(componentGroup.getName());
            } else if (componentType instanceof TypeDef.DynamicReference) {
                valueInstr = new XmlElementHandler.DynamicGroupValue(this);
            } else if (componentType.getType() == TypeDef.Type.STRING) {
                valueInstr = new XmlElementHandler.StringItemValue(new NsName(null, "i"));
            } else if (componentType.getType() == TypeDef.Type.BINARY) {
                throw new RuntimeException("Sequence of binary not implemented yet");
            }
            if (valueInstr != null) {
                if (field.getJavaClass().isArray()) {
                    XmlElementHandler.ArraySequenceValueField fieldInstr = new XmlElementHandler.ArraySequenceValueField(nsName, field, valueInstr, field.getComponentJavaClass());
                    this.putElement(elementFields, fieldInstr);
                } else {
                    XmlElementHandler.ListSequenceValueField fieldInstr = new XmlElementHandler.ListSequenceValueField(nsName, field, valueInstr);
                    this.putElement(elementFields, fieldInstr);
                }
            } else {
                XmlFormat format = this.getXmlFormat(componentType, field.getComponentJavaClass());
                if (field.getJavaClass().isArray()) {
                    XmlElementHandler.ArraySequenceSimpleField fieldInstr = new XmlElementHandler.ArraySequenceSimpleField(nsName, field, format, field.getJavaClass().getComponentType());
                    this.putElement(elementFields, fieldInstr);
                } else {
                    XmlElementHandler.ListSequenceSimpleField fieldInstr = new XmlElementHandler.ListSequenceSimpleField(nsName, field, format);
                    this.putElement(elementFields, fieldInstr);
                }
            }
        } else if (type instanceof TypeDef.Reference && typeGroup != null) {
            boolean inline = !ANOTVALUE_FIELD_ELEMENT.equals(field.getAnnotation(ANOT_FIELD));
            XmlElementHandler.StaticGroupValue valueInstr = this.staticGroupsByName.get(typeGroup.getName());
            XmlElementHandler.FieldHandler fieldInstr = inline ? new XmlElementHandler.InlineElementValueField(nsName, field, valueInstr) : new XmlElementHandler.ElementValueField(nsName, field, valueInstr);
            this.putElement(elementFields, fieldInstr);
        } else if (type instanceof TypeDef.DynamicReference) {
            boolean inline = ANOTVALUE_FIELD_INLINE_ELEMENT.equals(field.getAnnotation(ANOT_FIELD));
            if (inline) {
                for (GroupDef subGroup : dictionary.getDynamicGroups(typeGroup != null ? typeGroup.getName() : null)) {
                    XmlElementHandler.StaticGroupValue valueInstr = this.staticGroupsByName.get(subGroup.getName());
                    XmlElementHandler.InlineElementValueField fieldInstr = new XmlElementHandler.InlineElementValueField(this.getNsName(subGroup), field, valueInstr);
                    this.putElement(elementFields, fieldInstr);
                }
            } else {
                this.putElement(elementFields, new XmlElementHandler.DynamicGroupField(nsName, field, this));
            }
        } else {
            if (type.getType() == TypeDef.Type.BINARY) {
                throw new RuntimeException("BINARY not implemented");
            }
            XmlFormat format = this.getXmlFormat(type, field.getJavaClass());
            XmlElementHandler.SimpleField fieldInstr = new XmlElementHandler.SimpleField(nsName, field, format);
            boolean attribute = !ANOTVALUE_FIELD_ELEMENT.equals(field.getAnnotation(ANOT_FIELD));
            boolean inline = ANOTVALUE_FIELD_INLINE_ELEMENT.equals(field.getAnnotation(ANOT_FIELD));
            if (inline) {
                this.putInline(inlineField, fieldInstr);
            } else if (attribute) {
                this.putAttribute(attributeFields, fieldInstr);
            } else {
                this.putElement(elementFields, fieldInstr);
            }
        }
    }

    private void putElement(Map<NsName, XmlElementHandler.FieldHandler> elementFields, XmlElementHandler.FieldHandler fieldInstr) {
        if (elementFields.put(fieldInstr.getNsName(), fieldInstr) != null) {
            throw new IllegalArgumentException("Duplicate elements: " + fieldInstr.getNsName());
        }
    }

    private void putAttribute(Map<NsName, XmlElementHandler.SimpleField> attributeFields, XmlElementHandler.SimpleField fieldInstr) {
        if (attributeFields.put(fieldInstr.getNsName(), fieldInstr) != null) {
            throw new IllegalArgumentException("Duplicate attributes: " + fieldInstr.getNsName());
        }
    }

    private void putInline(List<XmlElementHandler.SimpleField> inlineField, XmlElementHandler.SimpleField fieldInstr) {
        if (!inlineField.isEmpty()) {
            throw new IllegalArgumentException("Duplicate inline text field: " + fieldInstr.getNsName());
        }
        inlineField.add(fieldInstr);
    }

    private XmlFormat getXmlFormat(TypeDef type, Class<?> javaClass) {
        switch (type.getType()) {
            case ENUM: {
                if (javaClass.isEnum()) {
                    return new XmlEnumFormat.JavaEnumFormat((TypeDef.Enum)type, javaClass);
                }
                if (javaClass.equals(Integer.TYPE) || javaClass.equals(Integer.class)) {
                    return new XmlEnumFormat.IntEnumFormat((TypeDef.Enum)type);
                }
                throw new RuntimeException("Unhandled enum type: " + type);
            }
            case TIME: {
                if (javaClass.equals(Date.class)) {
                    return new XmlTimeFormat.DateTimeFormat((TypeDef.Time)type);
                }
                if (javaClass.equals(Integer.TYPE) || javaClass.equals(Integer.class)) {
                    return new XmlTimeFormat.UInt32TimeFormat((TypeDef.Time)type);
                }
                if (javaClass.equals(Long.TYPE) || javaClass.equals(Long.class)) {
                    return new XmlTimeFormat.UInt64TimeFormat((TypeDef.Time)type);
                }
                throw new RuntimeException("Unhandled time type: " + type);
            }
        }
        return this.getSimpleXmlFormat(type.getType());
    }

    private XmlFormat getSimpleXmlFormat(TypeDef.Type type) {
        switch (type) {
            case INT8: {
                return XmlNumberFormat.INT8;
            }
            case INT16: {
                return XmlNumberFormat.INT16;
            }
            case INT32: {
                return XmlNumberFormat.INT32;
            }
            case INT64: {
                return XmlNumberFormat.INT64;
            }
            case UINT8: {
                return XmlNumberFormat.UINT8;
            }
            case UINT16: {
                return XmlNumberFormat.UINT16;
            }
            case UINT32: {
                return XmlNumberFormat.UINT32;
            }
            case UINT64: {
                return XmlNumberFormat.UINT64;
            }
            case FLOAT32: {
                return XmlNumberFormat.FLOAT32;
            }
            case FLOAT64: {
                return XmlNumberFormat.FLOAT64;
            }
            case BIGINT: {
                return XmlNumberFormat.BIGINT;
            }
            case DECIMAL: {
                return XmlNumberFormat.DECIMAL;
            }
            case BIGDECIMAL: {
                return XmlNumberFormat.BIGDECIMAL;
            }
            case BOOLEAN: {
                return XmlBooleanFormat.BOOLEAN;
            }
            case STRING: {
                return XmlStringFormat.STRING;
            }
        }
        throw new RuntimeException("Unhandled type: " + type);
    }

    public void encode(Object group, OutputStream out) throws IOException {
        Object groupType = this.groupTypeAccessor.getGroupType(group);
        XmlElementHandler.StaticGroupValue groupInstr = this.staticGroupsByGroupType.get(groupType);
        if (groupInstr == null) {
            throw new IllegalArgumentException("Unknown Java class: " + group.getClass());
        }
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(out, UTF8));
        groupInstr.writeElementValue(group, groupInstr.getNsName(), writer);
        writer.flush();
    }

    public Object decode(InputStream in) throws IOException {
        try {
            this.saxParser.parse(in, (DefaultHandler)this.saxHandler);
            return this.saxHandler.getValue();
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    public XmlElementHandler.StaticGroupValue lookupGroup(NsName name) {
        return this.staticGroupsByNsName.get(name);
    }

    public XmlElementHandler.StaticGroupValue lookupGroup(Class<?> javaClass) {
        return this.staticGroupsByGroupType.get(javaClass);
    }
}

