/*
 * Decompiled with CFR 0.152.
 */
package com.cinnober.msgcodec.xml;

import com.cinnober.msgcodec.xml.NsName;
import com.cinnober.msgcodec.xml.XmlCodec;
import com.cinnober.msgcodec.xml.XmlContext;
import com.cinnober.msgcodec.xml.XmlElementHandler;
import java.util.LinkedHashMap;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class XmlDocumentHandler
extends DefaultHandler {
    private final Stack<XmlElementHandler> elementHandlerStack = new Stack();
    private final XmlElementHandler.DynamicGroupValue rootElementHandler;
    private final StringBuilder text = new StringBuilder();
    private final XmlContext context = new XmlContext();

    public XmlDocumentHandler(XmlCodec codec) {
        this.rootElementHandler = new XmlElementHandler.DynamicGroupValue(codec);
    }

    @Override
    public void startDocument() throws SAXException {
        this.elementHandlerStack.clear();
        this.elementHandlerStack.push(this.rootElementHandler);
        this.context.clear();
    }

    @Override
    public void endDocument() throws SAXException {
    }

    public Object getValue() {
        return this.context.peekValue();
    }

    private NsName toNsName(String uri, String localName, String qName) {
        if (uri == null || uri.length() == 0) {
            return new NsName(null, qName);
        }
        return new NsName(uri, localName);
    }

    private void clearText() {
        this.text.setLength(0);
    }

    private String getText() {
        return this.text.toString();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.text.append(ch, start, length);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        NsName nsName = this.toNsName(uri, localName, qName);
        XmlElementHandler elementHandler = this.elementHandlerStack.peek().lookupElement(this.context, nsName);
        if (elementHandler == null) {
            throw new SAXException("Unknown element: " + nsName);
        }
        LinkedHashMap<NsName, String> attrMap = new LinkedHashMap<NsName, String>(attributes.getLength());
        for (int i = 0; i < attributes.getLength(); ++i) {
            attrMap.put(this.toNsName(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i)), attributes.getValue(i));
        }
        this.elementHandlerStack.peek().startChildElement(this.context, elementHandler);
        this.elementHandlerStack.push(elementHandler);
        this.elementHandlerStack.peek().startElement(this.context, nsName, attrMap);
        this.clearText();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        XmlElementHandler elementHandler = this.elementHandlerStack.pop();
        elementHandler.endElement(this.context, this.getText());
        this.elementHandlerStack.peek().endChildElement(this.context, elementHandler);
    }
}

