/*
 * Decompiled with CFR 0.152.
 */
package com.cinnober.msgcodec.xml;

import com.cinnober.msgcodec.EnumSymbols;
import com.cinnober.msgcodec.TypeDef;
import com.cinnober.msgcodec.xml.FormatException;
import com.cinnober.msgcodec.xml.XmlFormat;
import java.util.HashMap;
import java.util.Map;

public abstract class XmlEnumFormat<T>
implements XmlFormat<T> {

    static class JavaEnumFormat<E extends Enum<E>>
    extends XmlEnumFormat<E> {
        private final EnumSymbols<E> enumSymbols;

        public JavaEnumFormat(TypeDef.Enum typeDef, Class<E> enumClass) {
            this.enumSymbols = new EnumSymbols(typeDef, enumClass);
        }

        @Override
        public String format(E value) throws FormatException {
            TypeDef.Symbol symbol = this.enumSymbols.getSymbol(value);
            if (symbol == null) {
                throw new FormatException("Not a valid enum: " + value);
            }
            return symbol.getName();
        }

        @Override
        public E parse(String str) throws FormatException {
            Enum value = this.enumSymbols.getEnum(str);
            if (value == null) {
                throw new FormatException("Not a valid symbol: " + str);
            }
            return (E)value;
        }
    }

    static class IntEnumFormat
    extends XmlEnumFormat<Integer> {
        private final Map<String, Integer> idByName;
        private final Map<Integer, String> nameById;

        public IntEnumFormat(TypeDef.Enum typeDef) {
            this.idByName = new HashMap<String, Integer>(typeDef.getSymbols().size() * 2);
            this.nameById = new HashMap<Integer, String>(typeDef.getSymbols().size() * 2);
            for (TypeDef.Symbol symbol : typeDef.getSymbols()) {
                this.idByName.put(symbol.getName(), symbol.getId());
                this.nameById.put(symbol.getId(), symbol.getName());
            }
        }

        @Override
        public String format(Integer value) throws FormatException {
            String name = this.nameById.get(value);
            if (name == null) {
                throw new FormatException("Not a valid enum: " + value);
            }
            return name;
        }

        @Override
        public Integer parse(String str) throws FormatException {
            Integer value = this.idByName.get(str);
            if (value == null) {
                throw new FormatException("Not a valid symbol: " + str);
            }
            return value;
        }
    }
}

