/*
 * Decompiled with CFR 0.152.
 */
package com.cinnober.msgcodec.xml;

import com.cinnober.msgcodec.xml.FormatException;
import com.cinnober.msgcodec.xml.XmlFormat;

public class XmlStringFormat
implements XmlFormat<String> {
    public static final XmlStringFormat STRING = new XmlStringFormat();

    private static StringBuilder escape(char ch, StringBuilder appendTo) {
        switch (ch) {
            case '<': {
                appendTo.append("&lt;");
                break;
            }
            case '>': {
                appendTo.append("&gt;");
                break;
            }
            case '&': {
                appendTo.append("&amp;");
                break;
            }
            case '\"': {
                appendTo.append("&quot;");
                break;
            }
            default: {
                appendTo.append(ch);
            }
        }
        return appendTo;
    }

    public static String escape(String value) {
        StringBuilder str = new StringBuilder((int)((double)value.length() * 1.2));
        for (int i = 0; i < value.length(); ++i) {
            XmlStringFormat.escape(value.charAt(i), str);
        }
        return str.toString();
    }

    @Override
    public String format(String value) {
        return XmlStringFormat.escape(value);
    }

    @Override
    public String parse(String str) throws FormatException {
        return str;
    }
}

