/*
 * Decompiled with CFR 0.152.
 */
package com.cinnober.msgcodec.xml;

import com.cinnober.msgcodec.Epoch;
import com.cinnober.msgcodec.TypeDef;
import com.cinnober.msgcodec.util.TimeFormat;
import com.cinnober.msgcodec.xml.FormatException;
import com.cinnober.msgcodec.xml.XmlFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public abstract class XmlTimeFormat<T>
implements XmlFormat<T> {
    private final TimeFormat timeFormat;

    protected XmlTimeFormat(TypeDef.Time type) {
        this.timeFormat = TimeFormat.getTimeFormat((TimeUnit)type.getUnit(), (Epoch)type.getEpoch());
    }

    protected abstract long convertToLong(T var1);

    protected abstract T convertFromLong(long var1);

    @Override
    public String format(T value) throws FormatException {
        return this.timeFormat.format(this.convertToLong(value));
    }

    @Override
    public T parse(String str) throws FormatException {
        try {
            return this.convertFromLong(this.timeFormat.parse((CharSequence)str));
        }
        catch (ParseException e) {
            throw new FormatException("Could not parse time", e);
        }
    }

    private static long getTimeInMillis(TimeUnit unit) {
        switch (unit) {
            case MILLISECONDS: {
                return 1L;
            }
            case SECONDS: {
                return 1000L;
            }
            case MINUTES: {
                return 60000L;
            }
            case HOURS: {
                return 3600000L;
            }
            case DAYS: {
                return 86400000L;
            }
        }
        throw new IllegalArgumentException("Date does not support " + (Object)((Object)unit));
    }

    private static long getEpochOffset(Epoch epoch) {
        switch (epoch) {
            case UNIX: {
                return 0L;
            }
            case Y2K: {
                return 946706400000L;
            }
            case MIDNIGHT: {
                return 0L;
            }
        }
        throw new IllegalArgumentException("Date does not support " + epoch);
    }

    static class DateTimeFormat
    extends XmlTimeFormat<Date> {
        private final long timeUnitInMillis;
        private final long epochOffset;

        public DateTimeFormat(TypeDef.Time type) {
            super(type);
            this.timeUnitInMillis = XmlTimeFormat.getTimeInMillis(type.getUnit());
            this.epochOffset = XmlTimeFormat.getEpochOffset(type.getEpoch());
        }

        @Override
        protected long convertToLong(Date value) {
            return (value.getTime() - this.epochOffset) / this.timeUnitInMillis;
        }

        @Override
        protected Date convertFromLong(long value) {
            return new Date(value * this.timeUnitInMillis + this.epochOffset);
        }
    }

    public static class UInt32TimeFormat
    extends XmlTimeFormat<Integer> {
        public UInt32TimeFormat(TypeDef.Time type) {
            super(type);
        }

        @Override
        protected Integer convertFromLong(long timeValue) {
            return (int)timeValue;
        }

        @Override
        protected long convertToLong(Integer value) {
            return value.intValue();
        }
    }

    public static class UInt64TimeFormat
    extends XmlTimeFormat<Long> {
        public UInt64TimeFormat(TypeDef.Time type) {
            super(type);
        }

        @Override
        protected Long convertFromLong(long timeValue) {
            return timeValue;
        }

        @Override
        protected long convertToLong(Long value) {
            return value;
        }
    }
}

