/*
 * Decompiled with CFR 0.152.
 */
package com.cinnober.msgcodec.xml;

import com.cinnober.msgcodec.SymbolMapping;
import com.cinnober.msgcodec.xml.FormatException;
import com.cinnober.msgcodec.xml.XmlFormat;
import java.util.Objects;

abstract class XmlEnumFormat<T>
implements XmlFormat<T> {
    XmlEnumFormat() {
    }

    static class DummyJavaEnumFormat<E extends Enum<E>>
    extends XmlEnumFormat<E> {
        @Override
        public String format(E value) throws FormatException {
            return null;
        }

        @Override
        public E parse(String str) throws FormatException {
            return null;
        }
    }

    static class SymbolMappingEnumFormat<T>
    extends XmlEnumFormat<T> {
        private final SymbolMapping<T> symbolMapping;

        public SymbolMappingEnumFormat(SymbolMapping<T> symbolMapping) {
            Objects.requireNonNull(symbolMapping);
            this.symbolMapping = symbolMapping;
        }

        @Override
        public String format(T value) throws FormatException {
            try {
                String name = this.symbolMapping.getName(value);
                if (name == null) {
                    throw new FormatException("Not a valid enum: " + value);
                }
                return name;
            }
            catch (IllegalArgumentException e) {
                throw new FormatException("Not a valid enum: " + value, e);
            }
        }

        @Override
        public T parse(String str) throws FormatException {
            try {
                Object value = this.symbolMapping.lookup(str);
                if (value == null) {
                    // empty if block
                }
                return (T)value;
            }
            catch (IllegalArgumentException e) {
                throw new FormatException("Not a valid symbol: " + str, e);
            }
        }
    }
}

