/*
 * Decompiled with CFR 0.152.
 */
package com.cinnober.msgcodec.xml;

import com.cinnober.msgcodec.Accessor;
import com.cinnober.msgcodec.CreateAccessor;
import com.cinnober.msgcodec.DecodeException;
import com.cinnober.msgcodec.FieldDef;
import com.cinnober.msgcodec.GroupDef;
import com.cinnober.msgcodec.GroupTypeAccessor;
import com.cinnober.msgcodec.MsgCodec;
import com.cinnober.msgcodec.Schema;
import com.cinnober.msgcodec.SymbolMapping;
import com.cinnober.msgcodec.TypeDef;
import com.cinnober.msgcodec.io.ByteSink;
import com.cinnober.msgcodec.io.ByteSinkOutputStream;
import com.cinnober.msgcodec.io.ByteSource;
import com.cinnober.msgcodec.io.ByteSourceInputStream;
import com.cinnober.msgcodec.xml.NsName;
import com.cinnober.msgcodec.xml.XmlBinaryFormat;
import com.cinnober.msgcodec.xml.XmlBooleanFormat;
import com.cinnober.msgcodec.xml.XmlDocumentHandler;
import com.cinnober.msgcodec.xml.XmlElementHandler;
import com.cinnober.msgcodec.xml.XmlEnumFormat;
import com.cinnober.msgcodec.xml.XmlFormat;
import com.cinnober.msgcodec.xml.XmlNumberFormat;
import com.cinnober.msgcodec.xml.XmlStringFormat;
import com.cinnober.msgcodec.xml.XmlTimeFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlCodec
implements MsgCodec {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final String ANOT_XML_NAMESPACE = "xml:ns";
    private static final String ANOT_FIELD = "xml:field";
    private static final String ANOTVALUE_FIELD_ATTRIBUTE = "attribute";
    private static final String ANOTVALUE_FIELD_ELEMENT = "element";
    private static final String ANOTVALUE_FIELD_INLINE = "inline";
    private final GroupTypeAccessor groupTypeAccessor;
    private final Map<NsName, XmlElementHandler.StaticGroupValue> staticGroupsByNsName;
    private final Map<String, XmlElementHandler.StaticGroupValue> staticGroupsByName;
    private final Map<Object, XmlElementHandler.StaticGroupValue> staticGroupsByGroupType;
    private final Schema schema;
    private String namespace;
    private final XmlDocumentHandler saxHandler;
    private final SAXParser saxParser;

    XmlCodec(Schema schema) throws ParserConfigurationException, SAXException {
        XmlElementHandler.StaticGroupValue groupInstruction;
        if (!schema.isBound()) {
            throw new IllegalArgumentException("Schema not bound");
        }
        this.schema = schema;
        this.groupTypeAccessor = schema.getBinding().getGroupTypeAccessor();
        int mapSize = schema.getGroups().size() * 2;
        this.staticGroupsByNsName = new HashMap<NsName, XmlElementHandler.StaticGroupValue>(mapSize);
        this.staticGroupsByName = new HashMap<String, XmlElementHandler.StaticGroupValue>(mapSize);
        this.staticGroupsByGroupType = new HashMap<Object, XmlElementHandler.StaticGroupValue>(mapSize);
        for (GroupDef groupDef : schema.getGroups()) {
            groupInstruction = new XmlElementHandler.StaticGroupValue(this.getNsName(groupDef), groupDef);
            this.staticGroupsByGroupType.put(groupDef.getGroupType(), groupInstruction);
            this.staticGroupsByName.put(groupDef.getName(), groupInstruction);
            this.staticGroupsByNsName.put(groupInstruction.getNsName(), groupInstruction);
        }
        for (GroupDef groupDef : schema.getGroups()) {
            groupInstruction = this.staticGroupsByName.get(groupDef.getName());
            LinkedHashMap<NsName, XmlElementHandler.FieldHandler> elementFields = new LinkedHashMap<NsName, XmlElementHandler.FieldHandler>();
            LinkedHashMap<NsName, XmlElementHandler.SimpleField> attributeFields = new LinkedHashMap<NsName, XmlElementHandler.SimpleField>();
            ArrayList<XmlElementHandler.SimpleField> inlineField = new ArrayList<XmlElementHandler.SimpleField>(1);
            int nextRequiredFieldSlot = 0;
            if (groupDef.getSuperGroup() != null) {
                XmlElementHandler.StaticGroupValue superGroupInstruction = this.staticGroupsByName.get(groupDef.getSuperGroup());
                attributeFields.putAll(superGroupInstruction.getAttributeFields());
                elementFields.putAll(superGroupInstruction.getElementFields());
                if (superGroupInstruction.getInlineField() != null) {
                    inlineField.add(superGroupInstruction.getInlineField());
                }
                nextRequiredFieldSlot = superGroupInstruction.getNumRequiredFields();
            }
            Iterator iterator = groupDef.getFields().iterator();
            while (iterator.hasNext()) {
                FieldDef fieldDef;
                this.createFieldInstruction(schema, fieldDef, (fieldDef = (FieldDef)iterator.next()).isRequired() ? nextRequiredFieldSlot++ : -1, attributeFields, elementFields, inlineField);
            }
            groupInstruction.init(attributeFields, elementFields, inlineField.isEmpty() ? null : (XmlElementHandler.SimpleField)inlineField.get(0));
        }
        this.saxHandler = new XmlDocumentHandler(this);
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        saxFactory.setNamespaceAware(true);
        this.saxParser = saxFactory.newSAXParser();
    }

    private NsName getNsName(GroupDef groupDef) {
        String nsAnot = groupDef.getAnnotation(ANOT_XML_NAMESPACE);
        return new NsName(nsAnot != null ? nsAnot : this.namespace, this.toElementName(groupDef.getName()));
    }

    private NsName getNsName(FieldDef fieldDef) {
        String nsAnot = fieldDef.getAnnotation(ANOT_XML_NAMESPACE);
        return new NsName(nsAnot != null ? nsAnot : this.namespace, this.toElementName(fieldDef.getName()));
    }

    private String toElementName(String name) {
        if (name.length() == 0) {
            return "";
        }
        StringBuilder str = new StringBuilder(name);
        str.setCharAt(0, Character.toLowerCase(str.charAt(0)));
        return str.toString();
    }

    private void createFieldInstruction(Schema schema, FieldDef field, int requiredFieldSlot, Map<NsName, XmlElementHandler.SimpleField> attributeFields, Map<NsName, XmlElementHandler.FieldHandler> elementFields, List<XmlElementHandler.SimpleField> inlineField) {
        NsName nsName = this.getNsName(field);
        TypeDef type = schema.resolveToType(field.getType(), true);
        GroupDef typeGroup = schema.resolveToGroup(type);
        if (type instanceof TypeDef.Sequence) {
            TypeDef.Sequence sequenceType = (TypeDef.Sequence)type;
            TypeDef componentType = sequenceType.getComponentType();
            componentType = schema.resolveToType(componentType, true);
            GroupDef componentGroup = schema.resolveToGroup(componentType);
            XmlElementHandler.ValueHandler valueInstr = null;
            if (componentType instanceof TypeDef.Reference) {
                valueInstr = this.staticGroupsByName.get(componentGroup.getName());
            } else if (componentType instanceof TypeDef.DynamicReference) {
                valueInstr = new XmlElementHandler.DynamicGroupValue(this);
            } else if (componentType.getType() == TypeDef.Type.STRING) {
                valueInstr = new XmlElementHandler.SequenceItemValue(new NsName(null, "i"), XmlStringFormat.STRING);
            } else if (componentType.getType() == TypeDef.Type.BINARY) {
                valueInstr = new XmlElementHandler.SequenceItemValue(new NsName(null, "i"), XmlBinaryFormat.BINARY);
            }
            if (valueInstr != null) {
                if (field.getJavaClass().isArray()) {
                    XmlElementHandler.ArraySequenceValueField fieldInstr = new XmlElementHandler.ArraySequenceValueField(nsName, field, requiredFieldSlot, valueInstr, field.getComponentJavaClass());
                    this.putElement(elementFields, fieldInstr);
                } else {
                    XmlElementHandler.ListSequenceValueField fieldInstr = new XmlElementHandler.ListSequenceValueField(nsName, field, requiredFieldSlot, valueInstr);
                    this.putElement(elementFields, fieldInstr);
                }
            } else {
                XmlFormat<?> format = this.getXmlFormat(componentType, field.getBinding().getSymbolMapping(), field.getComponentJavaClass(), field.getAccessor());
                if (field.getJavaClass().isArray()) {
                    XmlElementHandler.ArraySequenceSimpleField fieldInstr = new XmlElementHandler.ArraySequenceSimpleField(nsName, field, requiredFieldSlot, format, field.getJavaClass().getComponentType());
                    this.putElement(elementFields, fieldInstr);
                } else {
                    XmlElementHandler.ListSequenceSimpleField fieldInstr = new XmlElementHandler.ListSequenceSimpleField(nsName, field, requiredFieldSlot, format);
                    this.putElement(elementFields, fieldInstr);
                }
            }
        } else if (type instanceof TypeDef.Reference && typeGroup != null) {
            boolean inline = !ANOTVALUE_FIELD_ELEMENT.equals(field.getAnnotation(ANOT_FIELD));
            XmlElementHandler.StaticGroupValue valueInstr = this.staticGroupsByName.get(typeGroup.getName());
            XmlElementHandler.FieldHandler fieldInstr = inline ? new XmlElementHandler.InlineElementValueField(nsName, field, requiredFieldSlot, valueInstr) : new XmlElementHandler.ElementValueField(nsName, field, requiredFieldSlot, valueInstr);
            this.putElement(elementFields, fieldInstr);
        } else if (type instanceof TypeDef.DynamicReference) {
            boolean inline = ANOTVALUE_FIELD_INLINE.equals(field.getAnnotation(ANOT_FIELD));
            if (inline) {
                for (GroupDef subGroup : schema.getDynamicGroups(typeGroup != null ? typeGroup.getName() : null)) {
                    XmlElementHandler.StaticGroupValue valueInstr = this.staticGroupsByName.get(subGroup.getName());
                    XmlElementHandler.InlineElementValueField fieldInstr = new XmlElementHandler.InlineElementValueField(this.getNsName(subGroup), field, requiredFieldSlot, valueInstr);
                    this.putElement(elementFields, fieldInstr);
                }
            } else {
                this.putElement(elementFields, new XmlElementHandler.DynamicGroupField(nsName, field, requiredFieldSlot, this));
            }
        } else {
            XmlFormat<?> format = this.getXmlFormat(type, field.getBinding().getSymbolMapping(), field.getJavaClass(), field.getAccessor());
            XmlElementHandler.SimpleField fieldInstr = new XmlElementHandler.SimpleField(nsName, field, requiredFieldSlot, format);
            boolean attribute = !ANOTVALUE_FIELD_ELEMENT.equals(field.getAnnotation(ANOT_FIELD));
            boolean inline = ANOTVALUE_FIELD_INLINE.equals(field.getAnnotation(ANOT_FIELD));
            if (inline) {
                this.putInline(inlineField, fieldInstr);
            } else if (attribute) {
                this.putAttribute(attributeFields, fieldInstr);
            } else {
                this.putElement(elementFields, fieldInstr);
            }
        }
    }

    private void putElement(Map<NsName, XmlElementHandler.FieldHandler> elementFields, XmlElementHandler.FieldHandler fieldInstr) {
        if (elementFields.put(fieldInstr.getNsName(), fieldInstr) != null) {
            throw new IllegalArgumentException("Duplicate elements: " + fieldInstr.getNsName());
        }
    }

    private void putAttribute(Map<NsName, XmlElementHandler.SimpleField> attributeFields, XmlElementHandler.SimpleField fieldInstr) {
        if (attributeFields.put(fieldInstr.getNsName(), fieldInstr) != null) {
            throw new IllegalArgumentException("Duplicate attributes: " + fieldInstr.getNsName());
        }
    }

    private void putInline(List<XmlElementHandler.SimpleField> inlineField, XmlElementHandler.SimpleField fieldInstr) {
        if (!inlineField.isEmpty()) {
            throw new IllegalArgumentException("Duplicate inline text field: " + fieldInstr.getNsName());
        }
        inlineField.add(fieldInstr);
    }

    private XmlFormat<?> getXmlFormat(TypeDef type, SymbolMapping<?> symbolMapping, Class<?> javaClass, Accessor accessor) {
        switch (type.getType()) {
            case ENUM: {
                if (accessor instanceof CreateAccessor) {
                    return new XmlEnumFormat.DummyJavaEnumFormat();
                }
                return new XmlEnumFormat.SymbolMappingEnumFormat(symbolMapping);
            }
            case TIME: {
                if (javaClass.equals(Date.class)) {
                    return new XmlTimeFormat.DateTimeFormat((TypeDef.Time)type);
                }
                if (javaClass.equals(Integer.TYPE) || javaClass.equals(Integer.class)) {
                    return new XmlTimeFormat.UInt32TimeFormat((TypeDef.Time)type);
                }
                if (javaClass.equals(Long.TYPE) || javaClass.equals(Long.class)) {
                    return new XmlTimeFormat.UInt64TimeFormat((TypeDef.Time)type);
                }
                throw new RuntimeException("Unhandled time type: " + type);
            }
        }
        return this.getSimpleXmlFormat(type.getType());
    }

    private XmlFormat getSimpleXmlFormat(TypeDef.Type type) {
        switch (type) {
            case INT8: {
                return XmlNumberFormat.INT8;
            }
            case INT16: {
                return XmlNumberFormat.INT16;
            }
            case INT32: {
                return XmlNumberFormat.INT32;
            }
            case INT64: {
                return XmlNumberFormat.INT64;
            }
            case UINT8: {
                return XmlNumberFormat.UINT8;
            }
            case CHAR: {
                return XmlNumberFormat.CHAR;
            }
            case UINT16: {
                return XmlNumberFormat.UINT16;
            }
            case UINT32: {
                return XmlNumberFormat.UINT32;
            }
            case UINT64: {
                return XmlNumberFormat.UINT64;
            }
            case FLOAT32: {
                return XmlNumberFormat.FLOAT32;
            }
            case FLOAT64: {
                return XmlNumberFormat.FLOAT64;
            }
            case BIGINT: {
                return XmlNumberFormat.BIGINT;
            }
            case DECIMAL: {
                return XmlNumberFormat.DECIMAL;
            }
            case BIGDECIMAL: {
                return XmlNumberFormat.BIGDECIMAL;
            }
            case BOOLEAN: {
                return XmlBooleanFormat.BOOLEAN;
            }
            case STRING: {
                return XmlStringFormat.STRING;
            }
            case BINARY: {
                return XmlBinaryFormat.BINARY;
            }
        }
        throw new RuntimeException("Unhandled type: " + type);
    }

    public void encode(Object group, OutputStream out) throws IOException {
        Object groupType = this.groupTypeAccessor.getGroupType(group);
        XmlElementHandler.StaticGroupValue groupInstr = this.staticGroupsByGroupType.get(groupType);
        if (groupInstr == null) {
            GroupDef groupDef = this.schema.getGroup(groupType);
            XmlElementHandler.StaticGroupValue staticGroupValue = groupInstr = groupDef != null ? this.staticGroupsByName.get(groupDef.getName()) : null;
            if (groupInstr == null) {
                throw new IllegalArgumentException("Unknown Java class: " + group.getClass());
            }
        }
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(out, UTF8));
        groupInstr.writeElementValue(group, this.determineGroupClass(group), groupInstr.getNsName(), writer);
        writer.flush();
    }

    private Class<?> determineGroupClass(Object group) {
        if (group == null) {
            return null;
        }
        Object grTp = this.schema.getGroup(this.groupTypeAccessor.getGroupType(group)).getGroupType();
        return grTp instanceof Class ? (Class<?>)grTp : group.getClass();
    }

    public Object decode(InputStream in) throws IOException {
        try {
            this.saxParser.parse(in, (DefaultHandler)this.saxHandler);
            return this.saxHandler.getValue();
        }
        catch (SAXException e) {
            throw new DecodeException((Throwable)e);
        }
    }

    public void encode(Object group, ByteSink out) throws IOException {
        this.encode(group, (OutputStream)new ByteSinkOutputStream(out));
    }

    public Object decode(ByteSource in) throws IOException {
        return this.decode((InputStream)new ByteSourceInputStream(in));
    }

    XmlElementHandler.StaticGroupValue lookupGroup(NsName name) {
        return this.staticGroupsByNsName.get(name);
    }

    XmlElementHandler.StaticGroupValue lookupGroup(Class<?> javaClass) {
        XmlElementHandler.StaticGroupValue value = this.staticGroupsByGroupType.get(javaClass);
        if (value == null) {
            GroupDef groupDef = this.schema.getGroup((Object)value);
            value = groupDef != null ? this.staticGroupsByName.get(groupDef.getName()) : null;
        }
        return value;
    }
}

