/*
 * Decompiled with CFR 0.152.
 */
package com.cinnober.msgcodec.xml;

import java.util.BitSet;
import java.util.Stack;

class XmlContext {
    private final Stack<Object> context = new Stack();
    private final Stack<BitSet> requiredFields = new Stack();

    XmlContext() {
    }

    public void pushValue(Object value) {
        this.context.push(value);
    }

    public BitSet pushRequiredFields(int numRequiredFields) {
        BitSet bits = new BitSet(numRequiredFields);
        bits.set(0, numRequiredFields);
        this.requiredFields.push(bits);
        return bits;
    }

    public void clearRequiredFieldSlot(int requiredFieldSlot) {
        this.peekRequiredFields().clear(requiredFieldSlot);
    }

    public BitSet peekRequiredFields() {
        return this.requiredFields.peek();
    }

    public BitSet popRequiredFields() {
        return this.requiredFields.pop();
    }

    public Object popValue() {
        return this.context.pop();
    }

    public Object peekValue() {
        return this.context.peek();
    }

    public void clear() {
        this.context.clear();
        this.requiredFields.clear();
    }

    public String toString() {
        return this.context.toString();
    }
}

