/*
 * Decompiled with CFR 0.152.
 */
package com.cinnober.msgcodec.xml;

import com.cinnober.msgcodec.Accessor;
import com.cinnober.msgcodec.Factory;
import com.cinnober.msgcodec.FieldDef;
import com.cinnober.msgcodec.GroupDef;
import com.cinnober.msgcodec.xml.FormatException;
import com.cinnober.msgcodec.xml.NsName;
import com.cinnober.msgcodec.xml.XmlCodec;
import com.cinnober.msgcodec.xml.XmlContext;
import com.cinnober.msgcodec.xml.XmlFormat;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.xml.sax.SAXException;

class XmlElementHandler {
    private final NsName nsName;

    public XmlElementHandler(NsName nsName) {
        this.nsName = nsName;
    }

    public NsName getNsName() {
        return this.nsName;
    }

    public void startElement(XmlContext ctx, NsName nsName, Map<NsName, String> attributes) throws SAXException {
    }

    public void endElement(XmlContext ctx, String text) throws SAXException {
    }

    public XmlElementHandler lookupElement(XmlContext ctx, NsName nsName) throws SAXException {
        return null;
    }

    public void startChildElement(XmlContext ctx, XmlElementHandler element) throws SAXException {
    }

    public void endChildElement(XmlContext ctx, XmlElementHandler element) throws SAXException {
    }

    protected void appendElementName(PrintWriter writer, NsName elementName) {
        writer.append(elementName.getName());
    }

    protected void appendAttributeName(PrintWriter writer, NsName attributeName) {
        writer.append(attributeName.getName());
    }

    static class InlineElementValue
    extends ValueHandler {
        protected ValueHandler valueHandler;

        public InlineElementValue(NsName nsName, ValueHandler valueHandler) {
            super(nsName);
            this.valueHandler = valueHandler;
        }

        @Override
        public void startElement(XmlContext ctx, NsName name, Map<NsName, String> attributes) throws SAXException {
            this.valueHandler.startElement(ctx, name, attributes);
        }

        @Override
        public void endElement(XmlContext ctx, String text) throws SAXException {
            this.valueHandler.endElement(ctx, text);
        }

        @Override
        public XmlElementHandler lookupElement(XmlContext ctx, NsName name) throws SAXException {
            return this.valueHandler.lookupElement(ctx, name);
        }

        @Override
        public void startChildElement(XmlContext ctx, XmlElementHandler element) throws SAXException {
            this.valueHandler.startChildElement(ctx, element);
        }

        @Override
        public void endChildElement(XmlContext ctx, XmlElementHandler element) throws SAXException {
            this.valueHandler.endChildElement(ctx, element);
        }

        @Override
        public void writeElementValue(Object value, NsName name, PrintWriter appendTo) throws IOException {
            this.valueHandler.writeElementValue(value, name, appendTo);
        }
    }

    static class InlineElementValueField
    extends FieldHandler {
        protected ValueHandler valueHandler;

        public InlineElementValueField(NsName nsName, FieldDef field, int requiredFieldSlot, ValueHandler valueHandler) {
            super(nsName, field, requiredFieldSlot);
            this.valueHandler = valueHandler;
        }

        @Override
        public void startElement(XmlContext ctx, NsName name, Map<NsName, String> attributes) throws SAXException {
            super.startElement(ctx, name, attributes);
            this.valueHandler.startElement(ctx, name, attributes);
        }

        @Override
        public void endElement(XmlContext ctx, String text) throws SAXException {
            this.valueHandler.endElement(ctx, text);
            super.endElement(ctx, text);
        }

        @Override
        public XmlElementHandler lookupElement(XmlContext ctx, NsName name) throws SAXException {
            return this.valueHandler.lookupElement(ctx, name);
        }

        @Override
        public void startChildElement(XmlContext ctx, XmlElementHandler element) throws SAXException {
            this.valueHandler.startChildElement(ctx, element);
        }

        @Override
        public void endChildElement(XmlContext ctx, XmlElementHandler element) throws SAXException {
            this.valueHandler.endChildElement(ctx, element);
        }

        @Override
        public void writeElement(Object value, NsName name, PrintWriter appendTo) throws IOException {
            this.valueHandler.writeElementValue(value, name, appendTo);
        }
    }

    static class ArraySequenceSimpleField
    extends FieldHandler {
        protected final XmlFormat valueFormat;
        private final Class<?> componentType;

        public ArraySequenceSimpleField(NsName nsName, FieldDef field, int requiredFieldSlot, XmlFormat<?> valueHandler, Class<?> componentType) {
            super(nsName, field, requiredFieldSlot);
            this.valueFormat = valueHandler;
            this.componentType = componentType;
        }

        @Override
        public void endElement(XmlContext ctx, String text) throws SAXException {
            String[] split;
            ArrayList list = new ArrayList();
            for (String str : split = text.split("\\s+")) {
                if (str.isEmpty()) continue;
                try {
                    list.add(this.valueFormat.parse(str));
                }
                catch (FormatException e) {
                    throw new SAXException(e);
                }
            }
            Object array = Array.newInstance(this.componentType, list.size());
            int i = 0;
            for (Object value : list) {
                Array.set(array, i++, value);
            }
            this.accessor.setValue(ctx.peekValue(), array);
        }

        @Override
        public void writeElement(Object value, NsName name, PrintWriter appendTo) throws IOException {
            if (value == null) {
                return;
            }
            appendTo.append('<');
            this.appendElementName(appendTo, name);
            Object array = value;
            int length = Array.getLength(array);
            if (length == 0) {
                appendTo.println("/>");
            } else {
                appendTo.print('>');
                boolean whitespace = false;
                for (int i = 0; i < length; ++i) {
                    Object item = Array.get(array, i);
                    if (whitespace) {
                        appendTo.append(' ');
                    } else {
                        whitespace = true;
                    }
                    try {
                        appendTo.append(this.valueFormat.format(item));
                        continue;
                    }
                    catch (FormatException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                appendTo.append("</");
                this.appendElementName(appendTo, name);
                appendTo.println('>');
            }
        }
    }

    static class ListSequenceSimpleField
    extends FieldHandler {
        protected final XmlFormat valueFormat;

        public ListSequenceSimpleField(NsName nsName, FieldDef field, int requiredFieldSlot, XmlFormat<?> valueHandler) {
            super(nsName, field, requiredFieldSlot);
            this.valueFormat = valueHandler;
        }

        @Override
        public void endElement(XmlContext ctx, String text) throws SAXException {
            String[] split;
            ArrayList list = new ArrayList();
            for (String str : split = text.split("\\s+")) {
                if (str.isEmpty()) continue;
                try {
                    list.add(this.valueFormat.parse(str));
                }
                catch (FormatException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            this.accessor.setValue(ctx.peekValue(), list);
        }

        @Override
        public void writeElement(Object value, NsName name, PrintWriter appendTo) throws IOException {
            if (value == null) {
                return;
            }
            appendTo.append('<');
            this.appendElementName(appendTo, name);
            List list = (List)value;
            if (list.isEmpty()) {
                appendTo.println("/>");
            } else {
                appendTo.println('>');
                boolean whitespace = false;
                for (Object item : list) {
                    if (whitespace) {
                        appendTo.append(' ');
                    } else {
                        whitespace = true;
                    }
                    try {
                        appendTo.append(this.valueFormat.format(item));
                    }
                    catch (FormatException e) {
                        throw new IOException(e);
                    }
                }
                appendTo.append("</");
                this.appendElementName(appendTo, name);
                appendTo.println('>');
            }
        }
    }

    static class ArraySequenceValueField
    extends ListSequenceValueField {
        private final Class<?> componentType;

        public ArraySequenceValueField(NsName nsName, FieldDef field, int requiredFieldSlot, ValueHandler valueHandler, Class<?> componentType) {
            super(nsName, field, requiredFieldSlot, valueHandler);
            this.componentType = componentType;
        }

        @Override
        public void endElement(XmlContext ctx, String text) throws SAXException {
            List list = (List)ctx.popValue();
            Object array = Array.newInstance(this.componentType, list.size());
            int i = 0;
            for (Object value : list) {
                Array.set(array, i++, value);
            }
            ctx.pushValue(array);
            super.endElement(ctx, text);
        }

        @Override
        public void writeElement(Object array, NsName name, PrintWriter appendTo) throws IOException {
            if (array == null) {
                return;
            }
            appendTo.append('<');
            this.appendElementName(appendTo, name);
            int length = Array.getLength(array);
            if (length == 0) {
                appendTo.println("/>");
            } else {
                appendTo.println('>');
                for (int i = 0; i < length; ++i) {
                    Object item = Array.get(array, i);
                    this.valueHandler.writeElementValue(item, this.valueHandler.getNsName(), appendTo);
                }
                appendTo.append("</");
                this.appendElementName(appendTo, name);
                appendTo.println('>');
            }
        }
    }

    static class ListSequenceValueField
    extends FieldHandler {
        protected final ValueHandler valueHandler;

        public ListSequenceValueField(NsName nsName, FieldDef field, int requiredFieldSlot, ValueHandler valueHandler) {
            super(nsName, field, requiredFieldSlot);
            this.valueHandler = valueHandler;
        }

        @Override
        public void startElement(XmlContext ctx, NsName nsName, Map<NsName, String> attributes) throws SAXException {
            super.startElement(ctx, nsName, attributes);
            ctx.pushValue(new ArrayList());
        }

        @Override
        public XmlElementHandler lookupElement(XmlContext ctx, NsName name) {
            if (this.valueHandler.getNsName() != null || this.valueHandler.getNsName().equals(name)) {
                return this.valueHandler;
            }
            return null;
        }

        @Override
        public void endChildElement(XmlContext ctx, XmlElementHandler element) {
            Object item = ctx.popValue();
            List list = (List)ctx.peekValue();
            list.add(item);
        }

        @Override
        public void writeElement(Object value, NsName name, PrintWriter appendTo) throws IOException {
            if (value == null) {
                return;
            }
            appendTo.append('<');
            this.appendElementName(appendTo, name);
            List list = (List)value;
            if (list.isEmpty()) {
                appendTo.println("/>");
            } else {
                appendTo.println('>');
                for (Object item : list) {
                    this.valueHandler.writeElementValue(item, this.valueHandler.getNsName(), appendTo);
                }
                appendTo.append("</");
                this.appendElementName(appendTo, name);
                appendTo.println('>');
            }
        }
    }

    static class ElementValueField
    extends FieldHandler {
        private final ValueHandler valueHandler;

        public ElementValueField(NsName nsName, FieldDef field, int requiredFieldSlot, ValueHandler valueHandler) {
            super(nsName, field, requiredFieldSlot);
            this.valueHandler = valueHandler;
        }

        @Override
        public XmlElementHandler lookupElement(XmlContext ctx, NsName name) {
            if (this.valueHandler.getNsName() != null || this.valueHandler.getNsName().equals(name)) {
                return this.valueHandler;
            }
            return null;
        }

        @Override
        public void writeElement(Object value, NsName name, PrintWriter appendTo) throws IOException {
            if (value == null) {
                return;
            }
            appendTo.append('<');
            this.appendElementName(appendTo, name);
            appendTo.append('>');
            this.valueHandler.writeElementValue(value, this.valueHandler.getNsName(), appendTo);
            appendTo.append("</");
            this.appendElementName(appendTo, name);
            appendTo.println('>');
        }
    }

    static class SimpleField
    extends FieldHandler {
        private final XmlFormat format;

        public SimpleField(NsName nsName, FieldDef field, int requiredFieldSlot, XmlFormat format) {
            super(nsName, field, requiredFieldSlot);
            this.format = format;
        }

        public void handleAttribute(XmlContext ctx, NsName attribute, String text) throws SAXException {
            this.startElement(ctx, attribute, null);
            this.endElement(ctx, text);
        }

        public void handleText(XmlContext ctx, String text) throws SAXException {
            try {
                Object value = this.format.parse(text);
                Object group = ctx.peekValue();
                this.accessor.setValue(group, value);
            }
            catch (FormatException e) {
                throw new SAXException(e);
            }
        }

        @Override
        public void endElement(XmlContext ctx, String text) throws SAXException {
            this.handleText(ctx, text);
        }

        @Override
        public void writeElement(Object value, NsName name, PrintWriter appendTo) throws IOException {
            if (value == null) {
                return;
            }
            appendTo.append('<');
            this.appendElementName(appendTo, name);
            appendTo.append('>');
            this.writeText(value, appendTo);
            appendTo.append("</");
            this.appendElementName(appendTo, name);
            appendTo.println('>');
        }

        public void writeAttribute(Object value, NsName name, PrintWriter writer) throws IOException {
            if (value == null) {
                return;
            }
            writer.append(' ');
            this.appendAttributeName(writer, name);
            writer.append('=');
            writer.append('\"');
            this.writeText(value, writer);
            writer.append('\"');
        }

        public void writeText(Object value, PrintWriter writer) throws IOException {
            if (value == null) {
                return;
            }
            try {
                writer.append(this.format.format(value));
            }
            catch (FormatException e) {
                throw new IOException(e);
            }
        }
    }

    static class DynamicGroupField
    extends FieldHandler {
        private final XmlCodec codec;

        public DynamicGroupField(NsName name, FieldDef fieldDef, int requiredFieldSlot, XmlCodec codec) {
            super(name, fieldDef, requiredFieldSlot);
            this.codec = codec;
        }

        @Override
        public XmlElementHandler lookupElement(XmlContext ctx, NsName nsName) {
            return this.codec.lookupGroup(nsName);
        }

        @Override
        public void writeElement(Object value, NsName name, PrintWriter appendTo) throws IOException {
            if (value == null) {
                return;
            }
            appendTo.append('<');
            this.appendElementName(appendTo, name);
            appendTo.println('>');
            StaticGroupValue groupInstr = this.codec.lookupGroup(value.getClass());
            groupInstr.writeElementValue(value, groupInstr.getNsName(), appendTo);
            appendTo.append("</");
            this.appendElementName(appendTo, name);
            appendTo.println('>');
        }
    }

    static class DynamicGroupValue
    extends ValueHandler {
        private final XmlCodec codec;

        public DynamicGroupValue(XmlCodec codec) {
            super(null);
            this.codec = codec;
        }

        @Override
        public XmlElementHandler lookupElement(XmlContext ctx, NsName nsName) {
            return this.codec.lookupGroup(nsName);
        }

        @Override
        public void writeElementValue(Object value, NsName name, PrintWriter appendTo) throws IOException {
            if (value == null) {
                return;
            }
            StaticGroupValue groupInstr = this.codec.lookupGroup(value.getClass());
            groupInstr.writeElementValue(value, groupInstr.getNsName(), appendTo);
        }
    }

    static class StaticGroupValue
    extends ValueHandler {
        private final GroupDef groupDef;
        private final Factory factory;
        private Map<NsName, SimpleField> attributeFields;
        private Map<NsName, FieldHandler> elementFields;
        private SimpleField inlineField;
        private int numRequiredFields;

        public StaticGroupValue(NsName nsName, GroupDef groupDef) {
            super(nsName);
            this.groupDef = groupDef;
            this.factory = groupDef.getFactory();
        }

        public int getNumRequiredFields() {
            return this.numRequiredFields;
        }

        public void init(Map<NsName, SimpleField> attributeFields, Map<NsName, FieldHandler> elementFields, SimpleField inlineField) {
            if (!elementFields.isEmpty() && inlineField != null) {
                throw new IllegalArgumentException("Cannot have both elements and inline text fields in group");
            }
            this.attributeFields = attributeFields;
            this.elementFields = elementFields;
            this.inlineField = inlineField;
            this.numRequiredFields = Math.max(Stream.concat(attributeFields.values().stream(), elementFields.values().stream()).mapToInt(FieldHandler::getRequiredFieldSlot).max().orElse(-1), inlineField != null ? inlineField.getRequiredFieldSlot() : -1) + 1;
        }

        Map<NsName, SimpleField> getAttributeFields() {
            return this.attributeFields;
        }

        Map<NsName, FieldHandler> getElementFields() {
            return this.elementFields;
        }

        SimpleField getInlineField() {
            return this.inlineField;
        }

        @Override
        public void startElement(XmlContext ctx, NsName name, Map<NsName, String> attributes) throws SAXException {
            BitSet bits = ctx.pushRequiredFields(this.numRequiredFields);
            ctx.pushValue(this.factory.newInstance());
            for (Map.Entry<NsName, String> attribute : attributes.entrySet()) {
                SimpleField field = this.attributeFields.get(attribute.getKey());
                if (field == null) {
                    throw new SAXException("Unknown attribute: " + attribute.getKey());
                }
                field.handleAttribute(ctx, attribute.getKey(), attribute.getValue());
                if (!field.isRequired()) continue;
                bits.clear(field.getRequiredFieldSlot());
            }
        }

        @Override
        public XmlElementHandler lookupElement(XmlContext ctx, NsName name) {
            return this.elementFields.get(name);
        }

        @Override
        public void endChildElement(XmlContext ctx, XmlElementHandler element) {
            FieldHandler field = (FieldHandler)element;
            if (field.isRequired()) {
                ctx.clearRequiredFieldSlot(field.getRequiredFieldSlot());
            }
        }

        @Override
        public void endElement(XmlContext ctx, String text) throws SAXException {
            BitSet bits = ctx.popRequiredFields();
            if (this.inlineField != null) {
                this.inlineField.handleText(ctx, text);
                if (this.inlineField.isRequired()) {
                    bits.clear(this.inlineField.getRequiredFieldSlot());
                }
            }
            if (!bits.isEmpty()) {
                StringBuilder errorMessage = new StringBuilder("The following required fields are missing in " + this.groupDef.getName() + ": ");
                int missingField = bits.nextSetBit(0);
                while (missingField >= 0) {
                    boolean found = false;
                    String fieldName = this.getMissingFieldName(this.getAttributeFields().values(), missingField);
                    if (fieldName == null) {
                        fieldName = this.getMissingFieldName(this.getElementFields().values(), missingField);
                    }
                    if (fieldName == null && this.inlineField.getRequiredFieldSlot() == missingField) {
                        fieldName = this.inlineField.getNsName().getName();
                    }
                    errorMessage.append(fieldName).append(", ");
                    if (missingField == Integer.MAX_VALUE) break;
                    missingField = bits.nextSetBit(missingField + 1);
                }
                errorMessage.delete(errorMessage.length() - 2, errorMessage.length());
                throw new SAXException(errorMessage.toString());
            }
        }

        private String getMissingFieldName(Collection<? extends FieldHandler> fields, int missingField) {
            for (FieldHandler fieldHandler : fields) {
                if (fieldHandler.getRequiredFieldSlot() != missingField) continue;
                return fieldHandler.getNsName().getName();
            }
            return null;
        }

        @Override
        public void writeElementValue(Object value, NsName name, PrintWriter appendTo) throws IOException {
            this.writeElementValue(value, value.getClass(), name, appendTo);
        }

        protected void writeElementValue(Object value, Class<?> valueClass, NsName name, PrintWriter appendTo) throws IOException {
            if (value == null || !valueClass.equals(this.groupDef.getGroupType())) {
                return;
            }
            BitSet requiredFields = new BitSet(this.numRequiredFields);
            requiredFields.set(0, this.numRequiredFields);
            appendTo.append('<');
            this.appendElementName(appendTo, name);
            for (Map.Entry<NsName, SimpleField> attrEntry : this.attributeFields.entrySet()) {
                NsName attrName = attrEntry.getKey();
                SimpleField attrInstr = attrEntry.getValue();
                Object fieldValue = attrInstr.getValue(value);
                if (fieldValue == null) continue;
                attrInstr.writeAttribute(fieldValue, attrName, appendTo);
                if (!attrInstr.isRequired()) continue;
                requiredFields.clear(attrInstr.getRequiredFieldSlot());
            }
            boolean startElementOpen = true;
            if (this.inlineField != null) {
                Object fieldValue = this.inlineField.getValue(value);
                if (fieldValue != null) {
                    appendTo.append('>');
                    this.inlineField.writeText(fieldValue, appendTo);
                    appendTo.append("</");
                    this.appendElementName(appendTo, name);
                    appendTo.println('>');
                    if (this.inlineField.isRequired()) {
                        requiredFields.clear(this.inlineField.getRequiredFieldSlot());
                    }
                } else {
                    appendTo.println("/>");
                }
            } else {
                for (Map.Entry<NsName, FieldHandler> elemEntry : this.elementFields.entrySet()) {
                    NsName elemName = elemEntry.getKey();
                    FieldHandler elemInstr = elemEntry.getValue();
                    Object fieldValue = elemInstr.getValue(value);
                    if (fieldValue == null) continue;
                    if (startElementOpen) {
                        appendTo.println('>');
                        startElementOpen = false;
                    }
                    elemInstr.writeElement(fieldValue, elemName, appendTo);
                    if (!elemInstr.isRequired()) continue;
                    requiredFields.clear(elemInstr.getRequiredFieldSlot());
                }
                if (startElementOpen) {
                    appendTo.println("/>");
                } else {
                    appendTo.append("</");
                    this.appendElementName(appendTo, name);
                    appendTo.println('>');
                }
            }
            if (!requiredFields.isEmpty()) {
                throw new IllegalArgumentException("Some required fields are missing: " + requiredFields);
            }
        }
    }

    static class SequenceItemValue
    extends ValueHandler {
        private final XmlFormat format;

        public SequenceItemValue(NsName nsName, XmlFormat format) {
            super(nsName);
            this.format = Objects.requireNonNull(format);
        }

        @Override
        public void endElement(XmlContext ctx, String text) throws SAXException {
            try {
                ctx.pushValue(this.format.parse(text));
            }
            catch (FormatException e) {
                throw new SAXException(e);
            }
        }

        @Override
        public void writeElementValue(Object value, NsName name, PrintWriter appendTo) throws IOException {
            appendTo.append('<');
            this.appendElementName(appendTo, name);
            appendTo.append('>');
            try {
                appendTo.append(this.format.format(value));
            }
            catch (FormatException e) {
                throw new IOException(e);
            }
            appendTo.append("</");
            this.appendElementName(appendTo, name);
            appendTo.append('>');
        }
    }

    static abstract class ValueHandler
    extends XmlElementHandler {
        public ValueHandler(NsName nsName) {
            super(nsName);
        }

        public abstract void writeElementValue(Object var1, NsName var2, PrintWriter var3) throws IOException;
    }

    static abstract class FieldHandler
    extends XmlElementHandler {
        protected FieldDef field;
        private final int requiredFieldSlot;
        protected Accessor accessor;

        public FieldHandler(NsName nsName, FieldDef field, int requiredFieldSlot) {
            super(nsName);
            this.field = field;
            this.requiredFieldSlot = requiredFieldSlot;
            this.accessor = field.getAccessor();
        }

        @Override
        public void endElement(XmlContext ctx, String text) throws SAXException {
            Object value = ctx.popValue();
            Object group = ctx.peekValue();
            this.accessor.setValue(group, value);
        }

        public Object getValue(Object group) {
            return this.accessor.getValue(group);
        }

        public abstract void writeElement(Object var1, NsName var2, PrintWriter var3) throws IOException;

        boolean isRequired() {
            return this.field.isRequired();
        }

        int getRequiredFieldSlot() {
            return this.requiredFieldSlot;
        }
    }
}

