/*
 * Decompiled with CFR 0.152.
 */
package com.cinnober.msgcodec.xml;

import com.cinnober.msgcodec.xml.FormatException;
import com.cinnober.msgcodec.xml.XmlFormat;
import java.math.BigDecimal;
import java.math.BigInteger;

abstract class XmlNumberFormat<T>
implements XmlFormat<T> {
    public static final Int8NumberFormat INT8 = new Int8NumberFormat();
    public static final Int16NumberFormat INT16 = new Int16NumberFormat();
    public static final Int32NumberFormat INT32 = new Int32NumberFormat();
    public static final Int64NumberFormat INT64 = new Int64NumberFormat();
    public static final UInt8NumberFormat UINT8 = new UInt8NumberFormat();
    public static final CharacterNumberFormat CHAR = new CharacterNumberFormat();
    public static final UInt16NumberFormat UINT16 = new UInt16NumberFormat();
    public static final UInt32NumberFormat UINT32 = new UInt32NumberFormat();
    public static final UInt64NumberFormat UINT64 = new UInt64NumberFormat();
    public static final BigIntNumberFormat BIGINT = new BigIntNumberFormat();
    public static final FloatNumberFormat FLOAT32 = new FloatNumberFormat();
    public static final DoubleNumberFormat FLOAT64 = new DoubleNumberFormat();
    public static final DecimalNumberFormat DECIMAL = new DecimalNumberFormat();
    public static final BigDecimalNumberFormat BIGDECIMAL = new BigDecimalNumberFormat();

    XmlNumberFormat() {
    }

    protected String formatInt(long value) {
        return Long.toString(value);
    }

    protected long parseInt(String str) {
        return Long.parseLong(str);
    }

    protected long parseUInt(String str) throws FormatException {
        if (str.startsWith("-")) {
            throw new FormatException("Expected unsigned value: " + str);
        }
        return Long.parseLong(str);
    }

    protected String formatBigInt(BigInteger value) {
        return value.toString();
    }

    protected BigInteger parseBigInt(String str) {
        return new BigInteger(str);
    }

    protected float parseFloat(String str) {
        return Float.parseFloat(str);
    }

    protected double parseDouble(String str) {
        return Double.parseDouble(str);
    }

    protected String formatFloat(float value) {
        return Float.toString(value);
    }

    protected String formatDouble(double value) {
        return Double.toString(value);
    }

    protected String formatBigDecimal(BigDecimal value) {
        return value.toString();
    }

    protected BigDecimal parseBigDecimal(String str) {
        return new BigDecimal(str);
    }

    public static class BigDecimalNumberFormat
    extends XmlNumberFormat<BigDecimal> {
        @Override
        public String format(BigDecimal value) {
            return this.formatBigDecimal(value);
        }

        @Override
        public BigDecimal parse(String str) throws FormatException {
            return this.parseBigDecimal(str);
        }
    }

    public static class DecimalNumberFormat
    extends XmlNumberFormat<BigDecimal> {
        @Override
        public String format(BigDecimal value) {
            return this.formatBigDecimal(value);
        }

        @Override
        public BigDecimal parse(String str) throws FormatException {
            return this.parseBigDecimal(str);
        }
    }

    public static class DoubleNumberFormat
    extends XmlNumberFormat<Double> {
        @Override
        public String format(Double value) {
            return this.formatDouble(value);
        }

        @Override
        public Double parse(String str) throws FormatException {
            return this.parseDouble(str);
        }
    }

    public static class FloatNumberFormat
    extends XmlNumberFormat<Float> {
        @Override
        public String format(Float value) {
            return this.formatFloat(value.floatValue());
        }

        @Override
        public Float parse(String str) throws FormatException {
            return Float.valueOf(this.parseFloat(str));
        }
    }

    public static class BigIntNumberFormat
    extends XmlNumberFormat<BigInteger> {
        @Override
        public String format(BigInteger value) {
            return this.formatBigInt(value);
        }

        @Override
        public BigInteger parse(String str) throws FormatException {
            return this.parseBigInt(str);
        }
    }

    public static class UInt8NumberFormat
    extends XmlNumberFormat<Byte> {
        @Override
        public String format(Byte value) {
            return this.formatInt(0xFF & value);
        }

        @Override
        public Byte parse(String str) throws FormatException {
            return (byte)this.parseUInt(str);
        }
    }

    public static class CharacterNumberFormat
    extends XmlNumberFormat<Character> {
        @Override
        public String format(Character value) {
            return this.formatInt(0xFFFFL & (long)value.charValue());
        }

        @Override
        public Character parse(String str) throws FormatException {
            return Character.valueOf((char)this.parseUInt(str));
        }
    }

    public static class UInt16NumberFormat
    extends XmlNumberFormat<Short> {
        @Override
        public String format(Short value) {
            return this.formatInt(0xFFFFL & (long)value.shortValue());
        }

        @Override
        public Short parse(String str) throws FormatException {
            return (short)this.parseUInt(str);
        }
    }

    public static class UInt32NumberFormat
    extends XmlNumberFormat<Integer> {
        @Override
        public String format(Integer value) {
            return this.formatInt(0xFFFFFFFFL & (long)value.intValue());
        }

        @Override
        public Integer parse(String str) throws FormatException {
            return (int)this.parseUInt(str);
        }
    }

    public static class UInt64NumberFormat
    extends XmlNumberFormat<Long> {
        @Override
        public String format(Long valueObj) {
            long value = valueObj;
            if (value >= 0L) {
                return this.formatInt(value);
            }
            return this.formatBigInt(BigInteger.valueOf(value & Long.MAX_VALUE).setBit(63));
        }

        @Override
        public Long parse(String str) throws FormatException {
            return this.parseUInt(str);
        }
    }

    public static class Int8NumberFormat
    extends XmlNumberFormat<Byte> {
        @Override
        public String format(Byte value) {
            return this.formatInt(value.byteValue());
        }

        @Override
        public Byte parse(String str) throws FormatException {
            return (byte)this.parseInt(str);
        }
    }

    public static class Int16NumberFormat
    extends XmlNumberFormat<Short> {
        @Override
        public String format(Short value) {
            return this.formatInt(value.shortValue());
        }

        @Override
        public Short parse(String str) throws FormatException {
            return (short)this.parseInt(str);
        }
    }

    public static class Int32NumberFormat
    extends XmlNumberFormat<Integer> {
        @Override
        public String format(Integer value) {
            return this.formatInt(value.intValue());
        }

        @Override
        public Integer parse(String str) throws FormatException {
            return (int)this.parseInt(str);
        }
    }

    public static class Int64NumberFormat
    extends XmlNumberFormat<Long> {
        @Override
        public String format(Long value) {
            return this.formatInt(value);
        }

        @Override
        public Long parse(String str) throws FormatException {
            return this.parseInt(str);
        }
    }
}

