/*
 * Decompiled with CFR 0.152.
 */
package com.circleci.client.v2.model;

import com.circleci.client.v2.model.PipelineVcsCommit;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="VCS information for the pipeline.")
public class PipelineVcs {
    public static final String JSON_PROPERTY_PROVIDER_NAME = "provider_name";
    @JsonProperty(value="provider_name")
    private String providerName;
    public static final String JSON_PROPERTY_ORIGIN_REPOSITORY_URL = "origin_repository_url";
    @JsonProperty(value="origin_repository_url")
    private String originRepositoryUrl;
    public static final String JSON_PROPERTY_TARGET_REPOSITORY_URL = "target_repository_url";
    @JsonProperty(value="target_repository_url")
    private String targetRepositoryUrl;
    public static final String JSON_PROPERTY_REVISION = "revision";
    @JsonProperty(value="revision")
    private String revision;
    public static final String JSON_PROPERTY_BRANCH = "branch";
    @JsonProperty(value="branch")
    private String branch;
    public static final String JSON_PROPERTY_TAG = "tag";
    @JsonProperty(value="tag")
    private String tag;
    public static final String JSON_PROPERTY_COMMIT = "commit";
    @JsonProperty(value="commit")
    private PipelineVcsCommit commit = null;

    public PipelineVcs providerName(String providerName) {
        this.providerName = providerName;
        return this;
    }

    @ApiModelProperty(example="GitHub", required=true, value="Name of the VCS provider (e.g. GitHub, Bitbucket).")
    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public PipelineVcs originRepositoryUrl(String originRepositoryUrl) {
        this.originRepositoryUrl = originRepositoryUrl;
        return this;
    }

    @ApiModelProperty(example="https://github.com/CircleCI-Public/api-preview-docs", required=true, value="URL for the repository where the trigger originated. For fork-PR pipelines, this is the URL to the fork. For other pipelines the `origin_` and `target_repository_url`s will be the same.")
    public String getOriginRepositoryUrl() {
        return this.originRepositoryUrl;
    }

    public void setOriginRepositoryUrl(String originRepositoryUrl) {
        this.originRepositoryUrl = originRepositoryUrl;
    }

    public PipelineVcs targetRepositoryUrl(String targetRepositoryUrl) {
        this.targetRepositoryUrl = targetRepositoryUrl;
        return this;
    }

    @ApiModelProperty(example="https://github.com/CircleCI-Public/api-preview-docs", required=true, value="URL for the repository the trigger targets (i.e. the repository where the PR will be merged). For fork-PR pipelines, this is the URL to the parent repo. For other pipelines, the `origin_` and `target_repository_url`s will be the same.")
    public String getTargetRepositoryUrl() {
        return this.targetRepositoryUrl;
    }

    public void setTargetRepositoryUrl(String targetRepositoryUrl) {
        this.targetRepositoryUrl = targetRepositoryUrl;
    }

    public PipelineVcs revision(String revision) {
        this.revision = revision;
        return this;
    }

    @ApiModelProperty(example="f454a02b5d10fcccfd7d9dd7608a76d6493a98b4", required=true, value="The code revision the pipeline ran.")
    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public PipelineVcs branch(String branch) {
        this.branch = branch;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="feature/design-new-api", value="The branch where the pipeline ran. The HEAD commit on this branch was used for the pipeline. Note that `branch` and `tag` are mutually exclusive.")
    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public PipelineVcs tag(String tag) {
        this.tag = tag;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="v3.1.4159", value="The tag used by the pipeline. The commit that this tag points to was used for the pipeline. Note that `branch` and `tag` are mutually exclusive.")
    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public PipelineVcs commit(PipelineVcsCommit commit) {
        this.commit = commit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PipelineVcsCommit getCommit() {
        return this.commit;
    }

    public void setCommit(PipelineVcsCommit commit) {
        this.commit = commit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelineVcs pipelineVcs = (PipelineVcs)o;
        return Objects.equals(this.providerName, pipelineVcs.providerName) && Objects.equals(this.originRepositoryUrl, pipelineVcs.originRepositoryUrl) && Objects.equals(this.targetRepositoryUrl, pipelineVcs.targetRepositoryUrl) && Objects.equals(this.revision, pipelineVcs.revision) && Objects.equals(this.branch, pipelineVcs.branch) && Objects.equals(this.tag, pipelineVcs.tag) && Objects.equals(this.commit, pipelineVcs.commit);
    }

    public int hashCode() {
        return Objects.hash(this.providerName, this.originRepositoryUrl, this.targetRepositoryUrl, this.revision, this.branch, this.tag, this.commit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PipelineVcs {\n");
        sb.append("    providerName: ").append(this.toIndentedString(this.providerName)).append("\n");
        sb.append("    originRepositoryUrl: ").append(this.toIndentedString(this.originRepositoryUrl)).append("\n");
        sb.append("    targetRepositoryUrl: ").append(this.toIndentedString(this.targetRepositoryUrl)).append("\n");
        sb.append("    revision: ").append(this.toIndentedString(this.revision)).append("\n");
        sb.append("    branch: ").append(this.toIndentedString(this.branch)).append("\n");
        sb.append("    tag: ").append(this.toIndentedString(this.tag)).append("\n");
        sb.append("    commit: ").append(this.toIndentedString(this.commit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

