/*
 * Decompiled with CFR 0.152.
 */
package com.circleci.client.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.UUID;

@ApiModel(description="A workflow")
public class Workflow {
    public static final String JSON_PROPERTY_ID = "id";
    @JsonProperty(value="id")
    private UUID id;
    public static final String JSON_PROPERTY_NAME = "name";
    @JsonProperty(value="name")
    private String name;
    public static final String JSON_PROPERTY_STATUS = "status";
    @JsonProperty(value="status")
    private StatusEnum status;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    @JsonProperty(value="created_at")
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_STOPPED_AT = "stopped_at";
    @JsonProperty(value="stopped_at")
    private OffsetDateTime stoppedAt;
    public static final String JSON_PROPERTY_PIPELINE_ID = "pipeline_id";
    @JsonProperty(value="pipeline_id")
    private UUID pipelineId;
    public static final String JSON_PROPERTY_PIPELINE_NUMBER = "pipeline_number";
    @JsonProperty(value="pipeline_number")
    private Long pipelineNumber;
    public static final String JSON_PROPERTY_PROJECT_SLUG = "project_slug";
    @JsonProperty(value="project_slug")
    private String projectSlug;

    public Workflow id(UUID id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique ID of the workflow.")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public Workflow name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="build-and-test", required=true, value="The name of the workflow.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Workflow status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The current status of the workflow.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Workflow createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="The date and time the workflow was created.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Workflow stoppedAt(OffsetDateTime stoppedAt) {
        this.stoppedAt = stoppedAt;
        return this;
    }

    @ApiModelProperty(required=true, value="The date and time the workflow stopped.")
    public OffsetDateTime getStoppedAt() {
        return this.stoppedAt;
    }

    public void setStoppedAt(OffsetDateTime stoppedAt) {
        this.stoppedAt = stoppedAt;
    }

    public Workflow pipelineId(UUID pipelineId) {
        this.pipelineId = pipelineId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the pipeline this workflow belongs to.")
    public UUID getPipelineId() {
        return this.pipelineId;
    }

    public void setPipelineId(UUID pipelineId) {
        this.pipelineId = pipelineId;
    }

    public Workflow pipelineNumber(Long pipelineNumber) {
        this.pipelineNumber = pipelineNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of the pipeline this workflow belongs to.")
    public Long getPipelineNumber() {
        return this.pipelineNumber;
    }

    public void setPipelineNumber(Long pipelineNumber) {
        this.pipelineNumber = pipelineNumber;
    }

    public Workflow projectSlug(String projectSlug) {
        this.projectSlug = projectSlug;
        return this;
    }

    @ApiModelProperty(example="gh/CircleCI-Public/api-preview-docs", required=true, value="The project-slug for the pipeline this workflow belongs to.")
    public String getProjectSlug() {
        return this.projectSlug;
    }

    public void setProjectSlug(String projectSlug) {
        this.projectSlug = projectSlug;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Workflow workflow = (Workflow)o;
        return Objects.equals(this.id, workflow.id) && Objects.equals(this.name, workflow.name) && Objects.equals((Object)this.status, (Object)workflow.status) && Objects.equals(this.createdAt, workflow.createdAt) && Objects.equals(this.stoppedAt, workflow.stoppedAt) && Objects.equals(this.pipelineId, workflow.pipelineId) && Objects.equals(this.pipelineNumber, workflow.pipelineNumber) && Objects.equals(this.projectSlug, workflow.projectSlug);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.status, this.createdAt, this.stoppedAt, this.pipelineId, this.pipelineNumber, this.projectSlug});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Workflow {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    stoppedAt: ").append(this.toIndentedString(this.stoppedAt)).append("\n");
        sb.append("    pipelineId: ").append(this.toIndentedString(this.pipelineId)).append("\n");
        sb.append("    pipelineNumber: ").append(this.toIndentedString(this.pipelineNumber)).append("\n");
        sb.append("    projectSlug: ").append(this.toIndentedString(this.projectSlug)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        SUCCESS("success"),
        RUNNING("running"),
        NOT_RUN("not_run"),
        FAILED("failed"),
        ERROR("error"),
        FAILING("failing"),
        ON_HOLD("on_hold"),
        CANCELED("canceled"),
        UNAUTHORIZED("unauthorized");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

