/*
 * Decompiled with CFR 0.152.
 */
package com.circleci.client.v2.api;

import com.circleci.client.v2.ApiClient;
import com.circleci.client.v2.ApiException;
import com.circleci.client.v2.ApiResponse;
import com.circleci.client.v2.Configuration;
import com.circleci.client.v2.Pair;
import com.circleci.client.v2.model.PipelineConfig;
import com.circleci.client.v2.model.PipelineLight;
import com.circleci.client.v2.model.PipelineListResponse;
import com.circleci.client.v2.model.TriggerPipelineParameters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.ws.rs.core.GenericType;

public class PipelineApi {
    private ApiClient apiClient;

    public PipelineApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PipelineApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public PipelineConfig getPipelineConfigById(UUID pipelineId) throws ApiException {
        return this.getPipelineConfigByIdWithHttpInfo(pipelineId).getData();
    }

    public ApiResponse<PipelineConfig> getPipelineConfigByIdWithHttpInfo(UUID pipelineId) throws ApiException {
        Object localVarPostBody = new Object();
        if (pipelineId == null) {
            throw new ApiException(400, "Missing the required parameter 'pipelineId' when calling getPipelineConfigById");
        }
        String localVarPath = "/pipeline/{pipeline-id}/config".replaceAll("\\{pipeline-id\\}", this.apiClient.escapeString(pipelineId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<PipelineConfig> localVarReturnType = new GenericType<PipelineConfig>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PipelineListResponse listMyPipelines(String projectSlug, String pageToken) throws ApiException {
        return this.listMyPipelinesWithHttpInfo(projectSlug, pageToken).getData();
    }

    public ApiResponse<PipelineListResponse> listMyPipelinesWithHttpInfo(String projectSlug, String pageToken) throws ApiException {
        Object localVarPostBody = new Object();
        if (projectSlug == null) {
            throw new ApiException(400, "Missing the required parameter 'projectSlug' when calling listMyPipelines");
        }
        String localVarPath = "/project/{project-slug}/pipeline/mine".replaceAll("\\{project-slug\\}", this.apiClient.escapeString(projectSlug.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page-token", pageToken));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<PipelineListResponse> localVarReturnType = new GenericType<PipelineListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PipelineListResponse listPipelinesForProject(String projectSlug, String pageToken) throws ApiException {
        return this.listPipelinesForProjectWithHttpInfo(projectSlug, pageToken).getData();
    }

    public ApiResponse<PipelineListResponse> listPipelinesForProjectWithHttpInfo(String projectSlug, String pageToken) throws ApiException {
        Object localVarPostBody = new Object();
        if (projectSlug == null) {
            throw new ApiException(400, "Missing the required parameter 'projectSlug' when calling listPipelinesForProject");
        }
        String localVarPath = "/project/{project-slug}/pipeline".replaceAll("\\{project-slug\\}", this.apiClient.escapeString(projectSlug.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page-token", pageToken));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<PipelineListResponse> localVarReturnType = new GenericType<PipelineListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PipelineLight triggerPipeline(String projectSlug, TriggerPipelineParameters triggerPipelineParameters) throws ApiException {
        return this.triggerPipelineWithHttpInfo(projectSlug, triggerPipelineParameters).getData();
    }

    public ApiResponse<PipelineLight> triggerPipelineWithHttpInfo(String projectSlug, TriggerPipelineParameters triggerPipelineParameters) throws ApiException {
        TriggerPipelineParameters localVarPostBody = triggerPipelineParameters;
        if (projectSlug == null) {
            throw new ApiException(400, "Missing the required parameter 'projectSlug' when calling triggerPipeline");
        }
        String localVarPath = "/project/{project-slug}/pipeline".replaceAll("\\{project-slug\\}", this.apiClient.escapeString(projectSlug.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<PipelineLight> localVarReturnType = new GenericType<PipelineLight>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

