/*
 * Decompiled with CFR 0.152.
 */
package com.circleci.client.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

public class CheckoutKey {
    public static final String JSON_PROPERTY_PUBLIC_KEY = "public-key";
    @JsonProperty(value="public-key")
    private String publicKey;
    public static final String JSON_PROPERTY_TYPE = "type";
    @JsonProperty(value="type")
    private TypeEnum type;
    public static final String JSON_PROPERTY_FINGERPRINT = "fingerprint";
    @JsonProperty(value="fingerprint")
    private String fingerprint;
    public static final String JSON_PROPERTY_PREFERRED = "preferred";
    @JsonProperty(value="preferred")
    private Boolean preferred;
    public static final String JSON_PROPERTY_TIME = "time";
    @JsonProperty(value="time")
    private OffsetDateTime time;

    public CheckoutKey publicKey(String publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    @ApiModelProperty(example="ssh-rsa ...", required=true, value="A public SSH key.")
    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public CheckoutKey type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="deploy-key", required=true, value="The type of checkout key. This may be either `deploy-key` or `github-user-key`.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public CheckoutKey fingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
        return this;
    }

    @ApiModelProperty(example="c9:0b:1c:4f:d5:65:56:b9:ad:88:f9:81:2b:37:74:2f", required=true, value="An SSH key fingerprint.")
    public String getFingerprint() {
        return this.fingerprint;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public CheckoutKey preferred(Boolean preferred) {
        this.preferred = preferred;
        return this;
    }

    @ApiModelProperty(example="true", required=true, value="A boolean value that indicates if this key is preferred.")
    public Boolean getPreferred() {
        return this.preferred;
    }

    public void setPreferred(Boolean preferred) {
        this.preferred = preferred;
    }

    public CheckoutKey time(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    @ApiModelProperty(required=true, value="The date and time the checkout key was created.")
    public OffsetDateTime getTime() {
        return this.time;
    }

    public void setTime(OffsetDateTime time) {
        this.time = time;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckoutKey checkoutKey = (CheckoutKey)o;
        return Objects.equals(this.publicKey, checkoutKey.publicKey) && Objects.equals((Object)this.type, (Object)checkoutKey.type) && Objects.equals(this.fingerprint, checkoutKey.fingerprint) && Objects.equals(this.preferred, checkoutKey.preferred) && Objects.equals(this.time, checkoutKey.time);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.publicKey, this.type, this.fingerprint, this.preferred, this.time});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CheckoutKey {\n");
        sb.append("    publicKey: ").append(this.toIndentedString(this.publicKey)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    fingerprint: ").append(this.toIndentedString(this.fingerprint)).append("\n");
        sb.append("    preferred: ").append(this.toIndentedString(this.preferred)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        DEPLOY_KEY("deploy-key"),
        GITHUB_USER_KEY("github-user-key");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

