/*
 * Decompiled with CFR 0.152.
 */
package com.circleci.client.v2.api;

import com.circleci.client.v2.ApiClient;
import com.circleci.client.v2.ApiException;
import com.circleci.client.v2.ApiResponse;
import com.circleci.client.v2.Configuration;
import com.circleci.client.v2.Pair;
import com.circleci.client.v2.model.CheckoutKey;
import com.circleci.client.v2.model.CheckoutKeyInput;
import com.circleci.client.v2.model.CheckoutKeyListResponse;
import com.circleci.client.v2.model.EnvironmentVariableListResponse;
import com.circleci.client.v2.model.EnvironmentVariablePair;
import com.circleci.client.v2.model.EnvironmentVariablePair1;
import com.circleci.client.v2.model.MessageResponse;
import com.circleci.client.v2.model.Project;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class ProjectApi {
    private ApiClient apiClient;

    public ProjectApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProjectApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CheckoutKey createCheckoutKey(String projectSlug, CheckoutKeyInput checkoutKeyInput) throws ApiException {
        return this.createCheckoutKeyWithHttpInfo(projectSlug, checkoutKeyInput).getData();
    }

    public ApiResponse<CheckoutKey> createCheckoutKeyWithHttpInfo(String projectSlug, CheckoutKeyInput checkoutKeyInput) throws ApiException {
        CheckoutKeyInput localVarPostBody = checkoutKeyInput;
        if (projectSlug == null) {
            throw new ApiException(400, "Missing the required parameter 'projectSlug' when calling createCheckoutKey");
        }
        String localVarPath = "/project/{project-slug}/checkout-key".replaceAll("\\{project-slug\\}", this.apiClient.escapeString(projectSlug.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<CheckoutKey> localVarReturnType = new GenericType<CheckoutKey>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EnvironmentVariablePair createEnvVar(String projectSlug, EnvironmentVariablePair1 environmentVariablePair1) throws ApiException {
        return this.createEnvVarWithHttpInfo(projectSlug, environmentVariablePair1).getData();
    }

    public ApiResponse<EnvironmentVariablePair> createEnvVarWithHttpInfo(String projectSlug, EnvironmentVariablePair1 environmentVariablePair1) throws ApiException {
        EnvironmentVariablePair1 localVarPostBody = environmentVariablePair1;
        if (projectSlug == null) {
            throw new ApiException(400, "Missing the required parameter 'projectSlug' when calling createEnvVar");
        }
        String localVarPath = "/project/{project-slug}/envvar".replaceAll("\\{project-slug\\}", this.apiClient.escapeString(projectSlug.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<EnvironmentVariablePair> localVarReturnType = new GenericType<EnvironmentVariablePair>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MessageResponse deleteCheckoutKey(String projectSlug, String fingerprint) throws ApiException {
        return this.deleteCheckoutKeyWithHttpInfo(projectSlug, fingerprint).getData();
    }

    public ApiResponse<MessageResponse> deleteCheckoutKeyWithHttpInfo(String projectSlug, String fingerprint) throws ApiException {
        Object localVarPostBody = new Object();
        if (projectSlug == null) {
            throw new ApiException(400, "Missing the required parameter 'projectSlug' when calling deleteCheckoutKey");
        }
        if (fingerprint == null) {
            throw new ApiException(400, "Missing the required parameter 'fingerprint' when calling deleteCheckoutKey");
        }
        String localVarPath = "/project/{project-slug}/checkout-key/{fingerprint}".replaceAll("\\{project-slug\\}", this.apiClient.escapeString(projectSlug.toString())).replaceAll("\\{fingerprint\\}", this.apiClient.escapeString(fingerprint.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<MessageResponse> localVarReturnType = new GenericType<MessageResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MessageResponse deleteEnvVar(String projectSlug, String name) throws ApiException {
        return this.deleteEnvVarWithHttpInfo(projectSlug, name).getData();
    }

    public ApiResponse<MessageResponse> deleteEnvVarWithHttpInfo(String projectSlug, String name) throws ApiException {
        Object localVarPostBody = new Object();
        if (projectSlug == null) {
            throw new ApiException(400, "Missing the required parameter 'projectSlug' when calling deleteEnvVar");
        }
        if (name == null) {
            throw new ApiException(400, "Missing the required parameter 'name' when calling deleteEnvVar");
        }
        String localVarPath = "/project/{project-slug}/envvar/{name}".replaceAll("\\{project-slug\\}", this.apiClient.escapeString(projectSlug.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<MessageResponse> localVarReturnType = new GenericType<MessageResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CheckoutKey getCheckoutKey(String projectSlug, String fingerprint) throws ApiException {
        return this.getCheckoutKeyWithHttpInfo(projectSlug, fingerprint).getData();
    }

    public ApiResponse<CheckoutKey> getCheckoutKeyWithHttpInfo(String projectSlug, String fingerprint) throws ApiException {
        Object localVarPostBody = new Object();
        if (projectSlug == null) {
            throw new ApiException(400, "Missing the required parameter 'projectSlug' when calling getCheckoutKey");
        }
        if (fingerprint == null) {
            throw new ApiException(400, "Missing the required parameter 'fingerprint' when calling getCheckoutKey");
        }
        String localVarPath = "/project/{project-slug}/checkout-key/{fingerprint}".replaceAll("\\{project-slug\\}", this.apiClient.escapeString(projectSlug.toString())).replaceAll("\\{fingerprint\\}", this.apiClient.escapeString(fingerprint.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<CheckoutKey> localVarReturnType = new GenericType<CheckoutKey>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EnvironmentVariablePair getEnvVar(String projectSlug, String name) throws ApiException {
        return this.getEnvVarWithHttpInfo(projectSlug, name).getData();
    }

    public ApiResponse<EnvironmentVariablePair> getEnvVarWithHttpInfo(String projectSlug, String name) throws ApiException {
        Object localVarPostBody = new Object();
        if (projectSlug == null) {
            throw new ApiException(400, "Missing the required parameter 'projectSlug' when calling getEnvVar");
        }
        if (name == null) {
            throw new ApiException(400, "Missing the required parameter 'name' when calling getEnvVar");
        }
        String localVarPath = "/project/{project-slug}/envvar/{name}".replaceAll("\\{project-slug\\}", this.apiClient.escapeString(projectSlug.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<EnvironmentVariablePair> localVarReturnType = new GenericType<EnvironmentVariablePair>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Project getProjectBySlug(String projectSlug) throws ApiException {
        return this.getProjectBySlugWithHttpInfo(projectSlug).getData();
    }

    public ApiResponse<Project> getProjectBySlugWithHttpInfo(String projectSlug) throws ApiException {
        Object localVarPostBody = new Object();
        if (projectSlug == null) {
            throw new ApiException(400, "Missing the required parameter 'projectSlug' when calling getProjectBySlug");
        }
        String localVarPath = "/project/{project-slug}".replaceAll("\\{project-slug\\}", this.apiClient.escapeString(projectSlug.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<Project> localVarReturnType = new GenericType<Project>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CheckoutKeyListResponse listCheckoutKeys(String projectSlug) throws ApiException {
        return this.listCheckoutKeysWithHttpInfo(projectSlug).getData();
    }

    public ApiResponse<CheckoutKeyListResponse> listCheckoutKeysWithHttpInfo(String projectSlug) throws ApiException {
        Object localVarPostBody = new Object();
        if (projectSlug == null) {
            throw new ApiException(400, "Missing the required parameter 'projectSlug' when calling listCheckoutKeys");
        }
        String localVarPath = "/project/{project-slug}/checkout-key".replaceAll("\\{project-slug\\}", this.apiClient.escapeString(projectSlug.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<CheckoutKeyListResponse> localVarReturnType = new GenericType<CheckoutKeyListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EnvironmentVariableListResponse listEnvVars(String projectSlug) throws ApiException {
        return this.listEnvVarsWithHttpInfo(projectSlug).getData();
    }

    public ApiResponse<EnvironmentVariableListResponse> listEnvVarsWithHttpInfo(String projectSlug) throws ApiException {
        Object localVarPostBody = new Object();
        if (projectSlug == null) {
            throw new ApiException(400, "Missing the required parameter 'projectSlug' when calling listEnvVars");
        }
        String localVarPath = "/project/{project-slug}/envvar".replaceAll("\\{project-slug\\}", this.apiClient.escapeString(projectSlug.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"api_key_header", "api_key_query", "basic_auth"};
        GenericType<EnvironmentVariableListResponse> localVarReturnType = new GenericType<EnvironmentVariableListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

