/*
 * Decompiled with CFR 0.152.
 */
package com.cleeng.api;

import com.cleeng.api.BatchAsyncRequest;
import com.cleeng.api.Config;
import com.cleeng.api.domain.BatchRequest;
import com.cleeng.api.domain.async.AsyncRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.nurkiewicz.asyncretry.AsyncRetryExecutor;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asynchttpclient.AsyncCompletionHandler;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Response;

public class HttpClient {
    private static final Logger logger = LogManager.getLogger(HttpClient.class);
    public Config config;

    public synchronized String invokeBatch(BatchRequest request, String platformUrl) throws IOException {
        return this.invoke(platformUrl, request.getRequests());
    }

    /*
     * Loose catch block
     */
    public synchronized String invoke(String endpoint, Object request) throws IOException {
        StandardHttpRequestRetryHandler retryHandler = new StandardHttpRequestRetryHandler(this.config.retryCount, true){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                return executionCount < this.getRetryCount();
            }
        };
        Throwable throwable = null;
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().setRetryHandler((HttpRequestRetryHandler)retryHandler).build();){
            HttpPost post = new HttpPost(endpoint);
            post.setHeader("Content-Type", "application/json");
            Gson gson = new GsonBuilder().create();
            String json = gson.toJson(request);
            post.setEntity((HttpEntity)new StringEntity(json, "UTF-8"));
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.config.socketTimeout).setConnectTimeout(this.config.connectTimeout).build();
            post.setConfig(requestConfig);
            ResponseHandler<String> responseHandler = new ResponseHandler<String>(){

                public String handleResponse(HttpResponse httpResponse) throws IOException {
                    StatusLine statusLine = httpResponse.getStatusLine();
                    HttpEntity entity = httpResponse.getEntity();
                    if (statusLine.getStatusCode() >= 300) {
                        logger.error(" Server returned response code: " + statusLine.getStatusCode() + " reason: " + statusLine.getReasonPhrase());
                        throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
                    }
                    if (entity == null) {
                        throw new ClientProtocolException("Response contains no content");
                    }
                    return EntityUtils.toString((HttpEntity)entity);
                }
            };
            try {
                String string = (String)httpClient.execute((HttpUriRequest)post, (ResponseHandler)responseHandler);
                return string;
            }
            catch (InterruptedIOException exception) {
                String string;
                block17: {
                    block18: {
                        string = null;
                        if (httpClient == null) break block17;
                        if (throwable == null) break block18;
                        try {
                            httpClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block17;
                    }
                    httpClient.close();
                }
                return string;
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
            }
        }
    }

    public synchronized CompletableFuture<Response> invokeAsync(final AsyncRequest request, CountDownLatch latch, AsyncHttpClient httpClient) throws IOException, InterruptedException {
        request.latch = latch;
        request.callback.useNonBlockingMode = this.config.useNonBlockingMode;
        request.callback.setCountdownLatch(latch);
        Gson gson = new GsonBuilder().create();
        String json = gson.toJson((Object)request.data);
        BoundRequestBuilder builder = httpClient.preparePost(request.endpoint);
        builder.addHeader((CharSequence)"Content-Type", "application/json");
        builder.setBody(json);
        request.callback.setClient(httpClient);
        builder.execute((AsyncHandler)new AsyncCompletionHandler<Void>(){

            public Void onCompleted(Response response) throws Exception {
                request.callback.complete(response);
                return null;
            }

            public void onThrowable(Throwable t) {
                request.callback.completeExceptionally(t);
            }
        });
        request.callback.join();
        return request.callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void invokeAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        DefaultAsyncHttpClientConfig.Builder builder = new DefaultAsyncHttpClientConfig.Builder();
        builder.setRequestTimeout(this.config.requestTimeout);
        builder.setConnectTimeout(this.config.connectTimeout);
        DefaultAsyncHttpClient httpClient = new DefaultAsyncHttpClient((AsyncHttpClientConfig)builder.build());
        CountDownLatch latch = new CountDownLatch(requests.size());
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        AsyncRetryExecutor executor = new AsyncRetryExecutor(scheduler).retryOn(new Class[]{Exception.class}).withMaxRetries(this.config.retryCount);
        try {
            for (AsyncRequest request : requests) {
                executor.getWithRetry(() -> this.lambda$invokeAsync$0(request, latch, (AsyncHttpClient)httpClient));
            }
            if (!this.config.useNonBlockingMode) {
                latch.await();
            }
        }
        finally {
            if (!this.config.useNonBlockingMode) {
                httpClient.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void invokeBatchAsync(BatchAsyncRequest callback, String platformUrl) throws IOException, InterruptedException {
        DefaultAsyncHttpClientConfig.Builder builder = new DefaultAsyncHttpClientConfig.Builder();
        builder.setRequestTimeout(this.config.requestTimeout);
        builder.setConnectTimeout(this.config.connectTimeout);
        DefaultAsyncHttpClient httpClient = new DefaultAsyncHttpClient((AsyncHttpClientConfig)builder.build());
        CountDownLatch latch = new CountDownLatch(1);
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        AsyncRetryExecutor executor = new AsyncRetryExecutor(scheduler).retryOn(new Class[]{Exception.class}).withMaxRetries(this.config.retryCount);
        try {
            executor.getWithRetry(() -> this.lambda$invokeBatchAsync$1(callback, latch, (AsyncHttpClient)httpClient, platformUrl));
            if (!this.config.useNonBlockingMode) {
                latch.await();
            }
        }
        finally {
            if (!this.config.useNonBlockingMode) {
                httpClient.close();
            }
        }
    }

    public synchronized CompletableFuture<Response> invokeAsync(final BatchAsyncRequest request, CountDownLatch latch, AsyncHttpClient httpClient, String platformUrl) throws IOException, InterruptedException {
        request.setCountdownLatch(latch);
        request.useNonBlockingMode = this.config.useNonBlockingMode;
        request.setCountdownLatch(latch);
        Gson gson = new GsonBuilder().create();
        String json = gson.toJson(request.getRequests());
        BoundRequestBuilder builder = httpClient.preparePost(platformUrl);
        builder.addHeader((CharSequence)"Content-Type", "application/json");
        builder.setBody(json);
        request.setClient(httpClient);
        builder.execute((AsyncHandler)new AsyncCompletionHandler<Void>(){

            public Void onCompleted(Response response) throws Exception {
                request.complete(response);
                return null;
            }

            public void onThrowable(Throwable t) {
                request.completeExceptionally(t);
            }
        });
        request.join();
        return request;
    }

    private /* synthetic */ CompletableFuture lambda$invokeBatchAsync$1(BatchAsyncRequest callback, CountDownLatch latch, AsyncHttpClient httpClient, String platformUrl) throws Exception {
        return this.invokeAsync(callback, latch, httpClient, platformUrl);
    }

    private /* synthetic */ CompletableFuture lambda$invokeAsync$0(AsyncRequest request, CountDownLatch latch, AsyncHttpClient httpClient) throws Exception {
        return this.invokeAsync(request, latch, httpClient);
    }
}

