/*
 * Decompiled with CFR 0.152.
 */
package com.cleeng.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Response;

public class AsyncRequestCallback<T>
extends CompletableFuture<Response> {
    private static final Logger logger = LogManager.getLogger(AsyncRequestCallback.class);
    protected Gson gson = new GsonBuilder().create();
    private AsyncHttpClient _client;
    private CountDownLatch _countdownLatch;
    protected String _response;
    protected Class<T> _responseClass;
    public boolean useNonBlockingMode = false;

    public AsyncRequestCallback(Class<T> responseClass) {
        this._responseClass = responseClass;
    }

    public void setClient(AsyncHttpClient client) {
        this._client = client;
    }

    public void setCountdownLatch(CountDownLatch latch) {
        this._countdownLatch = latch;
    }

    public CountDownLatch getCountdownLatch() {
        return this._countdownLatch;
    }

    public T getResponse() {
        return (T)this.gson.fromJson(this._response, this._responseClass);
    }

    @Override
    public boolean complete(Response response) {
        boolean out = super.complete(response);
        logger.info("Completed async request: " + response.getStatusCode() + " count: " + this._countdownLatch.getCount() + " response: " + this._responseClass.getCanonicalName());
        try {
            this._response = response.getResponseBody();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.useNonBlockingMode && this._countdownLatch.getCount() == 0L) {
            try {
                logger.info("Closing connection...");
                this._client.close();
            }
            catch (IOException e) {
                logger.error("Failed to close http connection...");
            }
        }
        this._countdownLatch.countDown();
        return out;
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        logger.error("Request completed with exception " + ex);
        return super.completeExceptionally(ex);
    }
}

