/*
 * Decompiled with CFR 0.152.
 */
package com.cleeng.api;

import com.cleeng.api.BatchAsyncRequest;
import com.cleeng.api.Cleeng;
import com.cleeng.api.Config;
import com.cleeng.api.HttpClient;
import com.cleeng.api.ResponseMapper;
import com.cleeng.api.domain.BatchRequest;
import com.cleeng.api.domain.BatchResponse;
import com.cleeng.api.domain.BooleanResponse;
import com.cleeng.api.domain.CreateVodOfferParams;
import com.cleeng.api.domain.Criteria;
import com.cleeng.api.domain.CustomerData;
import com.cleeng.api.domain.EventOfferData;
import com.cleeng.api.domain.EventOfferResponse;
import com.cleeng.api.domain.FlowDescription;
import com.cleeng.api.domain.GenerateCheckoutUrlParams;
import com.cleeng.api.domain.GenerateCheckoutUrlRequest;
import com.cleeng.api.domain.GenerateCustomerTokenFromFacebookParams;
import com.cleeng.api.domain.GenerateCustomerTokenFromPasswordParams;
import com.cleeng.api.domain.GenerateCustomerTokenParams;
import com.cleeng.api.domain.GenerateMyAccountUrlParams;
import com.cleeng.api.domain.GetAccessStatusForDeviceParams;
import com.cleeng.api.domain.GetAccessStatusForDeviceResponse;
import com.cleeng.api.domain.GetAccessStatusParams;
import com.cleeng.api.domain.GetAccessStatusRequest;
import com.cleeng.api.domain.GetAccessStatusResponse;
import com.cleeng.api.domain.GetAccessibleTagsParams;
import com.cleeng.api.domain.GetAccessibleTagsRequest;
import com.cleeng.api.domain.GetAccessibleTagsResponse;
import com.cleeng.api.domain.GetCustomerParams;
import com.cleeng.api.domain.GetCustomerRequest;
import com.cleeng.api.domain.GetCustomerResponse;
import com.cleeng.api.domain.GetVodOfferParams;
import com.cleeng.api.domain.GetVodOfferRequest;
import com.cleeng.api.domain.ListOfferIdsByVideoIdResponse;
import com.cleeng.api.domain.ListParams;
import com.cleeng.api.domain.ListPassOffersResponse;
import com.cleeng.api.domain.ListRequest;
import com.cleeng.api.domain.ListSingleOffersResponse;
import com.cleeng.api.domain.ListSubscriptionOffersResponse;
import com.cleeng.api.domain.ListVodOffersResponse;
import com.cleeng.api.domain.OfferParams;
import com.cleeng.api.domain.OfferRequest;
import com.cleeng.api.domain.OfferResponse;
import com.cleeng.api.domain.PassOfferData;
import com.cleeng.api.domain.PassOfferResponse;
import com.cleeng.api.domain.PrepareRemoteAuthParams;
import com.cleeng.api.domain.PrepareRemoteAuthRequest;
import com.cleeng.api.domain.PrepareRemoteAuthResponse;
import com.cleeng.api.domain.RegisterCustomerParams;
import com.cleeng.api.domain.RentalOfferData;
import com.cleeng.api.domain.RentalOfferParams;
import com.cleeng.api.domain.RentalOfferRequest;
import com.cleeng.api.domain.RentalOfferResponse;
import com.cleeng.api.domain.ResetPasswordParams;
import com.cleeng.api.domain.SingleOfferData;
import com.cleeng.api.domain.SingleOfferResponse;
import com.cleeng.api.domain.SubscriptionOfferData;
import com.cleeng.api.domain.TokenResponse;
import com.cleeng.api.domain.UpdateOfferParams;
import com.cleeng.api.domain.UpdateVodOfferParams;
import com.cleeng.api.domain.UrlResponse;
import com.cleeng.api.domain.VideoIdParams;
import com.cleeng.api.domain.VodOfferData;
import com.cleeng.api.domain.VodOfferRequest;
import com.cleeng.api.domain.VodOfferResponse;
import com.cleeng.api.domain.async.AsyncCreateVodOfferRequest;
import com.cleeng.api.domain.async.AsyncGenerateCheckoutUrlRequest;
import com.cleeng.api.domain.async.AsyncGenerateCustomerTokenFromPasswordRequest;
import com.cleeng.api.domain.async.AsyncGetAccessStatusRequest;
import com.cleeng.api.domain.async.AsyncGetAccessibleTagsRequest;
import com.cleeng.api.domain.async.AsyncGetVodOfferRequest;
import com.cleeng.api.domain.async.AsyncListRequest;
import com.cleeng.api.domain.async.AsyncPrepareRemoteAuthRequest;
import com.cleeng.api.domain.async.AsyncRequest;
import com.cleeng.api.domain.async.AsyncTokenRequest;
import com.cleeng.api.domain.async.AsyncUpdateOfferRequest;
import com.cleeng.api.domain.async.AsyncUpdateVodOfferRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jsonrpc.JSONRPCRequest;

public class CleengImpl
implements Cleeng {
    private static final Logger logger = LogManager.getLogger(CleengImpl.class);
    private String publisherToken;
    private String platformUrl;
    private Gson gson;
    private HttpClient client;
    private Config config = new Config();

    public CleengImpl(String platformUrl, String platformUrlSandbox, boolean useSandbox, String publisherToken, String propertiesPath, int socketTimeout, int connectTimeout, int requestTimeout, int retryCount, int useNonBlockingMode) {
        if (propertiesPath != null) {
            this.initProps(propertiesPath);
        }
        if (socketTimeout > 0) {
            this.config.socketTimeout = socketTimeout;
        }
        if (connectTimeout > 0) {
            this.config.connectTimeout = connectTimeout;
        }
        if (requestTimeout > 0) {
            this.config.requestTimeout = requestTimeout;
        }
        if (retryCount > 0) {
            this.config.retryCount = retryCount;
        }
        if (platformUrl != null) {
            this.config.platformUrl = platformUrl;
        }
        if (platformUrlSandbox != null) {
            this.config.platformUrlSandbox = platformUrlSandbox;
        }
        this.config.useSandbox = useSandbox;
        if (useNonBlockingMode != -1) {
            if (useNonBlockingMode == 1) {
                this.config.useNonBlockingMode = true;
            } else if (useNonBlockingMode == 0) {
                this.config.useNonBlockingMode = false;
            }
        }
        this.gson = new GsonBuilder().create();
        this.client = new HttpClient();
        this.client.config = this.config;
        this.platformUrl = useSandbox ? this.config.platformUrlSandbox : this.config.platformUrl;
        this.publisherToken = publisherToken;
    }

    @Override
    public HttpClient getClient() {
        return this.client;
    }

    @Override
    public OfferResponse createSubscriptionOffer(SubscriptionOfferData offerData) throws IOException {
        String response = this.client.invoke(this.platformUrl, new OfferRequest("createSubscriptionOffer", OfferParams.create(this.publisherToken, offerData)));
        return (OfferResponse)this.gson.fromJson(response, OfferResponse.class);
    }

    @Override
    public void createSubscriptionOfferAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new OfferRequest("createSubscriptionOffer", OfferParams.create(this.publisherToken, (SubscriptionOfferData)request.input));
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public OfferResponse updateSubscriptionOffer(SubscriptionOfferData offerData, String offerId) throws IOException {
        String response = this.client.invoke(this.platformUrl, new OfferRequest("updateSubscriptionOffer", new UpdateOfferParams(this.publisherToken, offerData, offerId)));
        return (OfferResponse)this.gson.fromJson(response, OfferResponse.class);
    }

    @Override
    public void updateSubscriptionOfferAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new OfferRequest("updateSubscriptionOffer", new UpdateOfferParams(this.publisherToken, ((AsyncUpdateOfferRequest)request).offerData, ((AsyncUpdateOfferRequest)request).offerId));
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public SingleOfferResponse createSingleOffer(SingleOfferData offerData) throws IOException {
        String response = this.client.invoke(this.platformUrl, new OfferRequest("createSingleOffer", OfferParams.create(this.publisherToken, offerData)));
        return (SingleOfferResponse)this.gson.fromJson(response, SingleOfferResponse.class);
    }

    @Override
    public void createSingleOfferAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new OfferRequest("createSingleOffer", OfferParams.create(this.publisherToken, (SingleOfferData)request.input));
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public SingleOfferResponse updateSingleOffer(String offerId, SingleOfferData offerData) throws IOException {
        String response = this.client.invoke(this.platformUrl, new OfferRequest("updateSingleOffer", new UpdateOfferParams(this.publisherToken, offerData, offerId)));
        return (SingleOfferResponse)this.gson.fromJson(response, SingleOfferResponse.class);
    }

    @Override
    public void updateSingleOfferAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new OfferRequest("updateSingleOffer", new UpdateOfferParams(this.publisherToken, ((AsyncUpdateOfferRequest)request).offerData, ((AsyncUpdateOfferRequest)request).offerId));
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public EventOfferResponse createEventOffer(EventOfferData offerData) throws IOException {
        String response = this.client.invoke(this.platformUrl, new OfferRequest("createEventOffer", OfferParams.create(this.publisherToken, offerData)));
        return (EventOfferResponse)this.gson.fromJson(response, EventOfferResponse.class);
    }

    @Override
    public void createEventOfferAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new OfferRequest("createEventOffer", OfferParams.create(this.publisherToken, (EventOfferData)request.input));
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public EventOfferResponse updateEventOffer(EventOfferData offerData, String offerId) throws IOException {
        String response = this.client.invoke(this.platformUrl, new OfferRequest("updateEventOffer", new UpdateOfferParams(this.publisherToken, offerData, offerId)));
        return (EventOfferResponse)this.gson.fromJson(response, EventOfferResponse.class);
    }

    @Override
    public void updateEventOfferAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new OfferRequest("updateEventOffer", new UpdateOfferParams(this.publisherToken, ((AsyncUpdateOfferRequest)request).offerData, ((AsyncUpdateOfferRequest)request).offerId));
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public RentalOfferResponse createRentalOffer(RentalOfferData offerData) throws IOException {
        String response = this.client.invoke(this.platformUrl, new RentalOfferRequest("createRentalOffer", RentalOfferParams.create(this.publisherToken, offerData)));
        return (RentalOfferResponse)this.gson.fromJson(response, RentalOfferResponse.class);
    }

    @Override
    public void createRentalOfferAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new RentalOfferRequest("createRentalOffer", RentalOfferParams.create(this.publisherToken, (RentalOfferData)request.input));
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public RentalOfferResponse updateRentalOffer(RentalOfferData offerData, String offerId) throws IOException {
        String response = this.client.invoke(this.platformUrl, new OfferRequest("updateRentalOffer", new UpdateOfferParams(this.publisherToken, offerData, offerId)));
        return (RentalOfferResponse)this.gson.fromJson(response, RentalOfferResponse.class);
    }

    @Override
    public void updateRentalOfferAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new OfferRequest("updateRentalOffer", new UpdateOfferParams(this.publisherToken, ((AsyncUpdateOfferRequest)request).offerData, ((AsyncUpdateOfferRequest)request).offerId));
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public PassOfferResponse createPassOffer(PassOfferData offerData) throws IOException {
        String response = this.client.invoke(this.platformUrl, new OfferRequest("createPassOffer", OfferParams.create(this.publisherToken, offerData)));
        return (PassOfferResponse)this.gson.fromJson(response, PassOfferResponse.class);
    }

    @Override
    public void createPassOfferAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new OfferRequest("createPassOffer", OfferParams.create(this.publisherToken, (PassOfferData)request.input));
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public OfferResponse updatePassOffer(PassOfferData offerData, String offerId) throws IOException {
        String response = this.client.invoke(this.platformUrl, new OfferRequest("updatePassOffer", new UpdateOfferParams(this.publisherToken, offerData, offerId)));
        return (OfferResponse)this.gson.fromJson(response, OfferResponse.class);
    }

    @Override
    public void updatePassOfferAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new OfferRequest("updatePassOffer", new UpdateOfferParams(this.publisherToken, ((AsyncUpdateOfferRequest)request).offerData, ((AsyncUpdateOfferRequest)request).offerId));
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public ListSubscriptionOffersResponse listSubscriptionOffers(Criteria criteria, int offset, int limit) throws IOException {
        String response = this.client.invoke(this.platformUrl, new ListRequest("listSubscriptionOffers", ListParams.create(this.publisherToken, criteria, offset, limit)));
        return (ListSubscriptionOffersResponse)this.gson.fromJson(response, ListSubscriptionOffersResponse.class);
    }

    @Override
    public void listSubscriptionOffersAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new ListRequest("listSubscriptionOffers", ListParams.create(this.publisherToken, (Criteria)((AsyncListRequest)request).input, ((AsyncListRequest)request).offset, ((AsyncListRequest)request).limit));
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public ListSingleOffersResponse listSingleOffers(Criteria criteria, int offset, int limit) throws IOException {
        String response = this.client.invoke(this.platformUrl, new ListRequest("listSingleOffers", ListParams.create(this.publisherToken, criteria, offset, limit)));
        return (ListSingleOffersResponse)this.gson.fromJson(response, ListSingleOffersResponse.class);
    }

    @Override
    public void listSingleOffersAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new ListRequest("listVodOffers", ListParams.create(this.publisherToken, (Criteria)((AsyncListRequest)request).input, ((AsyncListRequest)request).offset, ((AsyncListRequest)request).limit));
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public ListVodOffersResponse listVodOffers(Criteria criteria, int offset, int limit) throws IOException {
        String response = this.client.invoke(this.platformUrl, new ListRequest("listVodOffers", ListParams.create(this.publisherToken, criteria, offset, limit)));
        return (ListVodOffersResponse)this.gson.fromJson(response, ListVodOffersResponse.class);
    }

    @Override
    public void listVodOffersAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new ListRequest("listVodOffers", ListParams.create(this.publisherToken, (Criteria)((AsyncListRequest)request).input, ((AsyncListRequest)request).offset, ((AsyncListRequest)request).limit));
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public ListPassOffersResponse listPassOffers(Criteria criteria, int offset, int limit) throws IOException {
        String response = this.client.invoke(this.platformUrl, new ListRequest("listPassOffers", ListParams.create(this.publisherToken, criteria, offset, limit)));
        return (ListPassOffersResponse)this.gson.fromJson(response, ListPassOffersResponse.class);
    }

    @Override
    public void listPassOffersAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new ListRequest("listPassOffers", ListParams.create(this.publisherToken, (Criteria)((AsyncListRequest)request).input, ((AsyncListRequest)request).offset, ((AsyncListRequest)request).limit));
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public PrepareRemoteAuthResponse prepareRemoteAuth(CustomerData customerData, FlowDescription flowDescription) throws IOException {
        String response = this.client.invoke(this.platformUrl, new PrepareRemoteAuthRequest("prepareRemoteAuth", PrepareRemoteAuthParams.create(this.publisherToken, customerData, flowDescription)));
        return (PrepareRemoteAuthResponse)this.gson.fromJson(response, PrepareRemoteAuthResponse.class);
    }

    @Override
    public void prepareRemoteAuthAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new PrepareRemoteAuthRequest("prepareRemoteAuth", PrepareRemoteAuthParams.create(this.publisherToken, ((AsyncPrepareRemoteAuthRequest)request).customerData, ((AsyncPrepareRemoteAuthRequest)request).flowDescription));
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public TokenResponse generateCustomerToken(String customerEmail) throws IOException {
        String response = this.client.invoke(this.platformUrl, new JSONRPCRequest("generateCustomerToken", GenerateCustomerTokenParams.create(this.publisherToken, customerEmail)));
        return (TokenResponse)this.gson.fromJson(response, TokenResponse.class);
    }

    @Override
    public void generateCustomerTokenAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new JSONRPCRequest("generateCustomerToken", GenerateCustomerTokenParams.create(this.publisherToken, ((AsyncTokenRequest)request).input));
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public BooleanResponse requestPasswordReset(String customerEmail) throws IOException {
        String response = this.client.invoke(this.platformUrl, new JSONRPCRequest("requestPasswordReset", GenerateCustomerTokenParams.create(this.publisherToken, customerEmail)));
        return (BooleanResponse)this.gson.fromJson(response, BooleanResponse.class);
    }

    @Override
    public void requestPasswordResetAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new JSONRPCRequest("requestPasswordReset", GenerateCustomerTokenParams.create(this.publisherToken, ((AsyncTokenRequest)request).input));
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public BooleanResponse updateCustomerPassword(String customerEmail, String resetPasswordToken, String newPassword) throws IOException {
        String response = this.client.invoke(this.platformUrl, new JSONRPCRequest("updateCustomerPassword", new ResetPasswordParams(this.publisherToken, customerEmail, resetPasswordToken, newPassword)));
        return (BooleanResponse)this.gson.fromJson(response, BooleanResponse.class);
    }

    @Override
    public void updateCustomerPasswordAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new JSONRPCRequest("updateCustomerPassword", new ResetPasswordParams(this.publisherToken, ((ResetPasswordParams)request.input).customerEmail, ((ResetPasswordParams)request.input).resetPasswordToken, ((ResetPasswordParams)request.input).newPassword));
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public TokenResponse generateCustomerTokenFromFacebook(String facebookId) throws IOException {
        String response = this.client.invoke(this.platformUrl, new JSONRPCRequest("generateCustomerTokenFromFacebook", GenerateCustomerTokenFromFacebookParams.create(this.publisherToken, facebookId)));
        return (TokenResponse)this.gson.fromJson(response, TokenResponse.class);
    }

    @Override
    public void generateCustomerTokenFromFacebookAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new JSONRPCRequest("generateCustomerTokenFromFacebook", GenerateCustomerTokenFromFacebookParams.create(this.publisherToken, ((AsyncTokenRequest)request).input));
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public TokenResponse generateCustomerTokenFromPassword(String password, String customerEmail) throws IOException {
        String response = this.client.invoke(this.platformUrl, new JSONRPCRequest("generateCustomerTokenFromPassword", GenerateCustomerTokenFromPasswordParams.create(this.publisherToken, password, customerEmail)));
        return (TokenResponse)this.gson.fromJson(response, TokenResponse.class);
    }

    @Override
    public void generateCustomerTokenFromPasswordAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new JSONRPCRequest("generateCustomerTokenFromPassword", GenerateCustomerTokenFromPasswordParams.create(this.publisherToken, ((AsyncGenerateCustomerTokenFromPasswordRequest)request).password, ((AsyncGenerateCustomerTokenFromPasswordRequest)request).customerEmail));
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public GetAccessStatusResponse getAccessStatus(String customerToken, String offerId, String ipAddress) throws IOException {
        String response = this.client.invoke(this.platformUrl, new GetAccessStatusRequest("getAccessStatus", new GetAccessStatusParams(customerToken, offerId, ipAddress)));
        return (GetAccessStatusResponse)this.gson.fromJson(response, GetAccessStatusResponse.class);
    }

    @Override
    public void getAccessStatusAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new GetAccessStatusRequest("getAccessStatus", new GetAccessStatusParams(((AsyncGetAccessStatusRequest)request).customerToken, ((AsyncGetAccessStatusRequest)request).offerId, ((AsyncGetAccessStatusRequest)request).ipAddress));
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public GetAccessibleTagsResponse getAccessibleTags(String publisherToken, String customerToken) throws IOException {
        String response = this.client.invoke(this.platformUrl, new GetAccessibleTagsRequest("getAccessibleTags", new GetAccessibleTagsParams(publisherToken, customerToken)));
        return (GetAccessibleTagsResponse)this.gson.fromJson(response, GetAccessibleTagsResponse.class);
    }

    @Override
    public void getAccessibleTagsAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new GetAccessibleTagsRequest("getAccessibleTags", new GetAccessibleTagsParams(((AsyncGetAccessibleTagsRequest)request).publisherToken, ((AsyncGetAccessibleTagsRequest)request).customerToken));
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public GetCustomerResponse getCustomer(String customerToken) throws IOException {
        String response = this.client.invoke(this.platformUrl, new GetCustomerRequest("getCustomer", new GetCustomerParams(customerToken)));
        return (GetCustomerResponse)this.gson.fromJson(response, GetCustomerResponse.class);
    }

    @Override
    public void getCustomerAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new GetCustomerRequest("getCustomer", new GetCustomerParams((String)((Object)request.input)));
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public VodOfferResponse createVodOffer(VodOfferData offerData) throws IOException {
        String response = this.client.invoke(this.platformUrl, new VodOfferRequest("createVodOffer", new CreateVodOfferParams(this.publisherToken, offerData)));
        return (VodOfferResponse)this.gson.fromJson(response, VodOfferResponse.class);
    }

    @Override
    public void createVodOfferAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new VodOfferRequest("createVodOffer", new CreateVodOfferParams(((AsyncCreateVodOfferRequest)request).publisherToken, ((AsyncCreateVodOfferRequest)request).offerData));
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public VodOfferResponse getVodOffer(String offerId) throws IOException {
        String response = this.client.invoke(this.platformUrl, new GetVodOfferRequest("getVodOffer", new GetVodOfferParams(this.publisherToken, offerId)));
        return (VodOfferResponse)this.gson.fromJson(response, VodOfferResponse.class);
    }

    @Override
    public void getVodOfferAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new GetVodOfferRequest("getVodOffer", new GetVodOfferParams(((AsyncGetVodOfferRequest)request).publisherToken, ((AsyncGetVodOfferRequest)request).offerId));
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public VodOfferResponse updateVodOffer(String offerId, VodOfferData offerData) throws IOException {
        String response = this.client.invoke(this.platformUrl, new VodOfferRequest("updateVodOffer", new UpdateVodOfferParams(this.publisherToken, offerData, offerId)));
        return (VodOfferResponse)this.gson.fromJson(response, VodOfferResponse.class);
    }

    @Override
    public void updateVodOfferAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new VodOfferRequest("updateVodOffer", new UpdateVodOfferParams(((AsyncUpdateVodOfferRequest)request).publisherToken, ((AsyncUpdateVodOfferRequest)request).offerData, ((AsyncUpdateVodOfferRequest)request).offerIdString));
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public UrlResponse generateCheckoutUrl(String customerEmail, FlowDescription flowDescription) throws IOException {
        String response = this.client.invoke(this.platformUrl, new GenerateCheckoutUrlRequest("generateCheckoutUrl", new GenerateCheckoutUrlParams(this.publisherToken, customerEmail, flowDescription)));
        return (UrlResponse)this.gson.fromJson(response, UrlResponse.class);
    }

    @Override
    public void generateCheckoutUrlAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new GenerateCheckoutUrlRequest("generateCheckoutUrl", new GenerateCheckoutUrlParams(((AsyncGenerateCheckoutUrlRequest)request).publisherToken, ((AsyncGenerateCheckoutUrlRequest)request).customerEmail, ((AsyncGenerateCheckoutUrlRequest)request).flowDescription));
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public TokenResponse registerCustomer(CustomerData data) throws IOException {
        String response = this.client.invoke(this.platformUrl, new JSONRPCRequest("registerCustomer", new RegisterCustomerParams(this.publisherToken, data)));
        return (TokenResponse)this.gson.fromJson(response, TokenResponse.class);
    }

    @Override
    public void registerCustomerAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new JSONRPCRequest("registerCustomer", new RegisterCustomerParams(this.publisherToken, (CustomerData)request.input));
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public UrlResponse generateMyAccountUrl(String customerEmail, List<String> modules) throws IOException {
        String response = this.client.invoke(this.platformUrl, new JSONRPCRequest("generateMyAccountUrl", new GenerateMyAccountUrlParams(this.publisherToken, customerEmail, modules)));
        return (UrlResponse)this.gson.fromJson(response, UrlResponse.class);
    }

    @Override
    public void generateMyAccountUrlAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new JSONRPCRequest("generateMyAccountUrl", new GenerateMyAccountUrlParams(this.publisherToken, ((GenerateMyAccountUrlParams)request.input).customerEmail, ((GenerateMyAccountUrlParams)request.input).modules));
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public ListOfferIdsByVideoIdResponse listOfferIdsByVideoId(String videoId) throws IOException {
        String response = this.client.invoke(this.platformUrl, new JSONRPCRequest("listOfferIdsByVideoId", new VideoIdParams(this.publisherToken, videoId)));
        return (ListOfferIdsByVideoIdResponse)this.gson.fromJson(response, ListOfferIdsByVideoIdResponse.class);
    }

    @Override
    public void listOfferIdsByVideoIdAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new JSONRPCRequest("listOfferIdsByVideoId", new VideoIdParams(this.publisherToken, ((VideoIdParams)request.input).videoId));
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public GetAccessStatusForDeviceResponse getAccessStatusForDevice(String customerToken, String offerId, String deviceId, String deviceType) throws IOException {
        String response = this.client.invoke(this.platformUrl, new JSONRPCRequest("getAccessStatusForDevice", new GetAccessStatusForDeviceParams(customerToken, offerId, deviceId, deviceType)));
        return (GetAccessStatusForDeviceResponse)this.gson.fromJson(response, GetAccessStatusForDeviceResponse.class);
    }

    @Override
    public void getAccessStatusForDeviceAsync(List<AsyncRequest> requests) throws IOException, InterruptedException {
        for (AsyncRequest request : requests) {
            request.endpoint = this.platformUrl;
            request.data = new JSONRPCRequest("getAccessStatusForDevice", request.input);
        }
        this.client.invokeAsync(requests);
    }

    @Override
    public void invokeBatchAsync(BatchAsyncRequest batch) throws IOException, InterruptedException {
        this.client.invokeBatchAsync(batch, this.platformUrl);
    }

    @Override
    public BatchResponse invokeBatch(BatchRequest batch) throws IOException {
        ResponseMapper mapper = new ResponseMapper();
        String response = this.client.invokeBatch(batch, this.platformUrl);
        BatchResponse batchResponse = new BatchResponse();
        JsonParser parser = new JsonParser();
        JsonArray o = parser.parse(response).getAsJsonArray();
        for (int i = 0; i < o.size(); ++i) {
            JsonElement element = o.get(i);
            for (int j = 0; j < batch.getRequests().size(); ++j) {
                JsonObject res;
                JSONRPCRequest r = (JSONRPCRequest)batch.getRequests().get(j);
                if (!element.isJsonObject() || !(res = element.getAsJsonObject()).get("id").getAsString().equals(r.id)) continue;
                String responseTypeName = mapper.map(r.method);
                if (responseTypeName != null) {
                    try {
                        logger.info("Processing " + responseTypeName);
                        Serializable payload = (Serializable)this.gson.fromJson((JsonElement)res, Class.forName(responseTypeName));
                        batchResponse.responses.add(payload);
                    }
                    catch (ClassNotFoundException e) {
                        logger.error("Class not found " + e);
                    }
                    continue;
                }
                logger.warn("Mapper did not contain a response type for " + r.getClass().getTypeName());
            }
        }
        return batchResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initProps(String propertiesPath) {
        Properties properties = new Properties();
        FileInputStream input = null;
        try {
            input = new FileInputStream(propertiesPath);
            properties.load(input);
            try {
                this.config.socketTimeout = Integer.parseInt(properties.getProperty("socketTimeout"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.config.connectTimeout = Integer.parseInt(properties.getProperty("connectTimeout"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.config.requestTimeout = Integer.parseInt(properties.getProperty("requestTimeout"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.config.retryCount = Integer.parseInt(properties.getProperty("retryCount"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.config.useNonBlockingMode = Boolean.parseBoolean(properties.getProperty("useNonBlockingMode"));
            this.config.platformUrl = properties.getProperty("platformUrl");
            this.config.platformUrlSandbox = properties.getProperty("platformUrlSandbox");
        }
        catch (IOException e) {
            logger.error("Config file not found or invalid.");
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

