/*
 * Decompiled with CFR 0.152.
 */
package com.cml.idex.packets;

import com.cml.idex.ErrorCode;
import com.cml.idex.IDexException;
import com.cml.idex.packets.Parser;
import com.cml.idex.packets.Req;
import com.cml.idex.util.Utils;
import com.cml.idex.value.Trade;
import com.cml.idex.value.TradeReq;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class PlaceTrade
implements Req,
Parser<List<Trade>> {
    final List<TradeReq> trades;

    private PlaceTrade(List<TradeReq> trades) {
        this.trades = trades;
    }

    @Override
    public String getEndpoint() {
        return "trade";
    }

    @Override
    public String getPayload() {
        String tradesJson = this.trades.stream().map(trade -> "{\"address\": \"" + trade.getAddress() + "\", \"amount\": \"" + trade.getAmount() + "\", \"orderHash\": \"" + trade.getOrderHash() + "\", \"nonce\": \"" + trade.getNonce() + ", \"v\": " + trade.getV() + ", \"r\": \"" + new String(trade.getR(), StandardCharsets.UTF_8) + "\", \"s\": \"" + new String(trade.getS(), StandardCharsets.UTF_8) + "}").collect(Collectors.joining(","));
        return "{[" + tradesJson + "]}";
    }

    @Override
    public List<Trade> parse(ObjectMapper mapper, String json) {
        if (Utils.isEmptyJson(json)) {
            throw new IDexException(ErrorCode.TRADE_FAILED, json);
        }
        return PlaceTrade.fromJson(mapper, json);
    }

    public static PlaceTrade create(List<TradeReq> trades) {
        return new PlaceTrade(trades);
    }

    private static List<Trade> fromJson(ObjectMapper mapper, String body) {
        try {
            JsonNode root = mapper.readTree(body);
            Utils.checkError(root);
            if (root.isArray()) {
                LinkedList<Trade> trades = new LinkedList<Trade>();
                Iterator elementsItr = root.elements();
                while (elementsItr.hasNext()) {
                    trades.add(PlaceTrade.parseTrade((JsonNode)elementsItr.next()));
                }
                return trades;
            }
            if (root.get("amount") == null) {
                throw new IDexException(ErrorCode.TRADE_FAILED, body);
            }
            return Collections.singletonList(PlaceTrade.parseTrade(root));
        }
        catch (Exception e1) {
            throw new IDexException(ErrorCode.RESPONSE_PARSE_FAILED, e1.getLocalizedMessage(), e1);
        }
    }

    public static Trade parseTrade(JsonNode node) {
        if (node == null) {
            return null;
        }
        BigDecimal amount = Utils.toBDrequired(node, "amount");
        LocalDateTime date = Utils.parseDate(node, "date");
        BigDecimal total = Utils.toBDrequired(node, "total");
        String market = node.get("market").asText();
        String type = node.get("type").asText();
        BigDecimal price = Utils.toBDrequired(node, "price");
        String orderHash = node.get("orderHash").asText();
        String uuid = node.get("uuid").asText();
        return new Trade(amount, date, total, market, type, price, orderHash, uuid);
    }
}

