/*
 * Decompiled with CFR 0.152.
 */
package com.cml.idex.packets;

import com.cml.idex.ErrorCode;
import com.cml.idex.IDexException;
import com.cml.idex.packets.Parser;
import com.cml.idex.packets.Req;
import com.cml.idex.util.Utils;
import com.cml.idex.value.Volume;
import com.cml.idex.value.VolumePair;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Return24Volume
implements Req,
Parser<Volume> {
    public static Return24Volume INSTANCE = new Return24Volume();

    private Return24Volume() {
    }

    @Override
    public String getEndpoint() {
        return "return24Volume";
    }

    @Override
    public String getPayload() {
        return "";
    }

    public static Return24Volume create() {
        return INSTANCE;
    }

    @Override
    public Volume parse(ObjectMapper mapper, String body) {
        return Return24Volume.fromJson(mapper, body);
    }

    public static Volume fromJson(ObjectMapper mapper, String body) {
        try {
            JsonNode root = mapper.readTree(body);
            Utils.checkError(root);
            HashMap<String, VolumePair> volumePairs = new HashMap<String, VolumePair>();
            HashMap<String, BigDecimal> totalVolumes = new HashMap<String, BigDecimal>();
            Iterator fieldItr = root.fields();
            while (fieldItr.hasNext()) {
                Map.Entry node = (Map.Entry)fieldItr.next();
                if (((JsonNode)node.getValue()).getNodeType() == JsonNodeType.STRING) {
                    totalVolumes.put((String)node.getKey(), Utils.toBD(((JsonNode)node.getValue()).asText()));
                    continue;
                }
                Iterator pairItr = ((JsonNode)node.getValue()).fields();
                Map.Entry entry1 = (Map.Entry)pairItr.next();
                Map.Entry entry2 = (Map.Entry)pairItr.next();
                if (pairItr.hasNext()) {
                    throw new IllegalStateException("Should only have two pairs! " + (String)node.getKey() + " : " + node.getValue());
                }
                volumePairs.put((String)node.getKey(), new VolumePair((String)entry1.getKey(), Utils.toBD(((JsonNode)entry1.getValue()).asText()), (String)entry2.getKey(), Utils.toBD(((JsonNode)entry2.getValue()).asText())));
            }
            return new Volume(volumePairs, totalVolumes);
        }
        catch (IDexException e2) {
            throw e2;
        }
        catch (Exception e1) {
            throw new IDexException(ErrorCode.RESPONSE_PARSE_FAILED, e1.getLocalizedMessage(), e1);
        }
    }
}

