/*
 * Decompiled with CFR 0.152.
 */
package com.cml.idex.packets;

import com.cml.idex.ErrorCode;
import com.cml.idex.IDexException;
import com.cml.idex.packets.Parser;
import com.cml.idex.packets.Req;
import com.cml.idex.util.Utils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

public class ReturnNextNonce
implements Req,
Parser<Long> {
    private final String address;

    private ReturnNextNonce(String address) {
        this.address = address;
    }

    @Override
    public String getEndpoint() {
        return "returnNextNonce";
    }

    @Override
    public String getPayload() {
        return "{\"address\": \"" + this.address + "\"}";
    }

    @Override
    public Long parse(ObjectMapper mapper, String json) {
        if (Utils.isEmptyJson(json)) {
            throw new IDexException(ErrorCode.UNKNOWN_ADDRESS, this.address);
        }
        return ReturnNextNonce.fromJson(mapper, json);
    }

    public static ReturnNextNonce create(String address) {
        String fixedAdr = Utils.fixString(address);
        if (fixedAdr == null) {
            throw new IllegalArgumentException("address is required!");
        }
        return new ReturnNextNonce(address);
    }

    private static long fromJson(ObjectMapper mapper, String json) {
        try {
            JsonNode root = mapper.readTree(json);
            Utils.checkError(root);
            return root.get("nonce").asLong();
        }
        catch (Exception e1) {
            throw new IDexException(ErrorCode.RESPONSE_PARSE_FAILED, e1.getLocalizedMessage(), e1);
        }
    }
}

