/*
 * Decompiled with CFR 0.152.
 */
package com.cml.idex.sig;

import com.cml.idex.sig.SigParms;
import com.cml.idex.util.IdexCrypto;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import org.web3j.utils.Numeric;

public class WithdrawSigParms
implements SigParms {
    final String contractAddress;
    final String token;
    final BigInteger amount;
    final String address;
    final long nonce;

    public WithdrawSigParms(String contractAddress, String token, BigInteger amount, String address, long nonce) {
        this.contractAddress = contractAddress;
        this.token = token;
        this.amount = amount;
        this.address = address;
        this.nonce = nonce;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public String getToken() {
        return this.token;
    }

    public BigInteger getAmount() {
        return this.amount;
    }

    public String getAddress() {
        return this.address;
    }

    public long getNonce() {
        return this.nonce;
    }

    @Override
    public byte[] encode() throws IOException {
        ByteArrayOutputStream ba = new ByteArrayOutputStream(160);
        ba.write(Numeric.hexStringToByteArray((String)this.contractAddress));
        ba.write(Numeric.hexStringToByteArray((String)this.token));
        ba.write(IdexCrypto.encodeNumeric(this.amount));
        ba.write(Numeric.hexStringToByteArray((String)this.address));
        ba.write(IdexCrypto.encodeNumeric(this.nonce));
        return ba.toByteArray();
    }
}

