/*
 * Decompiled with CFR 0.152.
 */
package com.cml.idex.util;

import com.cml.idex.sig.SigParms;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Hash;
import org.web3j.crypto.Sign;

public class IdexCrypto {
    private static final byte[] SALT = "\u0019Ethereum Signed Message:\n32".getBytes(StandardCharsets.UTF_8);
    static int MAX_BIT_LENGTH = 256;
    static int MAX_BYTE_LENGTH = MAX_BIT_LENGTH / 8;

    public static Sign.SignatureData createParamsSig(SigParms params, Credentials credentials) throws IOException {
        return Sign.signMessage((byte[])IdexCrypto.createIdxParamsToSign(params), (ECKeyPair)credentials.getEcKeyPair());
    }

    public static byte[] createIdxParamsToSign(SigParms params) throws IOException {
        byte[] msgArgsSha3 = Hash.sha3((byte[])params.encode());
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        ba.write(SALT);
        ba.write(msgArgsSha3);
        return ba.toByteArray();
    }

    public static byte[] encodeNumeric(long val) {
        return IdexCrypto.encodeNumeric(BigInteger.valueOf(val));
    }

    public static byte[] encodeNumeric(BigInteger val) {
        byte[] rawValue = val.toByteArray();
        byte paddingValue = IdexCrypto.getPaddingValue(val);
        byte[] paddedRawValue = new byte[MAX_BYTE_LENGTH];
        if (paddingValue != 0) {
            for (int i = 0; i < paddedRawValue.length; ++i) {
                paddedRawValue[i] = paddingValue;
            }
        }
        System.arraycopy(rawValue, 0, paddedRawValue, MAX_BYTE_LENGTH - rawValue.length, rawValue.length);
        return paddedRawValue;
    }

    private static byte getPaddingValue(BigInteger val) {
        if (val.signum() == -1) {
            return -1;
        }
        return 0;
    }
}

