/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeMap;

public class TreeSet<E>
extends AbstractSet<E>
implements NavigableSet<E> {
    private transient NavigableMap<E, Object> backingMap;
    private transient NavigableSet<E> descendingSet;

    TreeSet(NavigableMap<E, Object> map) {
        this.backingMap = map;
    }

    public TreeSet() {
        this.backingMap = new TreeMap<E, Object>();
    }

    public TreeSet(Collection<? extends E> collection) {
        this();
        this.addAll(collection);
    }

    public TreeSet(Comparator<? super E> comparator) {
        this.backingMap = new TreeMap<E, Object>(comparator);
    }

    public TreeSet(SortedSet<E> set) {
        this(set.comparator());
        Iterator it = set.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    @Override
    public boolean add(E object) {
        return this.backingMap.put(object, Boolean.TRUE) == null;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return super.addAll(collection);
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.backingMap.comparator();
    }

    @Override
    public boolean contains(Object object) {
        return this.backingMap.containsKey(object);
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.backingMap.keySet().iterator();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.descendingSet().iterator();
    }

    @Override
    public boolean remove(Object object) {
        return this.backingMap.remove(object) != null;
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public E first() {
        return (E)this.backingMap.firstKey();
    }

    @Override
    public E last() {
        return (E)this.backingMap.lastKey();
    }

    @Override
    public E pollFirst() {
        Map.Entry<E, Object> entry = this.backingMap.pollFirstEntry();
        return null == entry ? null : (E)entry.getKey();
    }

    @Override
    public E pollLast() {
        Map.Entry<E, Object> entry = this.backingMap.pollLastEntry();
        return null == entry ? null : (E)entry.getKey();
    }

    @Override
    public E higher(E e) {
        return this.backingMap.higherKey(e);
    }

    @Override
    public E lower(E e) {
        return this.backingMap.lowerKey(e);
    }

    @Override
    public E ceiling(E e) {
        return this.backingMap.ceilingKey(e);
    }

    @Override
    public E floor(E e) {
        return this.backingMap.floorKey(e);
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return null != this.descendingSet ? this.descendingSet : (this.descendingSet = new TreeSet<E>(this.backingMap.descendingMap()));
    }

    @Override
    public NavigableSet<E> subSet(E start, boolean startInclusive, E end, boolean endInclusive) {
        int compare;
        Comparator c = this.backingMap.comparator();
        int n = compare = c == null ? ((Comparable)start).compareTo(end) : c.compare(start, end);
        if (compare <= 0) {
            return new TreeSet<E>(this.backingMap.subMap(start, startInclusive, end, endInclusive));
        }
        throw new IllegalArgumentException();
    }

    @Override
    public NavigableSet<E> headSet(E end, boolean endInclusive) {
        Comparator c = this.backingMap.comparator();
        if (c == null) {
            ((Comparable)end).compareTo(end);
        } else {
            c.compare(end, end);
        }
        return new TreeSet<E>(this.backingMap.headMap(end, endInclusive));
    }

    @Override
    public NavigableSet<E> tailSet(E start, boolean startInclusive) {
        Comparator c = this.backingMap.comparator();
        if (c == null) {
            ((Comparable)start).compareTo(start);
        } else {
            c.compare(start, start);
        }
        return new TreeSet<E>(this.backingMap.tailMap(start, startInclusive));
    }

    @Override
    public SortedSet<E> subSet(E start, E end) {
        return this.subSet(start, true, end, false);
    }

    @Override
    public SortedSet<E> headSet(E end) {
        return this.headSet(end, false);
    }

    @Override
    public SortedSet<E> tailSet(E start) {
        return this.tailSet(start, true);
    }
}

