/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Character {
    public static final int MAX_RADIX = 36;
    public static final char MAX_VALUE = '\uffff';
    public static final int MIN_RADIX = 2;
    public static final char MIN_VALUE = '\u0000';
    public static final char MIN_HIGH_SURROGATE = '\ud800';
    public static final char MAX_HIGH_SURROGATE = '\udbff';
    public static final char MIN_LOW_SURROGATE = '\udc00';
    public static final char MAX_LOW_SURROGATE = '\udfff';
    public static final char MIN_SURROGATE = '\ud800';
    public static final char MAX_SURROGATE = '\udfff';
    public static final int MIN_SUPPLEMENTARY_CODE_POINT = 65536;
    public static final int MIN_CODE_POINT = 0;
    public static final int MAX_CODE_POINT = 0x10FFFF;
    public static final int SIZE = 16;

    public Character(char value) {
    }

    public char charValue() {
        return ' ';
    }

    public static int digit(char ch, int radix) {
        return 0;
    }

    public boolean equals(Object obj) {
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public static boolean isDigit(char ch) {
        return false;
    }

    public static boolean isLowerCase(char ch) {
        return false;
    }

    public static boolean isUpperCase(char ch) {
        return false;
    }

    public static char toLowerCase(char ch) {
        return ' ';
    }

    public String toString() {
        return null;
    }

    public static char toUpperCase(char ch) {
        return ' ';
    }

    public static boolean isValidCodePoint(int codePoint) {
        return 0 <= codePoint && 0x10FFFF >= codePoint;
    }

    public static boolean isSupplementaryCodePoint(int codePoint) {
        return 65536 <= codePoint && 0x10FFFF >= codePoint;
    }

    public static boolean isHighSurrogate(char ch) {
        return '\ud800' <= ch && '\udbff' >= ch;
    }

    public static boolean isLowSurrogate(char ch) {
        return '\udc00' <= ch && '\udfff' >= ch;
    }

    public static boolean isSurrogatePair(char high, char low) {
        return Character.isHighSurrogate(high) && Character.isLowSurrogate(low);
    }

    public static int charCount(int codePoint) {
        return codePoint >= 65536 ? 2 : 1;
    }

    public static int toCodePoint(char high, char low) {
        int h = (high & 0x3FF) << 10;
        int l = low & 0x3FF;
        return (h | l) + 65536;
    }

    public static int codePointAt(CharSequence seq, int index) {
        if (seq == null) {
            throw new NullPointerException();
        }
        int len = seq.length();
        if (index < 0 || index >= len) {
            throw new IndexOutOfBoundsException();
        }
        char high = seq.charAt(index++);
        if (index >= len) {
            return high;
        }
        char low = seq.charAt(index);
        if (Character.isSurrogatePair(high, low)) {
            return Character.toCodePoint(high, low);
        }
        return high;
    }

    public static int codePointAt(char[] seq, int index) {
        if (seq == null) {
            throw new NullPointerException();
        }
        int len = seq.length;
        if (index < 0 || index >= len) {
            throw new IndexOutOfBoundsException();
        }
        char high = seq[index++];
        if (index >= len) {
            return high;
        }
        char low = seq[index];
        if (Character.isSurrogatePair(high, low)) {
            return Character.toCodePoint(high, low);
        }
        return high;
    }

    public static int codePointAt(char[] seq, int index, int limit) {
        if (index < 0 || index >= limit || limit < 0 || limit > seq.length) {
            throw new IndexOutOfBoundsException();
        }
        char high = seq[index++];
        if (index >= limit) {
            return high;
        }
        char low = seq[index];
        if (Character.isSurrogatePair(high, low)) {
            return Character.toCodePoint(high, low);
        }
        return high;
    }

    public static int codePointBefore(CharSequence seq, int index) {
        if (seq == null) {
            throw new NullPointerException();
        }
        int len = seq.length();
        if (index < 1 || index > len) {
            throw new IndexOutOfBoundsException();
        }
        char low = seq.charAt(--index);
        if (--index < 0) {
            return low;
        }
        char high = seq.charAt(index);
        if (Character.isSurrogatePair(high, low)) {
            return Character.toCodePoint(high, low);
        }
        return low;
    }

    public static int codePointBefore(char[] seq, int index) {
        if (seq == null) {
            throw new NullPointerException();
        }
        int len = seq.length;
        if (index < 1 || index > len) {
            throw new IndexOutOfBoundsException();
        }
        char low = seq[--index];
        if (--index < 0) {
            return low;
        }
        char high = seq[index];
        if (Character.isSurrogatePair(high, low)) {
            return Character.toCodePoint(high, low);
        }
        return low;
    }

    public static int codePointBefore(char[] seq, int index, int start) {
        if (seq == null) {
            throw new NullPointerException();
        }
        int len = seq.length;
        if (index <= start || index > len || start < 0 || start >= len) {
            throw new IndexOutOfBoundsException();
        }
        char low = seq[--index];
        if (--index < start) {
            return low;
        }
        char high = seq[index];
        if (Character.isSurrogatePair(high, low)) {
            return Character.toCodePoint(high, low);
        }
        return low;
    }

    public static int toChars(int codePoint, char[] dst, int dstIndex) {
        if (!Character.isValidCodePoint(codePoint)) {
            throw new IllegalArgumentException();
        }
        if (dst == null) {
            throw new NullPointerException();
        }
        if (dstIndex < 0 || dstIndex >= dst.length) {
            throw new IndexOutOfBoundsException();
        }
        if (Character.isSupplementaryCodePoint(codePoint)) {
            if (dstIndex == dst.length - 1) {
                throw new IndexOutOfBoundsException();
            }
            int cpPrime = codePoint - 65536;
            int high = 0xD800 | cpPrime >> 10 & 0x3FF;
            int low = 0xDC00 | cpPrime & 0x3FF;
            dst[dstIndex] = (char)high;
            dst[dstIndex + 1] = (char)low;
            return 2;
        }
        dst[dstIndex] = (char)codePoint;
        return 1;
    }

    public static char[] toChars(int codePoint) {
        if (!Character.isValidCodePoint(codePoint)) {
            throw new IllegalArgumentException();
        }
        if (Character.isSupplementaryCodePoint(codePoint)) {
            int cpPrime = codePoint - 65536;
            int high = 0xD800 | cpPrime >> 10 & 0x3FF;
            int low = 0xDC00 | cpPrime & 0x3FF;
            return new char[]{(char)high, (char)low};
        }
        return new char[]{(char)codePoint};
    }

    public static int codePointCount(CharSequence seq, int beginIndex, int endIndex) {
        if (seq == null) {
            throw new NullPointerException();
        }
        int len = seq.length();
        if (beginIndex < 0 || endIndex > len || beginIndex > endIndex) {
            throw new IndexOutOfBoundsException();
        }
        int result = 0;
        for (int i = beginIndex; i < endIndex; ++i) {
            char c = seq.charAt(i);
            if (Character.isHighSurrogate(c) && ++i < endIndex && !Character.isLowSurrogate(c = seq.charAt(i))) {
                ++result;
            }
            ++result;
        }
        return result;
    }

    public static int codePointCount(char[] seq, int offset, int count) {
        if (seq == null) {
            throw new NullPointerException();
        }
        int len = seq.length;
        int endIndex = offset + count;
        if (offset < 0 || count < 0 || endIndex > len) {
            throw new IndexOutOfBoundsException();
        }
        int result = 0;
        for (int i = offset; i < endIndex; ++i) {
            char c = seq[i];
            if (Character.isHighSurrogate(c) && ++i < endIndex && !Character.isLowSurrogate(c = seq[i])) {
                ++result;
            }
            ++result;
        }
        return result;
    }

    public static int offsetByCodePoints(CharSequence seq, int index, int codePointOffset) {
        if (seq == null) {
            throw new NullPointerException();
        }
        int len = seq.length();
        if (index < 0 || index > len) {
            throw new IndexOutOfBoundsException();
        }
        if (codePointOffset == 0) {
            return index;
        }
        if (codePointOffset > 0) {
            int codePoints = codePointOffset;
            int i = index;
            while (codePoints > 0) {
                int next;
                --codePoints;
                if (i >= len) {
                    throw new IndexOutOfBoundsException();
                }
                if (Character.isHighSurrogate(seq.charAt(i)) && (next = i + 1) < len && Character.isLowSurrogate(seq.charAt(next))) {
                    ++i;
                }
                ++i;
            }
            return i;
        }
        int codePoints = -codePointOffset;
        int i = index;
        while (codePoints > 0) {
            int prev;
            --codePoints;
            if (--i < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (!Character.isLowSurrogate(seq.charAt(i)) || (prev = i - 1) < 0 || !Character.isHighSurrogate(seq.charAt(prev))) continue;
            --i;
        }
        return i;
    }

    public static int offsetByCodePoints(char[] seq, int start, int count, int index, int codePointOffset) {
        if (seq == null) {
            throw new NullPointerException();
        }
        int end = start + count;
        if (start < 0 || count < 0 || end > seq.length || index < start || index > end) {
            throw new IndexOutOfBoundsException();
        }
        if (codePointOffset == 0) {
            return index;
        }
        if (codePointOffset > 0) {
            int codePoints = codePointOffset;
            int i = index;
            while (codePoints > 0) {
                int next;
                --codePoints;
                if (i >= end) {
                    throw new IndexOutOfBoundsException();
                }
                if (Character.isHighSurrogate(seq[i]) && (next = i + 1) < end && Character.isLowSurrogate(seq[next])) {
                    ++i;
                }
                ++i;
            }
            return i;
        }
        int codePoints = -codePointOffset;
        int i = index;
        while (codePoints > 0) {
            int prev;
            --codePoints;
            if (--i < start) {
                throw new IndexOutOfBoundsException();
            }
            if (!Character.isLowSurrogate(seq[i]) || (prev = i - 1) < start || !Character.isHighSurrogate(seq[prev])) continue;
            --i;
        }
        return i;
    }

    public static char reverseBytes(char c) {
        return (char)(c << 8 | c >> 8);
    }

    public static Character valueOf(char i) {
        return null;
    }

    public static boolean isWhitespace(char c) {
        return Character.isWhitespace((int)c);
    }

    public static boolean isSpace(char ch) {
        switch (ch) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static boolean isSpaceChar(char ch) {
        return false;
    }

    public static boolean isWhitespace(int codePoint) {
        if (codePoint >= 28 && codePoint <= 32 || codePoint >= 9 && codePoint <= 13) {
            return true;
        }
        if (codePoint < 4096) {
            return false;
        }
        if (codePoint == 5760 || codePoint == 6158) {
            return true;
        }
        if (codePoint < 8192) {
            return false;
        }
        if (codePoint == 8199 || codePoint == 8239) {
            return false;
        }
        if (codePoint <= 65535) {
            return codePoint <= 8202 || codePoint == 8232 || codePoint == 8233 || codePoint == 8287 || codePoint == 12288;
        }
        return false;
    }
}

