/*
 * Decompiled with CFR 0.152.
 */
package com.codepine.api.testrail;

import com.google.common.base.Preconditions;

public class TestRailException
extends RuntimeException {
    private static final long serialVersionUID = -2131644110724458502L;
    private final int responseCode;

    TestRailException(int responseCode, String error) {
        super(responseCode + " - " + error);
        this.responseCode = responseCode;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    static class Builder {
        private int responseCode;
        private String error;

        Builder() {
        }

        public TestRailException build() {
            Preconditions.checkNotNull((Object)this.responseCode);
            Preconditions.checkNotNull((Object)this.error);
            return new TestRailException(this.responseCode, this.error);
        }

        public Builder setResponseCode(int responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }
    }
}

